/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.spf4j.base.Reflections;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;

@SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
public final class JavaMethodCall
implements Method {
    private static final Class<?>[] EMPTY_CL_ARR = new Class[0];
    private final String name;
    private final Class<?> objectClass;
    private final Object object;

    public JavaMethodCall(Class<?> clasz, String methodName) {
        this.name = methodName;
        this.objectClass = clasz;
        this.object = null;
    }

    public JavaMethodCall(Object object, String methodName) {
        this.name = methodName;
        this.objectClass = object.getClass();
        this.object = object;
    }

    @Override
    public Object invoke(ExecutionContext context, Object[] parameters) {
        try {
            int np = parameters.length;
            if (np > 0) {
                Object[] classes = new Class[np];
                for (int i = 0; i < np; ++i) {
                    classes[i] = parameters[i].getClass();
                }
                java.lang.reflect.Method m = Reflections.getCompatibleMethodCached(this.objectClass, (String)this.name, (Class[])classes);
                if (m == null) {
                    throw new NoSuchMethodException(this.objectClass.getName() + '.' + this.name + Arrays.toString(classes));
                }
                Class[] actTypes = Reflections.getParameterTypes((java.lang.reflect.Method)m);
                Class lastParamClass = actTypes[actTypes.length - 1];
                if (Reflections.canAssign((Class)lastParamClass, (Class)classes[classes.length - 1])) {
                    return m.invoke(this.object, parameters);
                }
                if (lastParamClass.isArray()) {
                    int lidx = actTypes.length - 1;
                    int l = np - lidx;
                    Object array = Array.newInstance(lastParamClass.getComponentType(), l);
                    for (int k = 0; k < l; ++k) {
                        Array.set(array, k, parameters[lidx + k]);
                    }
                    Object[] newParams = new Object[actTypes.length];
                    System.arraycopy(parameters, 0, newParams, 0, lidx);
                    newParams[lidx] = array;
                    return m.invoke(this.object, newParams);
                }
                throw new IllegalStateException();
            }
            return Reflections.getCompatibleMethodCached(this.objectClass, (String)this.name, (Class[])EMPTY_CL_ARR).invoke(this.object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    public String toString() {
        return "JavaMethodCall{name=" + this.name + ", objectClass=" + this.objectClass + ", object=" + this.object + '}';
    }
}

