/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.Queue;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;
import org.spf4j.zel.vm.VMASyncFuture;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.VMFuture;

@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
final class Channel {
    public static final Object EOF = new Object();
    private final Queue<Object> queue = new LinkedList<Object>();
    private final Queue<VMFuture<Object>> readers = new LinkedList<VMFuture<Object>>();
    private final VMExecutor exec;
    private boolean closed;

    Channel(VMExecutor exec) {
        this.exec = exec;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URV_UNRELATED_RETURN_VALUES"})
    public Object read() {
        Channel channel = this;
        synchronized (channel) {
            Object obj = this.queue.poll();
            if (obj == null) {
                VMASyncFuture fut = new VMASyncFuture();
                this.readers.add(fut);
                return fut;
            }
            if (obj == EOF) {
                this.queue.add(EOF);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object obj) {
        Channel channel = this;
        synchronized (channel) {
            if (this.closed) {
                throw new IllegalStateException("Channel is closed, cannot write " + obj + " into it");
            }
            VMFuture<Object> reader = this.readers.poll();
            if (reader != null) {
                reader.setResult(obj);
                this.exec.resumeSuspendables(reader);
            } else {
                this.queue.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Channel channel = this;
        synchronized (channel) {
            VMFuture<Object> reader;
            while ((reader = this.readers.poll()) != null) {
                reader.setResult(EOF);
                this.exec.resumeSuspendables(reader);
            }
            this.queue.add(EOF);
            this.closed = true;
        }
    }

    public String toString() {
        return "Channel{queue=" + this.queue + ", readers=" + this.readers + ", exec=" + this.exec + ", closed=" + this.closed + '}';
    }

    public static final class Factory
    implements Method {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public Object invoke(ExecutionContext context, Object[] parameters) {
            return new Channel(context.getExecService());
        }
    }
}

