/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.MemoryBuilder;
import org.spf4j.zel.vm.ParsingContext;
import org.spf4j.zel.vm.ProgramBuilder;

@SuppressFBWarnings(value={"CD_CIRCULAR_DEPENDENCY"})
public final class CompileContext
implements ParsingContext {
    private final ProgramBuilder prog;
    private final MemoryBuilder staticMemBuilder;
    private Instruction last;

    CompileContext(MemoryBuilder staticMemBuilder) {
        this.prog = new ProgramBuilder(staticMemBuilder);
        this.staticMemBuilder = staticMemBuilder;
    }

    @Override
    public void generateCode(ParsingContext.Location[] locs, Instruction ... args) {
        this.prog.addAll(args, Arrays.asList(locs));
        this.last = args[args.length - 1];
    }

    @Override
    public void generateCodeAll(ParsingContext parsingContext) {
        this.prog.addAll(parsingContext.getProgramBuilder());
    }

    @Override
    public int getAddress() {
        return this.prog.size();
    }

    @Override
    public ProgramBuilder getProgramBuilder() {
        return this.prog;
    }

    @Override
    public CompileContext createSubContext() {
        return new CompileContext(this.staticMemBuilder);
    }

    @Override
    public void staticSymbol(String name, Object object) {
        this.staticMemBuilder.addSymbol(name, object);
    }

    @Override
    public void staticSymbol(String name) {
        this.staticMemBuilder.addSymbol(name);
    }

    @Override
    public Instruction getLast() {
        return this.last;
    }

    @Override
    public void generateCode(ParsingContext.Location loc, Instruction instr) {
        this.prog.add(instr, loc);
        this.last = instr;
    }

    public String toString() {
        return "CompileContext{prog=" + this.prog + ", staticMemBuilder=" + this.staticMemBuilder + ", last=" + this.last + '}';
    }
}

