/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.LODAX;
import org.spf4j.zel.instr.LODAXF;
import org.spf4j.zel.instr.LODX;
import org.spf4j.zel.instr.LODXF;
import org.spf4j.zel.vm.Address;
import org.spf4j.zel.vm.Program;

public final class RefOptimizer
implements Function<Program, Program> {
    public static final Function<Program, Program> INSTANCE = new RefOptimizer();

    private RefOptimizer() {
    }

    @Override
    public Program apply(Program input) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null for " + this);
        }
        Instruction[] instructions = (Instruction[])input.getInstructions().clone();
        Map<String, Integer> lsym = input.getLocalSymbolTable();
        Map<String, Integer> gsym = input.getGlobalSymbolTable();
        for (int i = 0; i < instructions.length; ++i) {
            Address addr;
            String symbol;
            Instruction instr = instructions[i];
            if (LODX.class.equals(instr.getClass())) {
                symbol = ((LODX)instr).getSymbol();
                addr = RefOptimizer.getAddress(lsym, symbol, gsym);
                if (addr == null) continue;
                instructions[i] = new LODXF(addr);
                continue;
            }
            if (!LODAX.class.equals(instr.getClass()) || (addr = RefOptimizer.getAddress(lsym, symbol = ((LODAX)instr).getSymbol(), gsym)) == null) continue;
            instructions[i] = new LODAXF(addr);
        }
        return new Program(input.getName(), input.getGlobalSymbolTable(), input.getGlobalMem(), input.getLocalSymbolTable(), instructions, input.getDebug(), input.getSource(), input.getType(), input.getExecType(), input.hasDeterministicFunctions(), input.getParameterNamesInternal());
    }

    @Nullable
    private static Address getAddress(Map<String, Integer> lsym, String symbol, Map<String, Integer> gsym) {
        Address addr;
        Integer idx = lsym.get(symbol);
        if (idx == null) {
            idx = gsym.get(symbol);
            if (idx == null) {
                return null;
            }
            addr = new Address(idx, Address.Scope.GLOBAL);
        } else {
            addr = new Address(idx, Address.Scope.LOCAL);
        }
        return addr;
    }
}

