/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.ErrLog;
import org.spf4j.base.Pair;
import org.spf4j.base.Runtime;
import org.spf4j.base.ShutdownHooks;
import org.spf4j.base.ShutdownThread;
import org.spf4j.concurrent.CustomThreadFactory;
import org.spf4j.concurrent.NonPoolingExecutorService;
import org.spf4j.zel.vm.ExecAbortException;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMASyncFuture;
import org.spf4j.zel.vm.VMFuture;
import org.spf4j.zel.vm.VMSyncFuture;

@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public final class VMExecutor {
    private final Executor exec;
    private final ConcurrentMap<VMFuture<Object>, List<Pair<Suspendable<Object>, VMFuture<Object>>>> futToSuspMap = new ConcurrentHashMap<VMFuture<Object>, List<Pair<Suspendable<Object>, VMFuture<Object>>>>();

    public static <T> Suspendable<T> synchronize(final Suspendable<T> what) {
        return new Suspendable<T>(){
            private volatile boolean isRunning = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws SuspendedException, ExecutionException, InterruptedException {
                if (!this.isRunning) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.isRunning) {
                            this.isRunning = true;
                            try {
                                return what.call();
                            }
                            catch (SuspendedException e) {
                                this.isRunning = false;
                                throw e;
                            }
                        }
                    }
                }
                throw ExecAbortException.INSTANCE;
            }

            @Override
            public synchronized List<VMFuture<Object>> getSuspendedAt() {
                return what.getSuspendedAt();
            }
        };
    }

    public VMExecutor(Executor exec) {
        this.exec = exec;
    }

    public <T> Future<T> submitNonSuspendable(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        this.exec.execute(task);
        return task;
    }

    public <T> Future<T> submit(Suspendable<T> callable) {
        VMSyncFuture resultFuture = new VMSyncFuture();
        this.submit(callable, resultFuture);
        return resultFuture;
    }

    public <T> Future<T> submitInternal(Suspendable<T> callable) {
        VMASyncFuture resultFuture = new VMASyncFuture();
        this.submit(callable, resultFuture);
        return resultFuture;
    }

    @Nullable
    public List<Pair<Suspendable<Object>, VMFuture<Object>>> resumeSuspendables(VMFuture<Object> future) {
        List suspended = (List)this.futToSuspMap.remove(future);
        if (suspended != null) {
            for (Pair susp : suspended) {
                this.submit((Suspendable)susp.getFirst(), (VMFuture)susp.getSecond());
            }
        }
        return suspended;
    }

    private void addSuspendable(VMFuture<Object> futureSuspendedFor, Suspendable<Object> suspendedCallable, VMFuture<Object> suspendedCallableFuture) {
        List old;
        List suspended = (LinkedList)this.futToSuspMap.get(futureSuspendedFor);
        if (suspended == null && (old = (List)this.futToSuspMap.putIfAbsent(futureSuspendedFor, suspended = new LinkedList())) != null) {
            suspended = old;
        }
        while (true) {
            List old2;
            LinkedList<Pair> newList = new LinkedList<Pair>(suspended);
            newList.add(Pair.of(suspendedCallable, suspendedCallableFuture));
            if (this.futToSuspMap.replace(futureSuspendedFor, suspended, newList)) break;
            suspended = (List)this.futToSuspMap.get(futureSuspendedFor);
            if (suspended != null || (old2 = (List)this.futToSuspMap.putIfAbsent(futureSuspendedFor, suspended = new LinkedList())) == null) continue;
            suspended = old2;
        }
        if (futureSuspendedFor.isDone()) {
            this.resumeSuspendables(futureSuspendedFor);
        }
    }

    private <T> void submit(final Suspendable<T> callable, final VMFuture<T> future) {
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = callable.call();
                    future.setResult(result);
                    VMExecutor.this.resumeSuspendables(future);
                }
                catch (SuspendedException ex) {
                    for (VMFuture<Object> fut : callable.getSuspendedAt()) {
                        VMExecutor.this.addSuspendable(fut, callable, future);
                    }
                }
                catch (ExecutionException e) {
                    future.setExceptionResult(e);
                    VMExecutor.this.resumeSuspendables(future);
                }
                catch (InterruptedException | RuntimeException e) {
                    future.setExceptionResult(new ExecutionException(e));
                    VMExecutor.this.resumeSuspendables(future);
                }
            }
        });
    }

    public String toString() {
        return "VMExecutor{exec=" + this.exec + ", futToSuspMap=" + this.futToSuspMap + '}';
    }

    public static interface Suspendable<T>
    extends Callable<T> {
        @Override
        public T call() throws SuspendedException, ExecutionException, InterruptedException;

        public List<VMFuture<Object>> getSuspendedAt();
    }

    public static class Lazy {
        private static final ExecutorService DEF_EXEC = Lazy.init();
        public static final VMExecutor DEFAULT = new VMExecutor(DEF_EXEC);

        @SuppressFBWarnings(value={"HES_EXECUTOR_NEVER_SHUTDOWN"})
        private static ExecutorService init() {
            final ForkJoinPool fjp = new ForkJoinPool(Integer.getInteger("zel.pool.maxThreadNr", Runtime.NR_PROCESSORS * 2), new DefaultForkJoinWorkerThreadFactory(), new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    ErrLog.error((String)"Uncaucht Exception zel default executor", (Throwable)e);
                }
            }, true);
            if (!ShutdownThread.get().queueHook(ShutdownHooks.ShutdownPhase.JVM_SERVICES, (Runnable)new AbstractRunnable(true){

                public void doRun() throws InterruptedException {
                    fjp.shutdown();
                    fjp.awaitTermination(ShutdownThread.WAIT_FOR_SHUTDOWN_NANOS, TimeUnit.NANOSECONDS);
                    List<Runnable> remaining = fjp.shutdownNow();
                    if (remaining.size() > 0) {
                        ErrLog.error((String)("Remaining tasks: " + remaining));
                    }
                }
            })) {
                fjp.shutdownNow();
                return new NonPoolingExecutorService((ThreadFactory)new CustomThreadFactory("V<ShutdownExecutor", false));
            }
            return fjp;
        }

        static class DefaultForkJoinWorkerThreadFactory
        implements ForkJoinPool.ForkJoinWorkerThreadFactory {
            DefaultForkJoinWorkerThreadFactory() {
            }

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                return new ZelWorker(pool);
            }
        }

        static class ZelWorker
        extends ForkJoinWorkerThread {
            ZelWorker(ForkJoinPool pool) {
                super(pool);
            }
        }
    }
}

