/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Either;
import org.spf4j.zel.vm.ExecAbortException;
import org.spf4j.zel.vm.VMFuture;

@ThreadSafe
@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public class VMSyncFuture<T>
implements VMFuture<T> {
    private volatile Either<T, ? extends ExecutionException> result;

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isDone() {
        return this.result != null;
    }

    @Override
    @SuppressFBWarnings
    public final Either<T, ? extends ExecutionException> getResult() {
        return this.result;
    }

    @Override
    public final synchronized T get() throws InterruptedException, ExecutionException {
        while (this.result == null) {
            this.wait(1000L);
        }
        return (T)Either.processResult(this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis;
        long toWait = timeoutMillis = unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        VMSyncFuture vMSyncFuture = this;
        synchronized (vMSyncFuture) {
            while (toWait > 0L && this.result == null) {
                this.wait(toWait);
                toWait = timeoutMillis - (System.currentTimeMillis() - startTime);
            }
            if (this.result == null) {
                throw new TimeoutException("Timed out after " + timeout + " " + (Object)((Object)unit));
            }
            return (T)Either.processResult(this.result);
        }
    }

    @Override
    public final synchronized void setResult(T presult) {
        if (this.result != null) {
            throw new IllegalStateException("cannot set " + this.result + " result multiple times");
        }
        this.result = Either.left(presult);
        this.notifyAll();
    }

    @Override
    public final synchronized void setExceptionResult(ExecutionException eresult) {
        if (Throwables.getRootCause((Throwable)eresult) == ExecAbortException.INSTANCE) {
            return;
        }
        if (this.result != null) {
            throw new IllegalStateException("cannot set result " + this.result + " multiple times");
        }
        this.result = Either.right((Object)eresult);
        this.notifyAll();
    }

    public final String toString() {
        return "VMSyncFuture{result=" + this.result + '}';
    }
}

