/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.spf4j.base.Arrays;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.AssignableValue;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.SuspendedException;

public final class REF
extends Instruction {
    private static final long serialVersionUID = 1L;
    public static final Instruction INSTANCE = new REF();

    private REF() {
    }

    @Override
    public int execute(ExecutionContext context) throws ExecutionException, SuspendedException, InterruptedException {
        Object relativeTo;
        Object[] vals = context.tuple();
        context.popSyncStackVals(vals);
        Object ref = vals[1];
        Object relTo = vals[0];
        if (relTo instanceof AssignableValue) {
            HashMap obj = ((AssignableValue)relTo).get();
            if (obj == null) {
                obj = new HashMap();
                ((AssignableValue)relTo).assign(obj);
            }
            relativeTo = obj;
        } else {
            relativeTo = relTo;
        }
        if (relativeTo instanceof Map) {
            context.push(new MapDeref(relativeTo, ref));
        } else if (relativeTo instanceof Object[]) {
            context.push(new ArrayDeref(relativeTo, ref));
        } else {
            context.push(new JavaMethodDeref(relativeTo, ref, context));
        }
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return Arrays.EMPTY_OBJ_ARRAY;
    }

    private static final class JavaMethodDeref
    implements AssignableValue {
        private final Object relativeTo;
        private final Object ref;
        private final ExecutionContext ctx;

        JavaMethodDeref(Object relativeTo, Object ref, ExecutionContext ctx) {
            this.relativeTo = relativeTo;
            this.ref = ref;
            this.ctx = ctx;
        }

        @Override
        public void assign(Object object) {
            throw new UnsupportedOperationException("Cannot assign " + object + " to " + this.relativeTo + '.' + this.ref);
        }

        @Override
        public Object get() {
            return this.ctx.newJavaCall(this.relativeTo, (String)this.ref);
        }
    }

    private static final class ArrayDeref
    implements AssignableValue {
        private final Object relativeTo;
        private final Object ref;

        ArrayDeref(Object relativeTo, Object ref) {
            this.relativeTo = relativeTo;
            this.ref = ref;
        }

        @Override
        public void assign(Object object) {
            ((Object[])this.relativeTo)[((Number)this.ref).intValue()] = object;
        }

        @Override
        public Object get() {
            return ((Object[])this.relativeTo)[((Number)this.ref).intValue()];
        }
    }

    private static final class MapDeref
    implements AssignableValue {
        private final Object relativeTo;
        private final Object ref;

        MapDeref(Object relativeTo, Object ref) {
            this.relativeTo = relativeTo;
            this.ref = ref;
        }

        @Override
        public void assign(Object object) {
            ((Map)this.relativeTo).put(this.ref, object);
        }

        @Override
        public Object get() {
            return ((Map)this.relativeTo).get(this.ref);
        }
    }
}

