/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.filters;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.filters.CorsFilterResponse;
import org.spincast.core.filters.ICorsFilter;
import org.spincast.core.filters.ICorsFilterClient;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastFilters<R extends IRequestContext<?>>
implements ISpincastFilters<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastFilters.class);
    private final ICorsFilter corsFilter;

    @Inject
    public SpincastFilters(ICorsFilter corsFilter) {
        this.corsFilter = corsFilter;
    }

    protected ICorsFilter getCorsFilter() {
        return this.corsFilter;
    }

    @Override
    public void saveGeneratedResource(R context, String pathForGeneratedResource) {
        try {
            File resourceFile = new File(pathForGeneratedResource);
            if (resourceFile.exists()) {
                this.logger.info("The resource already exists. We don't save it here.");
                return;
            }
            if (200 != context.response().getStatusCode()) {
                this.logger.info("Nothing will be saved since the response code is not 200");
                return;
            }
            if (context.response().isHeadersSent()) {
                this.logger.warn("Headers sent, we can't save a copy of the generated resource! You will have to make sure that you save the generated resource by yourself, otherwise, a new version will be generated for each request!");
                return;
            }
            byte[] unsentBytes = context.response().getUnsentBytes();
            FileUtils.writeByteArrayToFile((File)resourceFile, (byte[])unsentBytes);
        }
        catch (Exception ex) {
            this.logger.error("Unable to save the generated resource '" + pathForGeneratedResource + "' :\n" + SpincastStatics.getStackTrace(ex));
        }
    }

    @Override
    public void addSecurityHeaders(R context) {
        context.response().addHeaderValue("X-Frame-Options", "SAMEORIGIN");
        context.response().addHeaderValue("x-content-type-options", "nosniff");
    }

    @Override
    public void cors(R context) {
        this.cors(context, this.getCorsDefaultAllowedOrigins(), this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins) {
        this.cors(context, allowedOrigins, this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        ICorsFilterClient corsFilterClient = this.createCorsFilterClient(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
        CorsFilterResponse corsResult = this.getCorsFilter().apply(corsFilterClient);
        if (corsResult == CorsFilterResponse.NOT_CORS) {
            return;
        }
        if (corsResult == CorsFilterResponse.HEADERS_ALREADY_SENT) {
            return;
        }
        if (corsResult == CorsFilterResponse.INVALID_CORS_REQUEST) {
            throw new SkipRemainingHandlersException();
        }
        if (corsResult == CorsFilterResponse.SIMPLE) {
            return;
        }
        if (corsResult == CorsFilterResponse.PREFLIGHT) {
            throw new SkipRemainingHandlersException();
        }
        throw new RuntimeException("Unmanaged cors result: " + (Object)((Object)corsResult));
    }

    protected ICorsFilterClient createCorsFilterClient(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        return new ICorsFilterClient((IRequestContext)context, allowCookies, maxAgeInSeconds, extraHeadersAllowedToBeSent, extraHeadersAllowedToBeRead, allowedOrigins, allowedMethods){
            final /* synthetic */ IRequestContext val$context;
            final /* synthetic */ boolean val$allowCookies;
            final /* synthetic */ int val$maxAgeInSeconds;
            final /* synthetic */ Set val$extraHeadersAllowedToBeSent;
            final /* synthetic */ Set val$extraHeadersAllowedToBeRead;
            final /* synthetic */ Set val$allowedOrigins;
            final /* synthetic */ Set val$allowedMethods;
            {
                this.val$context = iRequestContext;
                this.val$allowCookies = bl;
                this.val$maxAgeInSeconds = n;
                this.val$extraHeadersAllowedToBeSent = set;
                this.val$extraHeadersAllowedToBeRead = set2;
                this.val$allowedOrigins = set3;
                this.val$allowedMethods = set4;
            }

            @Override
            public void setStatusCode(int code) {
                this.val$context.response().setStatusCode(code);
            }

            @Override
            public void resetEverything() {
                this.val$context.response().resetEverything();
            }

            @Override
            public boolean requestContainsCookies() {
                Map<String, ICookie> cookies = this.val$context.cookies().getCookies();
                return cookies != null && cookies.size() > 0;
            }

            @Override
            public boolean isHeadersSent() {
                return this.val$context.response().isHeadersSent();
            }

            @Override
            public boolean isAllowCookies() {
                return this.val$allowCookies;
            }

            @Override
            public int getMaxAgeInSeconds() {
                return this.val$maxAgeInSeconds;
            }

            @Override
            public HttpMethod getHttpMethod() {
                return this.val$context.request().getHttpMethod();
            }

            @Override
            public String getHeaderFirst(String name) {
                return this.val$context.request().getHeaderFirst(name);
            }

            @Override
            public String getFullUrl() {
                return this.val$context.request().getFullUrl();
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeSent() {
                return this.val$extraHeadersAllowedToBeSent;
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeRead() {
                return this.val$extraHeadersAllowedToBeRead;
            }

            @Override
            public Set<String> getAllowedOrigins() {
                return this.val$allowedOrigins;
            }

            @Override
            public Set<HttpMethod> getAllowedMethods() {
                return this.val$allowedMethods;
            }

            @Override
            public void addHeaderValue(String name, String value) {
                this.val$context.response().addHeaderValue(name, value);
            }
        };
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected Set<String> getCorsDefaultAllowedOrigins() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeRead() {
        return null;
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeSent() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    protected boolean getCorsDefaultIsCookiesAllowed() {
        return true;
    }

    protected Set<HttpMethod> getCorsDefaultAllowedMethods() {
        return Sets.newHashSet((Object[])HttpMethod.values());
    }
}

