/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.ISpincastDictionary;
import org.spincast.core.controllers.IFrontController;
import org.spincast.core.controllers.SpincastFrontController;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.cookies.ICookiesRequestContextAddon;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.exchange.ICacheHeadersRequestContextAddon;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IRequestContextFactory;
import org.spincast.core.exchange.IRequestRequestContextAddon;
import org.spincast.core.exchange.IResponseRequestContextAddon;
import org.spincast.core.exchange.IVariablesRequestContextAddon;
import org.spincast.core.exchange.RequestContextBaseDeps;
import org.spincast.core.exchange.RequestContextType;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.ICorsFilter;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastRequestScope;
import org.spincast.core.guice.SpincastRequestScoped;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonArrayImmutable;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.json.IJsonObjectFactory;
import org.spincast.core.json.IJsonObjectImmutable;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonArrayImmutable;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectImmutable;
import org.spincast.core.locale.ILocaleResolver;
import org.spincast.core.routing.DefaultRouteParamAliasesBinder;
import org.spincast.core.routing.IETagFactory;
import org.spincast.core.routing.IRedirectRuleBuilderFactory;
import org.spincast.core.routing.IRouteBuilderFactory;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingRequestContextAddon;
import org.spincast.core.routing.IStaticResourceFactory;
import org.spincast.core.server.IServer;
import org.spincast.core.templating.ITemplatingEngine;
import org.spincast.core.templating.ITemplatingRequestContextAddon;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.utils.ssl.ISSLContextFactory;
import org.spincast.core.utils.ssl.SSLContextFactory;
import org.spincast.core.websocket.DefaultWebsocketContext;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.core.websocket.IWebsocketContextFactory;
import org.spincast.core.websocket.IWebsocketEndpointHandler;
import org.spincast.core.websocket.IWebsocketEndpointHandlerFactory;
import org.spincast.core.websocket.IWebsocketEndpointToControllerManager;
import org.spincast.core.websocket.IWebsocketRouteBuilderFactory;
import org.spincast.core.websocket.WebsocketContextType;
import org.spincast.core.websocket.WebsocketEndpointHandler;
import org.spincast.core.websocket.WebsocketEndpointToControllerManager;
import org.spincast.core.xml.IXmlManager;

public class SpincastCoreGuiceModule
extends SpincastGuiceModuleBase {
    protected final Logger logger = LoggerFactory.getLogger(SpincastCoreGuiceModule.class);
    private Type requestContextType;
    private Type websocketContextType;
    private final String[] mainArgs;

    public SpincastCoreGuiceModule() {
        this(null);
    }

    public SpincastCoreGuiceModule(String[] mainArgs) {
        if (mainArgs == null) {
            mainArgs = new String[]{};
        }
        this.mainArgs = mainArgs;
    }

    protected String[] getMainArgs() {
        return this.mainArgs;
    }

    protected void configure() {
        this.validateRequirements();
        this.bindMainArgs();
        this.bindRequestContextType();
        this.bindWebsocketContextType();
        this.bindSpincastRequestScope();
        this.bindRequestContextInRequestScope();
        this.bindRequestContextBaseDeps();
        this.bindDefaultPredefinedRouteParamPatternsBinder();
        this.bindRequestContextFactory();
        this.bindFrontController();
        this.bindSpincastUtilsClass();
        this.bindSpincastFilters();
        this.bindJsonObjectFactory();
        this.bindWebsocketEndpointHandlerFactory();
        this.bindWebsocketContextFactory();
        this.bindWebsocketEndpointToControllerManager();
        this.bindSSLContextFactory();
    }

    protected void validateRequirements() {
        this.requireBinding(IServer.class);
        this.requireBinding(this.parameterizeWithContextInterfaces(IRouter.class));
        this.requireBinding(Key.get((TypeLiteral)new TypeLiteral<IRouter<?, ?>>(){}));
        this.requireBinding(this.parameterizeWithContextInterfaces(IRouteBuilderFactory.class));
        this.requireBinding(this.parameterizeWithRequestContext(IStaticResourceFactory.class));
        this.requireBinding(this.parameterizeWithContextInterfaces(IRedirectRuleBuilderFactory.class));
        this.requireBinding(this.parameterizeWithContextInterfaces(IWebsocketRouteBuilderFactory.class));
        this.requireBinding(IETagFactory.class);
        this.requireBinding(ITemplatingEngine.class);
        this.requireBinding(IJsonManager.class);
        this.requireBinding(IXmlManager.class);
        this.requireBinding(ISpincastConfig.class);
        this.requireBinding(ISpincastDictionary.class);
        this.requireBinding(ICookieFactory.class);
        this.requireBinding(ILocaleResolver.class);
        this.requireBinding(this.parameterizeWithRequestContext(IRequestRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(IResponseRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(IRoutingRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(ICookiesRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(ITemplatingRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(IVariablesRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(ICacheHeadersRequestContextAddon.class));
    }

    protected void bindMainArgs() {
        this.bind((TypeLiteral)new TypeLiteral<String[]>(){}).annotatedWith(MainArgs.class).toInstance((Object)this.getMainArgs());
        this.bind((TypeLiteral)new TypeLiteral<List<String>>(){}).annotatedWith(MainArgs.class).toInstance(Arrays.asList(this.getMainArgs()));
    }

    protected void bindRequestContextType() {
        Type type = this.getRequestContextType();
        this.bind(Type.class).annotatedWith(RequestContextType.class).toInstance((Object)type);
    }

    protected void bindWebsocketContextType() {
        Type type = this.getWebsocketContextType();
        this.bind(Type.class).annotatedWith(WebsocketContextType.class).toInstance((Object)type);
    }

    protected void bindSpincastRequestScope() {
        this.bindScope(SpincastRequestScoped.class, SpincastGuiceScopes.REQUEST);
        this.bind(SpincastRequestScope.class).toInstance((Object)SpincastGuiceScopes.REQUEST);
    }

    protected void bindRequestContextInRequestScope() {
        Key key = Key.get((Type)this.getRequestContextType());
        this.bind(key).toProvider(SpincastRequestScope.getSeedErrorProvider(key)).in((Scope)SpincastGuiceScopes.REQUEST);
        TypeLiteral typeLiteral = new TypeLiteral<IRequestContext<?>>(){};
        this.bind(Key.get((TypeLiteral)typeLiteral)).toProvider(SpincastRequestScope.getSeedErrorProvider(Key.get((TypeLiteral)typeLiteral))).in((Scope)SpincastGuiceScopes.REQUEST);
    }

    protected void bindRequestContextBaseDeps() {
        this.bind(this.parameterizeWithRequestContext(RequestContextBaseDeps.class)).in(Scopes.SINGLETON);
    }

    @Override
    protected Type getRequestContextType() {
        if (this.requestContextType == null) {
            Key key = Key.get(this.getRequestContextImplementationClass());
            TypeLiteral requestContextTypeLiteral = key.getTypeLiteral().getSupertype(IRequestContext.class);
            this.requestContextType = ((ParameterizedType)requestContextTypeLiteral.getType()).getActualTypeArguments()[0];
        }
        return this.requestContextType;
    }

    @Override
    protected Type getWebsocketContextType() {
        if (this.websocketContextType == null) {
            Key key = Key.get(this.getWebsocketContextImplementationClass());
            TypeLiteral websocketContextTypeLiteral = key.getTypeLiteral().getSupertype(IWebsocketContext.class);
            this.websocketContextType = ((ParameterizedType)websocketContextTypeLiteral.getType()).getActualTypeArguments()[0];
        }
        return this.websocketContextType;
    }

    protected void bindSpincastFilters() {
        Key<SpincastFilters> key = this.getSpincastFiltersKey();
        try {
            key.getTypeLiteral().getSupertype(ISpincastFilters.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Filters Key must implement " + ISpincastFilters.class.getName() + " : " + key);
        }
        this.bind(this.parameterizeWithRequestContext(ISpincastFilters.class)).to(key).in(Scopes.SINGLETON);
        this.bind(ICorsFilter.class).to(this.getCorsFilterClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ICorsFilter> getCorsFilterClass() {
        return CorsFilter.class;
    }

    protected Key<SpincastFilters> getSpincastFiltersKey() {
        return this.parameterizeWithContextInterfaces(SpincastFilters.class);
    }

    protected void bindDefaultPredefinedRouteParamPatternsBinder() {
        this.bind(this.parameterizeWithContextInterfaces(DefaultRouteParamAliasesBinder.class)).asEagerSingleton();
    }

    protected void bindRequestContextFactory() {
        Key key = Key.get(this.getRequestContextImplementationClass());
        Key<IRequestContextFactory> requestContextFactoryKey = this.parameterizeWithRequestContext(IRequestContextFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement((Class)this.getRequestContextType(), annotation, key.getTypeLiteral()).build(requestContextFactoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement((Class)this.getRequestContextType(), key.getTypeLiteral()).build(requestContextFactoryKey));
        }
    }

    protected void bindFrontController() {
        Key<?> key = this.getFrontControllerKey();
        try {
            key.getTypeLiteral().getSupertype(IFrontController.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The front controller Key must implement " + IFrontController.class.getName() + " : " + key);
        }
        this.bind(IFrontController.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindSpincastUtilsClass() {
        Key<?> key = this.getSpincastUtilsKey();
        try {
            key.getTypeLiteral().getSupertype(ISpincastUtils.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Utils Key must implement " + ISpincastUtils.class.getName() + " : " + key);
        }
        this.bind(ISpincastUtils.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindJsonObjectFactory() {
        this.install(new FactoryModuleBuilder().implement(IJsonObject.class, this.getJsonObjectImplClass()).implement(IJsonObjectImmutable.class, this.getJsonObjectImmutableImplClass()).implement(IJsonArrayImmutable.class, this.getJsonArrayImmutableImplClass()).implement(IJsonArray.class, this.getJsonArrayImplClass()).build(IJsonObjectFactory.class));
    }

    protected Class<? extends IRequestContext<?>> getRequestContextImplementationClass() {
        return DefaultRequestContext.class;
    }

    protected Class<? extends IWebsocketContext<?>> getWebsocketContextImplementationClass() {
        return DefaultWebsocketContext.class;
    }

    protected Key<?> getFrontControllerKey() {
        return this.parameterizeWithContextInterfaces(SpincastFrontController.class);
    }

    protected Key<?> getSpincastUtilsKey() {
        return Key.get(SpincastUtils.class);
    }

    protected Class<? extends IJsonObject> getJsonObjectImplClass() {
        return JsonObject.class;
    }

    protected Class<? extends IJsonObjectImmutable> getJsonObjectImmutableImplClass() {
        return JsonObjectImmutable.class;
    }

    protected Class<? extends IJsonArray> getJsonArrayImplClass() {
        return JsonArray.class;
    }

    protected Class<? extends IJsonArrayImmutable> getJsonArrayImmutableImplClass() {
        return JsonArrayImmutable.class;
    }

    protected void bindWebsocketEndpointHandlerFactory() {
        Key<IWebsocketEndpointHandlerFactory> factoryKey = this.parameterizeWithContextInterfaces(IWebsocketEndpointHandlerFactory.class);
        this.install(new FactoryModuleBuilder().implement(IWebsocketEndpointHandler.class, this.getWebsocketEndpointHandlerKey().getTypeLiteral()).build(factoryKey));
    }

    protected Key<?> getWebsocketEndpointHandlerKey() {
        return this.parameterizeWithContextInterfaces(WebsocketEndpointHandler.class);
    }

    protected void bindWebsocketContextFactory() {
        Key<IWebsocketContextFactory> factoryKey = this.parameterizeWithWebsocketContext(IWebsocketContextFactory.class);
        this.install(new FactoryModuleBuilder().implement((Class)this.getWebsocketContextType(), this.getWebsocketContextImplementationClass()).build(factoryKey));
    }

    protected void bindWebsocketEndpointToControllerManager() {
        this.bind(IWebsocketEndpointToControllerManager.class).to(this.getWebsocketEndpointToControllerKeysMapClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends IWebsocketEndpointToControllerManager> getWebsocketEndpointToControllerKeysMapClass() {
        return WebsocketEndpointToControllerManager.class;
    }

    protected void bindSSLContextFactory() {
        this.bind(ISSLContextFactory.class).to(this.getSSLContextFactoryClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ISSLContextFactory> getSSLContextFactoryClass() {
        return SSLContextFactory.class;
    }
}

