/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.json.Immutable;
import org.spincast.core.json.JsonObjectArrayBase;
import org.spincast.core.utils.ISpincastUtils;

public class JsonObject
extends JsonObjectArrayBase
implements IJsonObject {
    protected final Logger logger = LoggerFactory.getLogger(JsonObject.class);
    private final Map<String, ?> initialMap;
    private final Map<String, Object> map;

    @AssistedInject
    public JsonObject(IJsonManager jsonManager, ISpincastUtils spincastUtils) {
        this(null, jsonManager, spincastUtils);
    }

    @AssistedInject
    public JsonObject(@Assisted @Nullable Map<String, ?> initialMap, IJsonManager jsonManager, ISpincastUtils spincastUtils) {
        super(jsonManager, spincastUtils);
        if (initialMap == null) {
            initialMap = new HashMap();
        }
        this.initialMap = initialMap;
        this.map = new HashMap<String, Object>();
    }

    @Inject
    protected void init() {
        this.addInitialMap();
    }

    protected void addInitialMap() {
        if (this.initialMap != null) {
            for (Map.Entry<String, ?> entry : this.initialMap.entrySet()) {
                this.putConvert(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Map<String, Object> getMap() {
        return this.map;
    }

    @Override
    public IJsonObject put(String key, String value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Integer value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Long value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Float value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Double value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Boolean value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, BigDecimal value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, byte[] value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, Date value) {
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, IJsonObject value) {
        return this.put(key, value, false);
    }

    @Override
    public IJsonObject put(String key, IJsonObject value, boolean clone) {
        if (value != null && (clone || value instanceof Immutable)) {
            value = value.clone(true);
        }
        return this.putAsIs(key, value);
    }

    @Override
    public IJsonObject put(String key, IJsonArray value) {
        return this.put(key, value, false);
    }

    @Override
    public IJsonObject put(String key, IJsonArray value, boolean clone) {
        if (value != null && (clone || value instanceof Immutable)) {
            value = value.clone(true);
        }
        return this.putAsIs(key, value);
    }

    protected IJsonObject putAsIs(String key, Object value) {
        Objects.requireNonNull(key, "The key can't be NULL");
        this.getMap().put(key, value);
        return this;
    }

    @Override
    public IJsonObject putConvert(String key, Object value) {
        return this.putConvert(key, value, false);
    }

    @Override
    public IJsonObject putConvert(String key, Object value, boolean clone) {
        Objects.requireNonNull(key, "The key can't be NULL");
        value = clone || value instanceof Immutable ? this.getJsonManager().clone(value, true) : this.getJsonManager().convertToNativeType(value);
        this.putAsIs(key, value);
        return this;
    }

    @Override
    public IJsonObject merge(Map<String, Object> map) {
        return this.merge(map, false);
    }

    @Override
    public IJsonObject merge(Map<String, Object> map, boolean clone) {
        if (map == null) {
            return this;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.putConvert(entry.getKey(), entry.getValue(), clone);
        }
        return this;
    }

    @Override
    public IJsonObject merge(IJsonObject jsonObj) {
        return this.merge(jsonObj, false);
    }

    @Override
    public IJsonObject merge(IJsonObject jsonObj, boolean clone) {
        if (jsonObj == null) {
            return this;
        }
        for (Map.Entry entry : jsonObj) {
            this.putConvert((String)entry.getKey(), entry.getValue(), clone);
        }
        return this;
    }

    @Override
    public IJsonObject remove(String key) {
        this.getMap().remove(key);
        return this;
    }

    @Override
    public IJsonObject removeAll() {
        this.getMap().clear();
        return this;
    }

    @Override
    public boolean isKeyExists(String key) {
        return this.getMap().containsKey(key);
    }

    protected <T> T getArrayFirst(String key, boolean hasDefaultValue, T defaultValue, IFirstElementGetter<T> firstElementGetter) {
        IJsonArray array = this.getJsonArray(key, null);
        if (array == null) {
            if (hasDefaultValue) {
                return defaultValue;
            }
            return null;
        }
        return firstElementGetter.get(array, hasDefaultValue, defaultValue);
    }

    @Override
    public IJsonObject getArrayFirstJsonObject(String key) {
        return this.getArrayFirstJsonObject(key, false, null);
    }

    @Override
    public IJsonObject getArrayFirstJsonObject(String key, IJsonObject defaultValue) {
        return this.getArrayFirstJsonObject(key, true, defaultValue);
    }

    protected IJsonObject getArrayFirstJsonObject(String key, boolean hasDefaultValue, IJsonObject defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<IJsonObject>(){

            @Override
            public IJsonObject get(IJsonArray array, boolean hasDefaultValue, IJsonObject defaultValue) {
                if (hasDefaultValue) {
                    return array.getJsonObject(0, defaultValue);
                }
                return array.getJsonObject(0);
            }
        });
    }

    @Override
    public IJsonArray getArrayFirstJsonArray(String key) {
        return this.getArrayFirstJsonArray(key, false, null);
    }

    @Override
    public IJsonArray getArrayFirstJsonArray(String key, IJsonArray defaultValue) {
        return this.getArrayFirstJsonArray(key, true, defaultValue);
    }

    protected IJsonArray getArrayFirstJsonArray(String key, boolean hasDefaultValue, IJsonArray defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<IJsonArray>(){

            @Override
            public IJsonArray get(IJsonArray array, boolean hasDefaultValue, IJsonArray defaultValue) {
                if (hasDefaultValue) {
                    return array.getJsonArray(0, defaultValue);
                }
                return array.getJsonArray(0);
            }
        });
    }

    @Override
    public String getArrayFirstString(String key) {
        return this.getArrayFirstString(key, false, null);
    }

    @Override
    public String getArrayFirstString(String key, String defaultValue) {
        return this.getArrayFirstString(key, true, defaultValue);
    }

    protected String getArrayFirstString(String key, boolean hasDefaultValue, String defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<String>(){

            @Override
            public String get(IJsonArray array, boolean hasDefaultValue, String defaultValue) {
                if (hasDefaultValue) {
                    return array.getString(0, defaultValue);
                }
                return array.getString(0);
            }
        });
    }

    @Override
    public Integer getArrayFirstInteger(String key) {
        return this.getArrayFirstInteger(key, false, null);
    }

    @Override
    public Integer getArrayFirstInteger(String key, Integer defaultValue) {
        return this.getArrayFirstInteger(key, true, defaultValue);
    }

    protected Integer getArrayFirstInteger(String key, boolean hasDefaultValue, Integer defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Integer>(){

            @Override
            public Integer get(IJsonArray array, boolean hasDefaultValue, Integer defaultValue) {
                if (hasDefaultValue) {
                    return array.getInteger(0, defaultValue);
                }
                return array.getInteger(0);
            }
        });
    }

    @Override
    public Long getArrayFirstLong(String key) {
        return this.getArrayFirstLong(key, false, null);
    }

    @Override
    public Long getArrayFirstLong(String key, Long defaultValue) {
        return this.getArrayFirstLong(key, true, defaultValue);
    }

    protected Long getArrayFirstLong(String key, boolean hasDefaultValue, Long defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Long>(){

            @Override
            public Long get(IJsonArray array, boolean hasDefaultValue, Long defaultValue) {
                if (hasDefaultValue) {
                    return array.getLong(0, defaultValue);
                }
                return array.getLong(0);
            }
        });
    }

    @Override
    public Double getArrayFirstDouble(String key) {
        return this.getArrayFirstDouble(key, false, null);
    }

    @Override
    public Double getArrayFirstDouble(String key, Double defaultValue) {
        return this.getArrayFirstDouble(key, true, defaultValue);
    }

    protected Double getArrayFirstDouble(String key, boolean hasDefaultValue, Double defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Double>(){

            @Override
            public Double get(IJsonArray array, boolean hasDefaultValue, Double defaultValue) {
                if (hasDefaultValue) {
                    return array.getDouble(0, defaultValue);
                }
                return array.getDouble(0);
            }
        });
    }

    @Override
    public Float getArrayFirstFloat(String key) {
        return this.getArrayFirstFloat(key, false, null);
    }

    @Override
    public Float getArrayFirstFloat(String key, Float defaultValue) {
        return this.getArrayFirstFloat(key, true, defaultValue);
    }

    protected Float getArrayFirstFloat(String key, boolean hasDefaultValue, Float defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Float>(){

            @Override
            public Float get(IJsonArray array, boolean hasDefaultValue, Float defaultValue) {
                if (hasDefaultValue) {
                    return array.getFloat(0, defaultValue);
                }
                return array.getFloat(0);
            }
        });
    }

    @Override
    public Boolean getArrayFirstBoolean(String key) {
        return this.getArrayFirstBoolean(key, false, null);
    }

    @Override
    public Boolean getArrayFirstBoolean(String key, Boolean defaultValue) {
        return this.getArrayFirstBoolean(key, true, defaultValue);
    }

    protected Boolean getArrayFirstBoolean(String key, boolean hasDefaultValue, Boolean defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Boolean>(){

            @Override
            public Boolean get(IJsonArray array, boolean hasDefaultValue, Boolean defaultValue) {
                if (hasDefaultValue) {
                    return array.getBoolean(0, defaultValue);
                }
                return array.getBoolean(0);
            }
        });
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(String key) {
        return this.getArrayFirstBigDecimal(key, false, null);
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(String key, BigDecimal defaultValue) {
        return this.getArrayFirstBigDecimal(key, true, defaultValue);
    }

    protected BigDecimal getArrayFirstBigDecimal(String key, boolean hasDefaultValue, BigDecimal defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<BigDecimal>(){

            @Override
            public BigDecimal get(IJsonArray array, boolean hasDefaultValue, BigDecimal defaultValue) {
                if (hasDefaultValue) {
                    return array.getBigDecimal(0, defaultValue);
                }
                return array.getBigDecimal(0);
            }
        });
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(String key) {
        return this.getArrayFirstBytesFromBase64String(key, false, null);
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(String key, byte[] defaultValue) {
        return this.getArrayFirstBytesFromBase64String(key, true, defaultValue);
    }

    protected byte[] getArrayFirstBytesFromBase64String(String key, boolean hasDefaultValue, byte[] defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<byte[]>(){

            @Override
            public byte[] get(IJsonArray array, boolean hasDefaultValue, byte[] defaultValue) {
                if (hasDefaultValue) {
                    return array.getBytesFromBase64String(0, defaultValue);
                }
                return array.getBytesFromBase64String(0);
            }
        });
    }

    @Override
    public Date getArrayFirstDate(String key) {
        return this.getArrayFirstDate(key, false, null);
    }

    @Override
    public Date getArrayFirstDate(String key, Date defaultValue) {
        return this.getArrayFirstDate(key, true, defaultValue);
    }

    protected Date getArrayFirstDate(String key, boolean hasDefaultValue, Date defaultValue) {
        return this.getArrayFirst(key, hasDefaultValue, defaultValue, new IFirstElementGetter<Date>(){

            @Override
            public Date get(IJsonArray array, boolean hasDefaultValue, Date defaultValue) {
                if (hasDefaultValue) {
                    return array.getDate(0, defaultValue);
                }
                return array.getDate(0);
            }
        });
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.getMap().entrySet().iterator();
    }

    @Override
    public IJsonObject clone() {
        return this.clone(true);
    }

    @Override
    public IJsonObject clone(boolean mutable) {
        return this.getJsonManager().cloneJsonObject(this, mutable);
    }

    @Override
    protected Object getElement(String keyPosition, boolean hasDefaultValue, Object defaultValue) {
        if (this.isKeyExists(keyPosition)) {
            return this.getMap().get(keyPosition);
        }
        if (hasDefaultValue) {
            return defaultValue;
        }
        return null;
    }

    @Override
    public Map<String, Object> convertToPlainMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof IJsonObject) {
                value = ((IJsonObject)((Object)value)).convertToPlainMap();
            } else if (value instanceof IJsonArray) {
                value = ((IJsonArray)((Object)value)).convertToPlainList();
            }
            map.put(entry.getKey(), value);
        }
        return map;
    }

    protected static interface IFirstElementGetter<T> {
        public T get(IJsonArray var1, boolean var2, T var3);
    }
}

