/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.validation.JsonObjectValidationBuilderKey;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderArray;
import org.spincast.core.validation.ValidationBuilderCore;
import org.spincast.core.validation.ValidationBuilderKeyDefault;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSet;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class JsonObjectValidationBuilderKeyDefault
extends ValidationBuilderKeyDefault
implements JsonObjectValidationBuilderKey {
    private final JsonObjectOrArray validatedObject;

    @AssistedInject
    public JsonObjectValidationBuilderKeyDefault(@Assisted ValidationSet validationSet, @Assisted JsonObjectOrArray validatedObject, @Assisted SimpleValidator validator, ValidationFactory validationFactory) {
        super(validationSet, validator, validationFactory);
        this.validatedObject = validatedObject;
    }

    protected JsonObjectOrArray getValidatedObject() {
        return this.validatedObject;
    }

    @Override
    public ValidationBuilderCore jsonPath(String jsonPath) {
        if (StringUtils.isBlank((CharSequence)jsonPath)) {
            throw new RuntimeException("The JsonPath can't be empty.");
        }
        Object elementToValidate = this.getValidatedObject().getObject(jsonPath);
        return this.getValidationFactory().createValidationBuilderCore(this.getValidationSet(), this.getValidator(), jsonPath, elementToValidate);
    }

    @Override
    public ValidationBuilderArray jsonPathAll(String jsonPath) {
        return this.jsonPathAll(jsonPath, jsonPath);
    }

    @Override
    public ValidationBuilderArray jsonPathAll(String jsonPath, String validationKey) {
        if (StringUtils.isBlank((CharSequence)jsonPath)) {
            throw new RuntimeException("The JsonPath can't be empty.");
        }
        if (StringUtils.isBlank((CharSequence)validationKey)) {
            throw new RuntimeException("The validationKey can't be empty.");
        }
        boolean elemenseWasNotAnArray = false;
        Object obj = this.getValidatedObject().getObject(jsonPath);
        if (obj != null && !(obj instanceof JsonArray)) {
            elemenseWasNotAnArray = true;
            obj = null;
        }
        JsonArray array = (JsonArray)obj;
        return this.getValidationFactory().createValidationBuilderArray(this.getValidationSet(), this.getValidator(), validationKey, array, elemenseWasNotAnArray);
    }
}

