/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import com.google.inject.util.Modules;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.spincast.core.guice.SpincastGuiceModuleBase;

public class GuiceModuleUtils {
    private Module module;
    private List<Element> elements;

    public GuiceModuleUtils(Module module) {
        Objects.requireNonNull(module, "The module can't be NULL");
        this.module = module;
    }

    public GuiceModuleUtils(Set<Module> modules) {
        this(Modules.combine(modules));
    }

    public GuiceModuleUtils(Module ... modules) {
        this(Modules.combine((Module[])modules));
    }

    protected Module getModule() {
        return this.module;
    }

    protected List<Element> getElements() {
        if (this.elements == null) {
            this.elements = Elements.getElements((Module[])new Module[]{this.module});
        }
        return this.elements;
    }

    public boolean isKeyBound(Class<?> clazz) {
        return this.isKeyBound(Key.get(clazz));
    }

    public boolean isKeyBound(final Key<?> keyToCheck) {
        final boolean[] keyFound = new boolean[]{false};
        for (Element element : this.getElements()) {
            if (keyFound[0]) break;
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    Key key = binding.getKey();
                    if (key.equals((Object)keyToCheck)) {
                        keyFound[0] = true;
                    }
                    return null;
                }
            });
        }
        return keyFound[0];
    }

    public <T> Class<? extends T> getBindingTarget(Key<T> specificKey) {
        Objects.requireNonNull(specificKey, "The key can't be NULL");
        Set<Class<T>> boundClasses = this.getBoundClasses(null, specificKey);
        if (boundClasses == null || boundClasses.size() == 0) {
            return null;
        }
        return boundClasses.iterator().next();
    }

    public <T> Class<? extends T> getBindingTarget(Class<T> specificClass) {
        return this.getBindingTarget(Key.get(specificClass));
    }

    public <T> Set<Class<? extends T>> getBoundClassesExtending(Class<? extends T> parentType) {
        Objects.requireNonNull(parentType, "The parent type can't be NULL");
        return this.getBoundClasses(parentType, null);
    }

    protected <T> Set<Class<? extends T>> getBoundClasses(final Class<? extends T> parentType, final Key<?> specificKey) {
        final HashSet<Class<? extends T>> bindings = new HashSet<Class<? extends T>>();
        for (Element element : this.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <B> Void visit(Binding<B> binding) {
                    binding.acceptTargetVisitor((BindingTargetVisitor)new DefaultBindingTargetVisitor<B, Void>(){

                        public Void visit(InstanceBinding<? extends B> instanceBinding) {
                            Key key = instanceBinding.getKey();
                            Object instance = instanceBinding.getInstance();
                            if (instance instanceof Class) {
                                Class bindingClass = (Class)instance;
                                if (specificKey != null) {
                                    if (specificKey.equals((Object)key)) {
                                        Class temp = bindingClass;
                                        bindings.add(temp);
                                    }
                                } else if (parentType.isAssignableFrom(bindingClass)) {
                                    Class temp = bindingClass;
                                    bindings.add(temp);
                                }
                            }
                            return null;
                        }

                        public Void visit(UntargettedBinding<? extends B> untargettedBinding) {
                            Key key = untargettedBinding.getKey();
                            Class keyClass = key.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals((Object)key)) {
                                    Class temp = keyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(keyClass)) {
                                Class temp = keyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }

                        public Void visit(LinkedKeyBinding<? extends B> linkedKeyBinding) {
                            Key bindingKey = linkedKeyBinding.getKey();
                            Class bindingKeyClass = bindingKey.getTypeLiteral().getRawType();
                            Key linkedKey = linkedKeyBinding.getLinkedKey();
                            Class linkedKeyClass = linkedKey.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals((Object)bindingKey)) {
                                    Class temp = linkedKeyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(bindingKeyClass)) {
                                Class temp = linkedKeyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }
                    });
                    return null;
                }
            });
        }
        return bindings;
    }

    public static <T> SpincastGuiceModuleBase createInterceptorModule(final Class<T> toIntercept, final Class<? extends T> implementationClass) {
        Method[] toInterceptMethods;
        Objects.requireNonNull(toIntercept, "The Class to intercept can't be NULL");
        Objects.requireNonNull(implementationClass, "The implementation class can't be NULL");
        final HashMap<String, Method> toInterceptMethodsMap = new HashMap<String, Method>();
        for (Method toInterceptMethod : toInterceptMethods = toIntercept.getDeclaredMethods()) {
            toInterceptMethodsMap.put(toInterceptMethod.getName(), toInterceptMethod);
        }
        return new SpincastGuiceModuleBase(){

            protected void configure() {
                MethodInterceptor interceptor = new MethodInterceptor(){
                    @Inject
                    protected Provider<Injector> injector;
                    private T implementation;

                    public T getImplementation() {
                        if (this.implementation == null) {
                            this.implementation = ((Injector)this.injector.get()).getInstance(implementationClass);
                        }
                        return this.implementation;
                    }

                    public Object invoke(MethodInvocation invocation) throws Throwable {
                        Method method = invocation.getMethod();
                        if (!toInterceptMethodsMap.containsKey(method.getName())) {
                            return invocation.proceed();
                        }
                        Method toInterceptMethod = (Method)toInterceptMethodsMap.get(method.getName());
                        return toInterceptMethod.invoke(this.getImplementation(), invocation.getArguments());
                    }
                };
                this.requestInjection(interceptor);
                AbstractMatcher<Class> matcher = new AbstractMatcher<Class>(){
                    Matcher<Class> matcherToIntercept;
                    Matcher<Class> matcherImpl;
                    {
                        this.matcherToIntercept = Matchers.subclassesOf((Class)toIntercept);
                        this.matcherImpl = Matchers.subclassesOf((Class)implementationClass);
                    }

                    public boolean matches(Class t) {
                        return this.matcherToIntercept.matches((Object)t) && !this.matcherImpl.matches((Object)t);
                    }
                };
                this.bindInterceptor((Matcher)matcher, Matchers.any(), new MethodInterceptor[]{interceptor});
            }
        };
    }
}

