/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exceptions.CantConvertException;
import org.spincast.core.json.ElementTransformer;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectDefault;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.ToJsonArrayConvertible;
import org.spincast.core.json.ToJsonObjectConvertible;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.validation.ValidationFactory;

public abstract class JsonObjectArrayBase
implements JsonObjectOrArray {
    protected final Logger logger = LoggerFactory.getLogger(JsonObjectArrayBase.class);
    private final JsonManager jsonManager;
    private final SpincastUtils spincastUtils;
    private final ObjectConverter objectConverter;
    private final boolean mutable;
    protected final Object defaultElementValidator = new Object();
    private Map<String, JsonPathCachingItem> jsonPathCachingMap;
    private ElementTransformer trimTransformer;
    private final ValidationFactory validationFactory;

    public JsonObjectArrayBase(boolean mutable, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter, ValidationFactory validationFactory) {
        this.mutable = mutable;
        this.jsonManager = jsonManager;
        this.spincastUtils = spincastUtils;
        this.objectConverter = objectConverter;
        this.validationFactory = validationFactory;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    protected Object getdefaultElementValidator() {
        return this.defaultElementValidator;
    }

    protected Map<String, JsonPathCachingItem> getJsonPathCachingMap() {
        if (this.jsonPathCachingMap == null) {
            this.jsonPathCachingMap = new HashMap<String, JsonPathCachingItem>();
        }
        return this.jsonPathCachingMap;
    }

    @Override
    public Object getObject(String jsonPath) {
        return this.getObject(jsonPath, false, null, true);
    }

    @Override
    public Object getObject(String jsonPath, Object defaultElement) {
        return this.getObject(jsonPath, true, defaultElement, true);
    }

    public Object getObjectNoKeyParsing(String jsonPath) {
        return this.getObject(jsonPath, false, null, false);
    }

    public Object getObjectNoKeyParsing(String jsonPath, Object defaultElement) {
        return this.getObject(jsonPath, true, defaultElement, false);
    }

    protected Object getObject(String jsonPath, boolean hasdefaultElement, Object defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return val;
    }

    @Override
    public JsonObject getJsonObject(String jsonPath) {
        return this.getJsonObject(jsonPath, false, null);
    }

    @Override
    public JsonObject getJsonObjectOrEmpty(String jsonPath) {
        JsonObject defaultObj = this.getJsonManager().create();
        JsonObject obj = this.getJsonObject(jsonPath, defaultObj);
        if (obj == null) {
            obj = defaultObj;
        }
        return obj;
    }

    @Override
    public JsonObject getJsonObject(String jsonPath, JsonObject defaultElement) {
        return this.getJsonObject(jsonPath, true, defaultElement);
    }

    protected JsonObject getJsonObject(String jsonPath, boolean hasdefaultElement, JsonObject defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getJsonObjectFromObject(val);
    }

    public JsonObject getJsonObjectNoKeyParsing(String jsonPath) {
        return this.getJsonObject(jsonPath, false, null, false);
    }

    public JsonObject getJsonObjectNoKeyParsing(String jsonPath, JsonObject defaultElement) {
        return this.getJsonObject(jsonPath, true, defaultElement, false);
    }

    public JsonObject getJsonObjectOrEmptyNoKeyParsing(String jsonPath) {
        JsonObject defaultObj = this.getJsonManager().create();
        JsonObject obj = this.getJsonObject(jsonPath, true, defaultObj, false);
        if (obj == null) {
            obj = defaultObj;
        }
        return obj;
    }

    protected JsonObject getJsonObject(String jsonPath, boolean hasdefaultElement, JsonObject defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getJsonObjectFromObject(val);
    }

    protected JsonObject getJsonObjectFromObject(Object object) {
        return this.getObjectConverter().convertToJsonObject(object);
    }

    @Override
    public JsonArray getJsonArray(String jsonPath) {
        return this.getJsonArray(jsonPath, false, null, true);
    }

    @Override
    public JsonArray getJsonArrayOrEmpty(String jsonPath) {
        JsonArray defaultArray = this.getJsonManager().createArray();
        JsonArray array = this.getJsonArray(jsonPath, defaultArray);
        if (array == null) {
            array = defaultArray;
        }
        return array;
    }

    @Override
    public JsonArray getJsonArray(String jsonPath, JsonArray defaultElement) {
        return this.getJsonArray(jsonPath, true, defaultElement, true);
    }

    public JsonArray getJsonArrayNoKeyParsing(String jsonPath) {
        return this.getJsonArray(jsonPath, false, null, false);
    }

    public JsonArray getJsonArrayNoKeyParsing(String jsonPath, JsonArray defaultElement) {
        return this.getJsonArray(jsonPath, true, defaultElement, false);
    }

    public JsonArray getJsonArrayOrEmptyNoKeyParsing(String jsonPath) {
        JsonArray defaultArray = this.getJsonManager().createArray();
        JsonArray array = this.getJsonArray(jsonPath, true, this.getJsonManager().createArray(), false);
        if (array == null) {
            array = defaultArray;
        }
        return array;
    }

    protected JsonArray getJsonArray(String jsonPath, boolean hasdefaultElement, JsonArray defaultElement, boolean parseJsonPath) {
        Objects.requireNonNull(jsonPath, "The jsonPath can't be NULL");
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getJsonArrayFromObject(val);
    }

    protected JsonArray getJsonArrayFromObject(Object object) {
        return this.getObjectConverter().convertToJsonArray(object);
    }

    @Override
    public String getString(String jsonPath) {
        return this.getString(jsonPath, false, null);
    }

    @Override
    public String getString(String jsonPath, String defaultElement) {
        return this.getString(jsonPath, true, defaultElement);
    }

    protected String getString(String jsonPath, boolean hasdefaultElement, String defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getStringFromObject(val);
    }

    public String getStringNoKeyParsing(String jsonPath) {
        return this.getString(jsonPath, false, null, false);
    }

    public String getStringNoKeyParsing(String jsonPath, String defaultElement) {
        return this.getString(jsonPath, true, defaultElement, false);
    }

    protected String getString(String jsonPath, boolean hasdefaultElement, String defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getStringFromObject(val);
    }

    protected String getStringFromObject(Object object) {
        return this.getObjectConverter().convertToString(object);
    }

    @Override
    public Integer getInteger(String jsonPath) {
        return this.getIntegerElement(jsonPath, false, null);
    }

    @Override
    public Integer getInteger(String jsonPath, Integer defaultElement) {
        return this.getIntegerElement(jsonPath, true, defaultElement);
    }

    protected Integer getIntegerElement(String jsonPath, boolean hasdefaultElement, Integer defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getIntegerFromObject(val);
    }

    public Integer getIntegerNoKeyParsing(String jsonPath) {
        return this.getInteger(jsonPath, false, null, false);
    }

    public Integer getIntegerNoKeyParsing(String jsonPath, Integer defaultElement) {
        return this.getInteger(jsonPath, true, defaultElement, false);
    }

    protected Integer getInteger(String jsonPath, boolean hasdefaultElement, Integer defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getIntegerFromObject(val);
    }

    protected Integer getIntegerFromObject(Object object) {
        return this.getObjectConverter().convertToInteger(object);
    }

    @Override
    public Long getLong(String jsonPath) {
        return this.getLongElement(jsonPath, false, null);
    }

    @Override
    public Long getLong(String jsonPath, Long defaultElement) {
        return this.getLongElement(jsonPath, true, defaultElement);
    }

    protected Long getLongElement(String jsonPath, boolean hasdefaultElement, Long defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getLongFromObject(val);
    }

    public Long getLongNoKeyParsing(String jsonPath) {
        return this.getLong(jsonPath, false, null, false);
    }

    public Long getLongNoKeyParsing(String jsonPath, Long defaultElement) {
        return this.getLong(jsonPath, true, defaultElement, false);
    }

    protected Long getLong(String jsonPath, boolean hasdefaultElement, Long defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getLongFromObject(val);
    }

    protected Long getLongFromObject(Object object) {
        return this.getObjectConverter().convertToLong(object);
    }

    @Override
    public Float getFloat(String jsonPath) {
        return this.getFloatElement(jsonPath, false, null);
    }

    @Override
    public Float getFloat(String jsonPath, Float defaultElement) {
        return this.getFloatElement(jsonPath, true, defaultElement);
    }

    protected Float getFloatElement(String jsonPath, boolean hasdefaultElement, Float defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getFloatFromObject(val);
    }

    public Float getFloatNoKeyParsing(String jsonPath) {
        return this.getFloat(jsonPath, false, null, false);
    }

    public Float getFloatNoKeyParsing(String jsonPath, Float defaultElement) {
        return this.getFloat(jsonPath, true, defaultElement, false);
    }

    protected Float getFloat(String jsonPath, boolean hasdefaultElement, Float defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getFloatFromObject(val);
    }

    protected Float getFloatFromObject(Object object) {
        return this.getObjectConverter().convertToFloat(object);
    }

    @Override
    public Double getDouble(String jsonPath) {
        return this.getDoubleElement(jsonPath, false, null);
    }

    @Override
    public Double getDouble(String jsonPath, Double defaultElement) {
        return this.getDoubleElement(jsonPath, true, defaultElement);
    }

    protected Double getDoubleElement(String jsonPath, boolean hasdefaultElement, Double defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getDoubleFromObject(val);
    }

    public Double getDoubleNoKeyParsing(String jsonPath) {
        return this.getDouble(jsonPath, false, null, false);
    }

    public Double getDoubleNoKeyParsing(String jsonPath, Double defaultElement) {
        return this.getDouble(jsonPath, true, defaultElement, false);
    }

    protected Double getDouble(String jsonPath, boolean hasdefaultElement, Double defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getDoubleFromObject(val);
    }

    protected Double getDoubleFromObject(Object object) {
        return this.getObjectConverter().convertToDouble(object);
    }

    @Override
    public Boolean getBoolean(String jsonPath) {
        return this.getBooleanElement(jsonPath, false, null);
    }

    @Override
    public Boolean getBoolean(String jsonPath, Boolean defaultElement) {
        return this.getBooleanElement(jsonPath, true, defaultElement);
    }

    protected Boolean getBooleanElement(String jsonPath, boolean hasdefaultElement, Boolean defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getBooleanFromObject(val);
    }

    public Boolean getBooleanNoKeyParsing(String jsonPath) {
        return this.getBoolean(jsonPath, false, null, false);
    }

    public Boolean getBooleanNoKeyParsing(String jsonPath, Boolean defaultElement) {
        return this.getBoolean(jsonPath, true, defaultElement, false);
    }

    protected Boolean getBoolean(String jsonPath, boolean hasdefaultElement, Boolean defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getBooleanFromObject(val);
    }

    protected Boolean getBooleanFromObject(Object object) {
        return this.getObjectConverter().convertToBoolean(object);
    }

    @Override
    public BigDecimal getBigDecimal(String jsonPath) {
        return this.getBigDecimalElement(jsonPath, false, null);
    }

    @Override
    public BigDecimal getBigDecimal(String jsonPath, BigDecimal defaultElement) {
        return this.getBigDecimalElement(jsonPath, true, defaultElement);
    }

    protected BigDecimal getBigDecimalElement(String jsonPath, boolean hasdefaultElement, BigDecimal defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getBigDecimalFromObject(val);
    }

    public BigDecimal getBigDecimalNoKeyParsing(String jsonPath) {
        return this.getBigDecimal(jsonPath, false, null, false);
    }

    public BigDecimal getBigDecimalNoKeyParsing(String jsonPath, BigDecimal defaultElement) {
        return this.getBigDecimal(jsonPath, true, defaultElement, false);
    }

    protected BigDecimal getBigDecimal(String jsonPath, boolean hasdefaultElement, BigDecimal defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getBigDecimalFromObject(val);
    }

    protected BigDecimal getBigDecimalFromObject(Object object) {
        return this.getObjectConverter().convertToBigDecimal(object);
    }

    @Override
    public byte[] getBytesFromBase64String(String jsonPath) {
        return this.getBytesFromBase64StringElement(jsonPath, false, null);
    }

    @Override
    public byte[] getBytesFromBase64String(String jsonPath, byte[] defaultElement) {
        return this.getBytesFromBase64StringElement(jsonPath, true, defaultElement);
    }

    protected byte[] getBytesFromBase64StringElement(String jsonPath, boolean hasdefaultElement, byte[] defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getBytesFromBase64StringValueFromObject(val);
    }

    public byte[] getBytesFromBase64StringNoKeyParsing(String jsonPath) {
        return this.getBytesFromBase64String(jsonPath, false, null, false);
    }

    public byte[] getBytesFromBase64StringNoKeyParsing(String jsonPath, byte[] defaultElement) {
        return this.getBytesFromBase64String(jsonPath, true, defaultElement, false);
    }

    protected byte[] getBytesFromBase64String(String jsonPath, boolean hasdefaultElement, byte[] defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getBytesFromBase64StringValueFromObject(val);
    }

    protected byte[] getBytesFromBase64StringValueFromObject(Object object) {
        return this.getObjectConverter().convertBase64StringToByteArray(object);
    }

    @Override
    public Date getDate(String jsonPath) {
        return this.getDateElement(jsonPath, false, null);
    }

    @Override
    public Date getDate(String jsonPath, Date defaultElement) {
        return this.getDateElement(jsonPath, true, defaultElement);
    }

    protected Date getDateElement(String jsonPath, boolean hasdefaultElement, Date defaultElement) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, true);
        return this.getDateFromObject(val);
    }

    public Date getDateNoKeyParsing(String jsonPath) {
        return this.getDate(jsonPath, false, null, false);
    }

    public Date getDateNoKeyParsing(String jsonPath, Date defaultElement) {
        return this.getDate(jsonPath, true, defaultElement, false);
    }

    protected Date getDate(String jsonPath, boolean hasdefaultElement, Date defaultElement, boolean parseJsonPath) {
        Object val = this.getElement(jsonPath, hasdefaultElement, defaultElement, parseJsonPath);
        return this.getDateFromObject(val);
    }

    protected Date getDateFromObject(Object object) {
        return this.getObjectConverter().convertToDateFromJsonDateFormat(object);
    }

    protected <T> T getArrayFirst(String jsonPath, boolean parseJsonPath, boolean hasdefaultElement, T defaultElement, JsonObjectDefault.IFirstElementGetter<T> firstElementGetter) {
        JsonArray array = parseJsonPath ? this.getJsonArray(jsonPath, null) : this.getJsonArrayNoKeyParsing(jsonPath, null);
        if (array == null) {
            if (hasdefaultElement) {
                return defaultElement;
            }
            return null;
        }
        return firstElementGetter.get(array, hasdefaultElement, defaultElement);
    }

    @Override
    public String getArrayFirstString(String key) {
        return this.getArrayFirstString(key, true, false, null);
    }

    @Override
    public String getArrayFirstString(String key, String defaultElement) {
        return this.getArrayFirstString(key, true, true, defaultElement);
    }

    public String getArrayFirstStringNoKeyParsing(String key) {
        return this.getArrayFirstString(key, false, false, null);
    }

    public String getArrayFirstStringNoKeyParsing(String key, String defaultElement) {
        return this.getArrayFirstString(key, false, true, defaultElement);
    }

    protected String getArrayFirstString(String key, boolean parseJsonPath, boolean hasdefaultElement, String defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<String>(){

            @Override
            public String get(JsonArray array, boolean hasdefaultElement, String defaultElement) {
                if (hasdefaultElement) {
                    return array.getString(0, defaultElement);
                }
                return array.getString(0);
            }
        });
    }

    @Override
    public String toJsonString() {
        return this.toJsonString(false);
    }

    @Override
    public String toJsonString(boolean pretty) {
        return this.getJsonManager().toJsonString(this, pretty);
    }

    public String toString() {
        return this.toJsonString();
    }

    @Override
    public JsonObject getArrayFirstJsonObject(String key) {
        return this.getArrayFirstJsonObject(key, true, false, null);
    }

    @Override
    public JsonObject getArrayFirstJsonObject(String key, JsonObject defaultElement) {
        return this.getArrayFirstJsonObject(key, true, true, defaultElement);
    }

    public JsonObject getArrayFirstJsonObjectNoKeyParsing(String key) {
        return this.getArrayFirstJsonObject(key, false, false, null);
    }

    public JsonObject getArrayFirstJsonObjectNoKeyParsing(String key, JsonObject defaultElement) {
        return this.getArrayFirstJsonObject(key, false, true, defaultElement);
    }

    protected JsonObject getArrayFirstJsonObject(String key, boolean parseJsonPath, boolean hasdefaultElement, JsonObject defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<JsonObject>(){

            @Override
            public JsonObject get(JsonArray array, boolean hasdefaultElement, JsonObject defaultElement) {
                if (hasdefaultElement) {
                    return array.getJsonObject(0, defaultElement);
                }
                return array.getJsonObject(0);
            }
        });
    }

    @Override
    public JsonArray getArrayFirstJsonArray(String key) {
        return this.getArrayFirstJsonArray(key, true, false, null);
    }

    @Override
    public JsonArray getArrayFirstJsonArray(String key, JsonArray defaultElement) {
        return this.getArrayFirstJsonArray(key, true, true, defaultElement);
    }

    public JsonArray getArrayFirstJsonArrayNoKeyParsing(String key) {
        return this.getArrayFirstJsonArray(key, false, false, null);
    }

    public JsonArray getArrayFirstJsonArrayNoKeyParsing(String key, JsonArray defaultElement) {
        return this.getArrayFirstJsonArray(key, false, true, defaultElement);
    }

    protected JsonArray getArrayFirstJsonArray(String key, boolean parseJsonPath, boolean hasdefaultElement, JsonArray defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<JsonArray>(){

            @Override
            public JsonArray get(JsonArray array, boolean hasdefaultElement, JsonArray defaultElement) {
                if (hasdefaultElement) {
                    return array.getJsonArray(0, defaultElement);
                }
                return array.getJsonArray(0);
            }
        });
    }

    @Override
    public Integer getArrayFirstInteger(String key) {
        return this.getArrayFirstInteger(key, true, false, null);
    }

    @Override
    public Integer getArrayFirstInteger(String key, Integer defaultElement) {
        return this.getArrayFirstInteger(key, true, true, defaultElement);
    }

    public Integer getArrayFirstIntegerNoKeyParsing(String key) {
        return this.getArrayFirstInteger(key, false, false, null);
    }

    public Integer getArrayFirstIntegerNoKeyParsing(String key, Integer defaultElement) {
        return this.getArrayFirstInteger(key, false, true, defaultElement);
    }

    protected Integer getArrayFirstInteger(String key, boolean parseJsonPath, boolean hasdefaultElement, Integer defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Integer>(){

            @Override
            public Integer get(JsonArray array, boolean hasdefaultElement, Integer defaultElement) {
                if (hasdefaultElement) {
                    return array.getInteger(0, defaultElement);
                }
                return array.getInteger(0);
            }
        });
    }

    @Override
    public Long getArrayFirstLong(String key) {
        return this.getArrayFirstLong(key, true, false, null);
    }

    @Override
    public Long getArrayFirstLong(String key, Long defaultElement) {
        return this.getArrayFirstLong(key, true, true, defaultElement);
    }

    public Long getArrayFirstLongNoKeyParsing(String key) {
        return this.getArrayFirstLong(key, false, false, null);
    }

    public Long getArrayFirstLongNoKeyParsing(String key, Long defaultElement) {
        return this.getArrayFirstLong(key, false, true, defaultElement);
    }

    protected Long getArrayFirstLong(String key, boolean parseJsonPath, boolean hasdefaultElement, Long defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Long>(){

            @Override
            public Long get(JsonArray array, boolean hasdefaultElement, Long defaultElement) {
                if (hasdefaultElement) {
                    return array.getLong(0, defaultElement);
                }
                return array.getLong(0);
            }
        });
    }

    @Override
    public Double getArrayFirstDouble(String key) {
        return this.getArrayFirstDouble(key, true, false, null);
    }

    @Override
    public Double getArrayFirstDouble(String key, Double defaultElement) {
        return this.getArrayFirstDouble(key, true, true, defaultElement);
    }

    public Double getArrayFirstDoubleNoKeyParsing(String key) {
        return this.getArrayFirstDouble(key, false, false, null);
    }

    public Double getArrayFirstDoubleNoKeyParsing(String key, Double defaultElement) {
        return this.getArrayFirstDouble(key, false, true, defaultElement);
    }

    protected Double getArrayFirstDouble(String key, boolean parseJsonPath, boolean hasdefaultElement, Double defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Double>(){

            @Override
            public Double get(JsonArray array, boolean hasdefaultElement, Double defaultElement) {
                if (hasdefaultElement) {
                    return array.getDouble(0, defaultElement);
                }
                return array.getDouble(0);
            }
        });
    }

    @Override
    public Float getArrayFirstFloat(String key) {
        return this.getArrayFirstFloat(key, true, false, null);
    }

    @Override
    public Float getArrayFirstFloat(String key, Float defaultElement) {
        return this.getArrayFirstFloat(key, true, true, defaultElement);
    }

    public Float getArrayFirstFloatNoKeyParsing(String key) {
        return this.getArrayFirstFloat(key, false, false, null);
    }

    public Float getArrayFirstFloatNoKeyParsing(String key, Float defaultElement) {
        return this.getArrayFirstFloat(key, false, true, defaultElement);
    }

    protected Float getArrayFirstFloat(String key, boolean parseJsonPath, boolean hasdefaultElement, Float defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Float>(){

            @Override
            public Float get(JsonArray array, boolean hasdefaultElement, Float defaultElement) {
                if (hasdefaultElement) {
                    return array.getFloat(0, defaultElement);
                }
                return array.getFloat(0);
            }
        });
    }

    @Override
    public Boolean getArrayFirstBoolean(String key) {
        return this.getArrayFirstBoolean(key, true, false, null);
    }

    @Override
    public Boolean getArrayFirstBoolean(String key, Boolean defaultElement) {
        return this.getArrayFirstBoolean(key, true, true, defaultElement);
    }

    public Boolean getArrayFirstBooleanNoKeyParsing(String key) {
        return this.getArrayFirstBoolean(key, false, false, null);
    }

    public Boolean getArrayFirstBooleanNoKeyParsing(String key, Boolean defaultElement) {
        return this.getArrayFirstBoolean(key, false, true, defaultElement);
    }

    protected Boolean getArrayFirstBoolean(String key, boolean parseJsonPath, boolean hasdefaultElement, Boolean defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Boolean>(){

            @Override
            public Boolean get(JsonArray array, boolean hasdefaultElement, Boolean defaultElement) {
                if (hasdefaultElement) {
                    return array.getBoolean(0, defaultElement);
                }
                return array.getBoolean(0);
            }
        });
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(String key) {
        return this.getArrayFirstBigDecimal(key, true, false, null);
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(String key, BigDecimal defaultElement) {
        return this.getArrayFirstBigDecimal(key, true, true, defaultElement);
    }

    public BigDecimal getArrayFirstBigDecimalNoKeyParsing(String key) {
        return this.getArrayFirstBigDecimal(key, false, false, null);
    }

    public BigDecimal getArrayFirstBigDecimalNoKeyParsing(String key, BigDecimal defaultElement) {
        return this.getArrayFirstBigDecimal(key, false, true, defaultElement);
    }

    protected BigDecimal getArrayFirstBigDecimal(String key, boolean parseJsonPath, boolean hasdefaultElement, BigDecimal defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<BigDecimal>(){

            @Override
            public BigDecimal get(JsonArray array, boolean hasdefaultElement, BigDecimal defaultElement) {
                if (hasdefaultElement) {
                    return array.getBigDecimal(0, defaultElement);
                }
                return array.getBigDecimal(0);
            }
        });
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(String key) {
        return this.getArrayFirstBytesFromBase64String(key, true, false, null);
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(String key, byte[] defaultElement) {
        return this.getArrayFirstBytesFromBase64String(key, true, true, defaultElement);
    }

    public byte[] getArrayFirstBytesFromBase64StringNoKeyParsing(String key) {
        return this.getArrayFirstBytesFromBase64String(key, false, false, null);
    }

    public byte[] getArrayFirstBytesFromBase64StringNoKeyParsing(String key, byte[] defaultElement) {
        return this.getArrayFirstBytesFromBase64String(key, false, true, defaultElement);
    }

    protected byte[] getArrayFirstBytesFromBase64String(String key, boolean parseJsonPath, boolean hasdefaultElement, byte[] defaultElement) {
        return this.getArrayFirst(key, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<byte[]>(){

            @Override
            public byte[] get(JsonArray array, boolean hasdefaultElement, byte[] defaultElement) {
                if (hasdefaultElement) {
                    return array.getBytesFromBase64String(0, defaultElement);
                }
                return array.getBytesFromBase64String(0);
            }
        });
    }

    @Override
    public Date getArrayFirstDate(String key) {
        return this.getArrayFirstDate(key, true, false, null);
    }

    @Override
    public Date getArrayFirstDate(String key, Date defaultElement) {
        return this.getArrayFirstDate(key, true, true, defaultElement);
    }

    public Date getArrayFirstDateNoKeyParsing(String key) {
        return this.getArrayFirstDate(key, false, false, null);
    }

    public Date getArrayFirstDateNoKeyParsing(String key, Date defaultElement) {
        return this.getArrayFirstDate(key, false, true, defaultElement);
    }

    protected Date getArrayFirstDate(String jsonPath, boolean parseJsonPath, boolean hasdefaultElement, Date defaultElement) {
        return this.getArrayFirst(jsonPath, parseJsonPath, hasdefaultElement, defaultElement, new JsonObjectDefault.IFirstElementGetter<Date>(){

            @Override
            public Date get(JsonArray array, boolean hasdefaultElement, Date defaultElement) {
                if (hasdefaultElement) {
                    return array.getDate(0, defaultElement);
                }
                return array.getDate(0);
            }
        });
    }

    @Override
    public boolean isCanBeConvertedToString(String jsonPath) {
        return this.isCanBeConvertedToString(jsonPath, true);
    }

    public boolean isCanBeConvertedToStringNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToString(jsonPath, false);
    }

    protected boolean isCanBeConvertedToString(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToString(object);
    }

    @Override
    public boolean isCanBeConvertedToInteger(String jsonPath) {
        return this.isCanBeConvertedToInteger(jsonPath, true);
    }

    public boolean isCanBeConvertedToIntegerNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToInteger(jsonPath, false);
    }

    protected boolean isCanBeConvertedToInteger(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToInteger(object);
    }

    @Override
    public boolean isCanBeConvertedToLong(String jsonPath) {
        return this.isCanBeConvertedToLong(jsonPath, true);
    }

    public boolean isCanBeConvertedToLongNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToLong(jsonPath, false);
    }

    protected boolean isCanBeConvertedToLong(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToLong(object);
    }

    @Override
    public boolean isCanBeConvertedToFloat(String jsonPath) {
        return this.isCanBeConvertedToFloat(jsonPath, true);
    }

    public boolean isCanBeConvertedToFloatNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToFloat(jsonPath, false);
    }

    protected boolean isCanBeConvertedToFloat(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToFloat(object);
    }

    @Override
    public boolean isCanBeConvertedToDouble(String jsonPath) {
        return this.isCanBeConvertedToDouble(jsonPath, true);
    }

    public boolean isCanBeConvertedToDoubleNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToDouble(jsonPath, false);
    }

    protected boolean isCanBeConvertedToDouble(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToDouble(object);
    }

    @Override
    public boolean isCanBeConvertedToBoolean(String jsonPath) {
        return this.isCanBeConvertedToBoolean(jsonPath, true);
    }

    public boolean isCanBeConvertedToBooleanNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToBoolean(jsonPath, false);
    }

    protected boolean isCanBeConvertedToBoolean(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToBoolean(object);
    }

    @Override
    public boolean isCanBeConvertedToBigDecimal(String jsonPath) {
        return this.isCanBeConvertedToBigDecimal(jsonPath, true);
    }

    public boolean isCanBeConvertedToBigDecimalNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToBigDecimal(jsonPath, false);
    }

    protected boolean isCanBeConvertedToBigDecimal(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToBigDecimal(object);
    }

    @Override
    public boolean isCanBeConvertedToByteArray(String jsonPath) {
        return this.isCanBeConvertedToByteArray(jsonPath, true);
    }

    public boolean isCanBeConvertedToByteArrayNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToByteArray(jsonPath, false);
    }

    protected boolean isCanBeConvertedToByteArray(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToByteArray(object);
    }

    @Override
    public boolean isCanBeConvertedToDate(String jsonPath) {
        return this.isCanBeConvertedToDate(jsonPath, true);
    }

    public boolean isCanBeConvertedToDateNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToDate(jsonPath, false);
    }

    protected boolean isCanBeConvertedToDate(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToDateFromJsonDateFormat(object);
    }

    @Override
    public boolean isCanBeConvertedToJsonObject(String jsonPath) {
        return this.isCanBeConvertedToJsonObject(jsonPath, true);
    }

    public boolean isCanBeConvertedToJsonObjectNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToJsonObject(jsonPath, false);
    }

    protected boolean isCanBeConvertedToJsonObject(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToJsonObject(object);
    }

    @Override
    public boolean isCanBeConvertedToJsonArray(String jsonPath) {
        return this.isCanBeConvertedToJsonArray(jsonPath, true);
    }

    public boolean isCanBeConvertedToJsonArrayNoKeyParsing(String jsonPath) {
        return this.isCanBeConvertedToJsonArray(jsonPath, false);
    }

    protected boolean isCanBeConvertedToJsonArray(String jsonPath, boolean parseKey) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), parseKey);
        return object != this.getdefaultElementValidator() && this.getObjectConverter().isCanBeConvertedToJsonArray(object);
    }

    @Override
    public boolean isOfTypeString(String jsonPath) {
        return this.isOfTypeString(jsonPath, true);
    }

    public boolean isOfTypeStringNoKeyParsing(String jsonPath) {
        return this.isOfTypeString(jsonPath, false);
    }

    public boolean isOfTypeString(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof String;
    }

    @Override
    public boolean isOfTypeInteger(String jsonPath) {
        return this.isOfTypeInteger(jsonPath, true);
    }

    public boolean isOfTypeIntegerNoKeyParsing(String jsonPath) {
        return this.isOfTypeInteger(jsonPath, false);
    }

    public boolean isOfTypeInteger(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Integer;
    }

    @Override
    public boolean isOfTypeLong(String jsonPath) {
        return this.isOfTypeLong(jsonPath, true);
    }

    public boolean isOfTypeLongNoKeyParsing(String jsonPath) {
        return this.isOfTypeLong(jsonPath, false);
    }

    public boolean isOfTypeLong(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Long;
    }

    @Override
    public boolean isOfTypeFloat(String jsonPath) {
        return this.isOfTypeFloat(jsonPath, true);
    }

    public boolean isOfTypeFloatNoKeyParsing(String jsonPath) {
        return this.isOfTypeFloat(jsonPath, false);
    }

    public boolean isOfTypeFloat(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Float;
    }

    @Override
    public boolean isOfTypeDouble(String jsonPath) {
        return this.isOfTypeDouble(jsonPath, true);
    }

    public boolean isOfTypeDoubleNoKeyParsing(String jsonPath) {
        return this.isOfTypeDouble(jsonPath, false);
    }

    public boolean isOfTypeDouble(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Double;
    }

    @Override
    public boolean isOfTypeBoolean(String jsonPath) {
        return this.isOfTypeBoolean(jsonPath, true);
    }

    public boolean isOfTypeBooleanNoKeyParsing(String jsonPath) {
        return this.isOfTypeBoolean(jsonPath, false);
    }

    public boolean isOfTypeBoolean(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Boolean;
    }

    @Override
    public boolean isOfTypeBigDecimal(String jsonPath) {
        return this.isOfTypeeBigDecimal(jsonPath, true);
    }

    public boolean isOfTypeBigDecimalNoKeyParsing(String jsonPath) {
        return this.isOfTypeeBigDecimal(jsonPath, false);
    }

    public boolean isOfTypeeBigDecimal(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof BigDecimal;
    }

    @Override
    public boolean isOfTypeByteArray(String jsonPath, boolean acceptBase64StringToo) {
        return this.isOfTypeByteArray(jsonPath, acceptBase64StringToo, true);
    }

    public boolean isOfTypeByteArrayNoKeyParsing(String jsonPath, boolean acceptBase64StringToo) {
        return this.isOfTypeByteArray(jsonPath, acceptBase64StringToo, false);
    }

    public boolean isOfTypeByteArray(String jsonPath, boolean acceptBase64StringToo, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        if (val == null || val instanceof byte[]) {
            return true;
        }
        if (!acceptBase64StringToo || !(val instanceof String)) {
            return false;
        }
        String valStr = (String)val;
        try {
            this.getBytesFromBase64StringValueFromObject(valStr);
            return true;
        }
        catch (CantConvertException ex) {
            return false;
        }
    }

    @Override
    public boolean isOfTypeDate(String jsonPath) {
        return this.isOfTypeDate(jsonPath, true);
    }

    public boolean isOfTypeDateNoKeyParsing(String jsonPath) {
        return this.isOfTypeDate(jsonPath, false);
    }

    public boolean isOfTypeDate(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof Date;
    }

    @Override
    public boolean isOfTypeJsonObject(String jsonPath) {
        return this.isOfTypeJsonObject(jsonPath, true);
    }

    public boolean isOfTypeJsonObjectNoKeyParsing(String jsonPath) {
        return this.isOfTypeJsonObject(jsonPath, false);
    }

    public boolean isOfTypeJsonObject(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof JsonObject;
    }

    @Override
    public boolean isOfTypeJsonArray(String jsonPath) {
        return this.isOfTypeJsonArray(jsonPath, true);
    }

    public boolean isOfTypeJsonArrayNoKeyParsing(String jsonPath) {
        return this.isOfTypeJsonArray(jsonPath, false);
    }

    public boolean isOfTypeJsonArray(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, false, null, parseKey);
        return val == null || val instanceof JsonArray;
    }

    @Override
    public boolean isNull(String jsonPath) {
        return this.validateIsNull(jsonPath, true);
    }

    public boolean isNullNoKeyParsing(String jsonPath) {
        return this.validateIsNull(jsonPath, false);
    }

    public boolean validateIsNull(String jsonPath, boolean parseKey) {
        Object val = this.getElement(jsonPath, true, "", parseKey);
        return val == null;
    }

    @Override
    public boolean isElementExists(String jsonPath) {
        Object object = this.getElement(jsonPath, true, this.getdefaultElementValidator(), true);
        return object != this.getdefaultElementValidator();
    }

    protected Object getElement(String key, boolean hasdefaultElement, Object defaultElement, boolean parseJsonPath) {
        Object element;
        JsonPathCachingItem jsonPathCachingItem;
        if (!parseJsonPath) {
            return this.getElementNoKeyParsing(key, hasdefaultElement, defaultElement);
        }
        if (!this.isMutable() && (jsonPathCachingItem = this.getJsonPathCachingMap().get(key)) != null) {
            if (jsonPathCachingItem.exists) {
                return jsonPathCachingItem.element;
            }
            return defaultElement;
        }
        if (this instanceof JsonObject) {
            element = this.getJsonManager().getElementAtJsonPath((JsonObject)((Object)this), key, this.getdefaultElementValidator());
        } else if (this instanceof JsonArray) {
            element = this.getJsonManager().getElementAtJsonPath((JsonArray)((Object)this), key, this.getdefaultElementValidator());
        } else {
            throw new RuntimeException("Type not managed here : " + this.getClass().getName());
        }
        Object elementToReturn = element;
        boolean jsonPathElementExists = true;
        if (element == this.getdefaultElementValidator()) {
            jsonPathElementExists = false;
            elementToReturn = hasdefaultElement ? defaultElement : null;
        }
        if (!this.isMutable()) {
            JsonPathCachingItem jsonPathCachingItem2 = new JsonPathCachingItem();
            jsonPathCachingItem2.exists = jsonPathElementExists;
            jsonPathCachingItem2.element = element;
            this.getJsonPathCachingMap().put(key, jsonPathCachingItem2);
        }
        return elementToReturn;
    }

    protected Object clone() throws CloneNotSupportedException {
        if (!this.isMutable()) {
            return this.clone(false);
        }
        return this.clone(true);
    }

    protected ElementTransformer getTrimTransformer() {
        if (this.trimTransformer == null) {
            this.trimTransformer = new ElementTransformer(){

                @Override
                public Object transform(Object obj) {
                    if (obj == null) {
                        return null;
                    }
                    if (!(obj instanceof String)) {
                        return obj;
                    }
                    return ((String)obj).trim();
                }
            };
        }
        return this.trimTransformer;
    }

    @Override
    public void trim(String jsonPath) {
        this.transform(jsonPath, this.getTrimTransformer());
    }

    @Override
    public void trimAll() {
        this.trimAll(true);
    }

    @Override
    public void trimAll(boolean recursive) {
        this.transformAll(this.getTrimTransformer(), recursive);
    }

    @Override
    public void transform(String jsonPath, ElementTransformer transformer) {
        Object obj = this.getObject(jsonPath);
        obj = transformer.transform(obj);
        this.put(jsonPath, obj);
    }

    @Override
    public void transformAll(ElementTransformer transformer) {
        this.transformAll(transformer, true);
    }

    @Override
    public JsonObjectOrArray put(String jsonPath, Object element) {
        return this.put(jsonPath, element, false, true);
    }

    @Override
    public JsonObjectOrArray put(String jsonPath, Object element, boolean clone) {
        return this.put(jsonPath, element, clone, true);
    }

    protected JsonObjectOrArray put(String jsonPath, Object element, boolean clone, boolean parseJsonPath) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        Objects.requireNonNull(jsonPath, "jsonPath key can't be NULL");
        if (element != null) {
            boolean newObject = false;
            if (element instanceof ToJsonObjectConvertible) {
                newObject = true;
                element = ((ToJsonObjectConvertible)element).convertToJsonObject();
            } else if (element instanceof ToJsonArrayConvertible) {
                newObject = true;
                element = ((ToJsonArrayConvertible)element).convertToJsonArray();
            }
            if (element instanceof JsonObjectOrArray) {
                if (!newObject && (clone || ((JsonObjectOrArray)element).isMutable() != this.isMutable())) {
                    element = ((JsonObjectOrArray)element).clone(this.isMutable());
                }
            } else {
                element = this.getJsonManager().convertToNativeType(element);
            }
        }
        if (parseJsonPath) {
            this.getJsonManager().putElementAtJsonPath(this, jsonPath, element, false);
        } else {
            this.putAsIs(jsonPath, element);
        }
        return this;
    }

    protected abstract JsonObjectOrArray putAsIs(String var1, Object var2);

    @Override
    public abstract void transformAll(ElementTransformer var1, boolean var2);

    @Override
    public abstract JsonObjectOrArray clone(boolean var1);

    protected abstract Object getElementNoKeyParsing(String var1, boolean var2, Object var3);

    public static class JsonPathCachingItem {
        public boolean exists;
        public Object element;
    }
}

