/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.validation.JsonObjectValidationBuilderKey;
import org.spincast.core.validation.JsonObjectValidationSet;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSetDefault;
import org.spincast.core.xml.XmlManager;

public class JsonObjectValidationSetDefault
extends ValidationSetDefault
implements JsonObjectValidationSet {
    private final JsonObjectOrArray validatedObject;
    private Map<String, SimpleValidator> isOfTypeValidators;
    private Map<String, SimpleValidator> canBeConvertedToValidators;

    @AssistedInject
    public JsonObjectValidationSetDefault(@Assisted JsonObject validatedObject, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this((JsonObjectOrArray)validatedObject, validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    public JsonObjectValidationSetDefault(JsonObjectOrArray validatedObject, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        super(validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
        this.validatedObject = validatedObject;
    }

    protected JsonObjectOrArray getValidatedObject() {
        return this.validatedObject;
    }

    protected Map<String, SimpleValidator> getIsOfTypeValidators() {
        if (this.isOfTypeValidators == null) {
            this.isOfTypeValidators = new HashMap<String, SimpleValidator>();
        }
        return this.isOfTypeValidators;
    }

    protected Map<String, SimpleValidator> getCanBeConvertedToValidators() {
        if (this.canBeConvertedToValidators == null) {
            this.canBeConvertedToValidators = new HashMap<String, SimpleValidator>();
        }
        return this.canBeConvertedToValidators;
    }

    @Override
    public JsonObjectValidationBuilderKey validation(SimpleValidator validator) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), validator);
    }

    @Override
    public JsonObjectValidationBuilderKey validationNotBlank() {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getNotBlankValidatorInfo());
    }

    @Override
    public JsonObjectValidationBuilderKey validationBlank() {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getBlankValidatorInfo());
    }

    @Override
    public JsonObjectValidationBuilderKey validationEmail() {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getEmailValidatorInfo());
    }

    @Override
    public JsonObjectValidationBuilderKey validationNull() {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getNullValidatorInfo());
    }

    @Override
    public JsonObjectValidationBuilderKey validationNotNull() {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getNotNullValidatorInfo());
    }

    @Override
    public JsonObjectValidationBuilderKey validationPattern(String pattern) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getPatternValidator(pattern));
    }

    @Override
    public JsonObjectValidationBuilderKey validationNotPattern(String pattern) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getNotPatternValidator(pattern));
    }

    @Override
    public JsonObjectValidationBuilderKey validationSize(int size, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getSizeValidator(size, ignoreNullValues));
    }

    @Override
    public JsonObjectValidationBuilderKey validationMinSize(int minSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getMinSizeValidator(minSize, ignoreNullValues));
    }

    @Override
    public JsonObjectValidationBuilderKey validationMaxSize(int maxSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getMaxSizeValidator(maxSize, ignoreNullValues));
    }

    @Override
    public JsonObjectValidationBuilderKey validationLength(int length) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getLengthValidator(length));
    }

    @Override
    public JsonObjectValidationBuilderKey validationMinLength(int minLength) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getMinLengthValidator(minLength));
    }

    @Override
    public JsonObjectValidationBuilderKey validationMaxLength(int maxLength) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getMaxLengthValidator(maxLength));
    }

    @Override
    public JsonObjectValidationBuilderKey validationEquivalent(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentValidator(reference));
    }

    @Override
    public JsonObjectValidationBuilderKey validationNotEquivalent(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getNotEquivalentValidator(reference));
    }

    @Override
    public JsonObjectValidationBuilderKey validationLess(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getLessValidator(reference));
    }

    @Override
    public JsonObjectValidationBuilderKey validationGreater(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getGreaterValidator(reference));
    }

    @Override
    public JsonObjectValidationBuilderKey validationEquivalentOrLess(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentOrLessValidator(reference));
    }

    @Override
    public JsonObjectValidationBuilderKey validationEquivalentOrGreater(Object reference) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentOrGreaterValidator(reference));
    }

    protected SimpleValidator getIsOfTypeValidator(final Class<?> referenceType) {
        Objects.requireNonNull(referenceType, "The reference type can't be NULL");
        SimpleValidator validator = this.getIsOfTypeValidators().get(referenceType);
        if (validator == null) {
            validator = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate == null || referenceType.isAssignableFrom(elementToValidate.getClass());
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_IS_OF_TYPE";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_is_of_type_default_text(referenceType.getSimpleName());
                }
            };
            this.getIsOfTypeValidators().put(referenceType.getName(), validator);
        }
        return validator;
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeOrNull(Class<?> referenceType) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getIsOfTypeValidator(referenceType));
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeStringOrNull() {
        return this.validationIsOfTypeOrNull(String.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeIntegerOrNull() {
        return this.validationIsOfTypeOrNull(Integer.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeLongOrNull() {
        return this.validationIsOfTypeOrNull(Long.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeFloatOrNull() {
        return this.validationIsOfTypeOrNull(Float.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeDoubleOrNull() {
        return this.validationIsOfTypeOrNull(Double.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeBooleanOrNull() {
        return this.validationIsOfTypeOrNull(Boolean.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeBigDecimalOrNull() {
        return this.validationIsOfTypeOrNull(BigDecimal.class);
    }

    protected SimpleValidator getIsOfTypeByteArrayValidator(final boolean acceptBase64StringToo) {
        String validatorKey = "ByteArray" + String.valueOf(acceptBase64StringToo);
        SimpleValidator validator = this.getIsOfTypeValidators().get(validatorKey);
        if (validator == null) {
            validator = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate == null || elementToValidate instanceof byte[] || acceptBase64StringToo && JsonObjectValidationSetDefault.this.getObjectConverter().isBase64StringOrNull(elementToValidate);
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_IS_OF_TYPE";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_is_of_type_default_text("byte[]");
                }
            };
            this.getIsOfTypeValidators().put(validatorKey, validator);
        }
        return validator;
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeByteArrayOrNull(boolean acceptBase64StringToo) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getIsOfTypeByteArrayValidator(acceptBase64StringToo));
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeDateOrNull() {
        return this.validationIsOfTypeOrNull(Date.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeJsonObjectOrNull() {
        return this.validationIsOfTypeOrNull(JsonObject.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationIsOfTypeJsonArrayOrNull() {
        return this.validationIsOfTypeOrNull(JsonArray.class);
    }

    protected SimpleValidator getCanBeConvertedToValidator(final Class<?> referenceType) {
        SimpleValidator validator = this.getCanBeConvertedToValidators().get(referenceType);
        if (validator == null) {
            validator = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getObjectConverter().isCanBeConvertedTo(referenceType, elementToValidate);
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_CAN_BE_CONVERTED_TO";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return JsonObjectValidationSetDefault.this.getSpincastDictionary().validation_can_be_converted_to_default_text(referenceType.getSimpleName());
                }
            };
            this.getCanBeConvertedToValidators().put(referenceType != null ? referenceType.getName() : null, validator);
        }
        return validator;
    }

    protected JsonObjectValidationBuilderKey validationCanBeConvertedTo(Class<?> referenceType) {
        return this.getValidationFactory().createJsonObjectValidationBuilderKey(this, this.getValidatedObject(), this.getCanBeConvertedToValidator(referenceType));
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToString() {
        return this.validationCanBeConvertedTo(String.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToInteger() {
        return this.validationCanBeConvertedTo(Integer.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToLong() {
        return this.validationCanBeConvertedTo(Long.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToFloat() {
        return this.validationCanBeConvertedTo(Float.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToBoolean() {
        return this.validationCanBeConvertedTo(Boolean.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToDate() {
        return this.validationCanBeConvertedTo(Date.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToDouble() {
        return this.validationCanBeConvertedTo(Double.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToBigDecimal() {
        return this.validationCanBeConvertedTo(BigDecimal.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToByteArray() {
        return this.validationCanBeConvertedTo(byte[].class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToJsonObject() {
        return this.validationCanBeConvertedTo(JsonObject.class);
    }

    @Override
    public JsonObjectValidationBuilderKey validationCanBeConvertedToJsonArray() {
        return this.validationCanBeConvertedTo(JsonArray.class);
    }
}

