/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.exceptions.CantCompareException;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderKey;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationLevel;
import org.spincast.core.validation.ValidationMessage;
import org.spincast.core.validation.ValidationMessageFormatType;
import org.spincast.core.validation.ValidationSet;
import org.spincast.core.xml.XmlManager;
import org.spincast.shaded.org.apache.commons.collections.MapUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.validator.routines.EmailValidator;

public class ValidationSetDefault
implements ValidationSet {
    protected final Logger logger = LoggerFactory.getLogger(ValidationSetDefault.class);
    private final ValidationFactory validationFactory;
    private final SpincastDictionary spincastDictionary;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final ObjectConverter objectConverter;
    private boolean validationDone = false;
    private final LinkedHashMap<String, List<ValidationMessage>> messages;
    private SimpleValidator notBlankValidatorInfo;
    private SimpleValidator blankValidatorInfo;
    private SimpleValidator emailValidatorInfo;
    private SimpleValidator nullValidatorInfo;
    private SimpleValidator notNullValidatorInfo;

    @AssistedInject
    public ValidationSetDefault(@Assisted @Nullable LinkedHashMap<String, List<ValidationMessage>> messages, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this.validationFactory = validationFactory;
        this.spincastDictionary = spincastDictionary;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.objectConverter = objectConverter;
        if (messages == null) {
            messages = new LinkedHashMap();
        }
        this.messages = messages;
    }

    @AssistedInject
    public ValidationSetDefault(ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this((LinkedHashMap<String, List<ValidationMessage>>)null, validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    @AssistedInject
    public ValidationSetDefault(@Assisted String key, @Assisted List<ValidationMessage> messages, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this(ValidationSetDefault.toLinkedHashMap(key, messages), validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    @AssistedInject
    public ValidationSetDefault(@Assisted String key, @Assisted ValidationMessage message, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this(ValidationSetDefault.toLinkedHashMap(key, Lists.newArrayList((Object[])new ValidationMessage[]{message})), validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    @AssistedInject
    public ValidationSetDefault(@Assisted List<ValidationSet> existingResults, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        this(ValidationSetDefault.toMessages(existingResults), validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    protected static LinkedHashMap<String, List<ValidationMessage>> toLinkedHashMap(String key, List<ValidationMessage> messages) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new RuntimeException("The key can't be empty.");
        }
        LinkedHashMap<String, List<ValidationMessage>> map = new LinkedHashMap<String, List<ValidationMessage>>();
        map.put(key, messages);
        return map;
    }

    protected static LinkedHashMap<String, List<ValidationMessage>> toMessages(List<ValidationSet> existingResults) {
        if (existingResults == null) {
            return null;
        }
        LinkedHashMap<String, List<ValidationMessage>> map = new LinkedHashMap<String, List<ValidationMessage>>();
        if (existingResults != null) {
            for (ValidationSet validationResult : existingResults) {
                Map<String, List<ValidationMessage>> messagesMap = validationResult.getMessages();
                if (messagesMap == null) continue;
                for (Map.Entry<String, List<ValidationMessage>> entry : messagesMap.entrySet()) {
                    String key = entry.getKey();
                    List<ValidationMessage> messages = entry.getValue();
                    if (messages == null) continue;
                    List<ValidationMessage> messagesList = map.get(key);
                    if (messagesList == null) {
                        messagesList = new ArrayList<ValidationMessage>();
                        map.put(key, messagesList);
                    }
                    messagesList.addAll(messages);
                }
            }
        }
        return map;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    protected SpincastDictionary getSpincastDictionary() {
        return this.spincastDictionary;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    protected boolean isValidationDone() {
        return this.validationDone;
    }

    @Override
    public ValidationSet createValidationSet() {
        return this.getValidationFactory().createValidationSet();
    }

    protected String getDefaultErrorMessageText(String key) {
        return this.getSpincastDictionary().validation_generic_error_default_text();
    }

    @Override
    public ValidationSet addMessage(String validationKey, ValidationMessage message) {
        Objects.requireNonNull(message, "The message can't be NULL");
        List<ValidationMessage> fieldMessages = this.getMessages().get(validationKey);
        if (fieldMessages == null) {
            fieldMessages = new ArrayList<ValidationMessage>();
            this.getMessages().put(validationKey, fieldMessages);
        }
        fieldMessages.add(message);
        return this.getValidationFactory().createValidationSet(validationKey, message);
    }

    @Override
    public ValidationSet addMessage(String validationKey, ValidationLevel level, String code, String text) {
        Objects.requireNonNull(level, "The level can't be NULL");
        Objects.requireNonNull(validationKey, "The validation key can't be NULL");
        if (code == null) {
            code = "";
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            text = this.getDefaultErrorMessageText(validationKey);
        }
        ValidationMessage message = this.getValidationFactory().createMessage(level, code, text);
        return this.addMessage(validationKey, message);
    }

    @Override
    public ValidationSet addError(String validationKey, String code, String text) {
        return this.addMessage(validationKey, ValidationLevel.ERROR, code, text);
    }

    @Override
    public ValidationSet addWarning(String validationKey, String code, String text) {
        return this.addMessage(validationKey, ValidationLevel.WARNING, code, text);
    }

    @Override
    public ValidationSet addSuccess(String validationKey, String code, String text) {
        return this.addMessage(validationKey, ValidationLevel.SUCCESS, code, text);
    }

    @Override
    public ValidationSet mergeValidationSet(ValidationSet set) {
        return this.mergeValidationSet(null, set);
    }

    @Override
    public ValidationSet mergeValidationSet(String validationKeyPrefix, ValidationSet set) {
        Objects.requireNonNull(set, "The validation set can't be NULL");
        Map<String, List<ValidationMessage>> messagesByKey = set.getMessages();
        if (messagesByKey != null) {
            for (Map.Entry<String, List<ValidationMessage>> entry : messagesByKey.entrySet()) {
                List<ValidationMessage> messages = entry.getValue();
                if (messages == null) continue;
                for (ValidationMessage message : messages) {
                    String validationKey = (validationKeyPrefix != null ? validationKeyPrefix : "") + entry.getKey();
                    this.addMessage(validationKey, message);
                }
            }
        }
        return this;
    }

    @Override
    public boolean hasMessages() {
        return this.getMessages().size() > 0;
    }

    @Override
    public boolean hasMessages(String key) {
        return this.getMessages(key).size() > 0;
    }

    @Override
    public boolean isWarning() {
        boolean hasWarnings = false;
        boolean hasErrors = false;
        for (List<ValidationMessage> messagesList : this.getMessages().values()) {
            if (messagesList == null) continue;
            for (ValidationMessage message : messagesList) {
                if (message.getValidationLevel() == ValidationLevel.WARNING) {
                    hasWarnings = true;
                    continue;
                }
                if (message.getValidationLevel() != ValidationLevel.ERROR) continue;
                hasErrors = true;
            }
        }
        return hasWarnings && !hasErrors;
    }

    @Override
    public boolean isWarning(String key) {
        boolean hasWarnings = false;
        boolean hasErrors = false;
        for (ValidationMessage message : this.getMessages(key)) {
            if (message.getValidationLevel() == ValidationLevel.WARNING) {
                hasWarnings = true;
                continue;
            }
            if (message.getValidationLevel() != ValidationLevel.ERROR) continue;
            hasErrors = true;
        }
        return hasWarnings && !hasErrors;
    }

    @Override
    public boolean isSuccess() {
        for (List<ValidationMessage> messagesList : this.getMessages().values()) {
            if (messagesList == null) continue;
            for (ValidationMessage message : messagesList) {
                if (message.getValidationLevel() == ValidationLevel.SUCCESS) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSuccess(String key) {
        for (ValidationMessage message : this.getMessages(key)) {
            if (message.getValidationLevel() == ValidationLevel.SUCCESS) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isError() {
        for (List<ValidationMessage> messagesList : this.getMessages().values()) {
            if (messagesList == null) continue;
            for (ValidationMessage message : messagesList) {
                if (message.getValidationLevel() != ValidationLevel.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isError(String key) {
        for (ValidationMessage message : this.getMessages(key)) {
            if (message.getValidationLevel() != ValidationLevel.ERROR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return !this.isError();
    }

    @Override
    public boolean isValid(String key) {
        return !this.isError(key);
    }

    @Override
    public Map<String, List<ValidationMessage>> getMessages() {
        return this.messages;
    }

    @Override
    public List<ValidationMessage> getMessages(String key) {
        List<ValidationMessage> messages = this.getMessages().get(key);
        if (messages == null) {
            messages = new ArrayList<ValidationMessage>();
        }
        return messages;
    }

    @Override
    public String getMessagesFormatted(ValidationMessageFormatType formatType) {
        return this.getMessagesFormatted(null, formatType);
    }

    @Override
    public String getMessagesFormatted(String jsonPath, ValidationMessageFormatType formatType) {
        if (this.getMessages().size() == 0) {
            return null;
        }
        if (formatType == null) {
            formatType = ValidationMessageFormatType.PLAIN_TEXT;
        }
        StringBuilder textBuilder = null;
        if (formatType == ValidationMessageFormatType.PLAIN_TEXT || formatType == ValidationMessageFormatType.HTML) {
            textBuilder = new StringBuilder();
        }
        JsonObject jsonObject = null;
        if (formatType == ValidationMessageFormatType.JSON || formatType == ValidationMessageFormatType.XML) {
            jsonObject = this.getJsonManager().create();
        }
        if (jsonPath == null) {
            Map<String, List<ValidationMessage>> messagesMap = this.getMessages();
            for (Map.Entry<String, List<ValidationMessage>> entry : messagesMap.entrySet()) {
                this.addMessageFormattedSpecifickey(entry.getKey(), entry.getValue(), formatType, textBuilder, jsonObject);
            }
        } else {
            List<ValidationMessage> messages = this.getMessages().get(jsonPath);
            this.addMessageFormattedSpecifickey(jsonPath, messages, formatType, textBuilder, jsonObject);
        }
        if (formatType == ValidationMessageFormatType.PLAIN_TEXT || formatType == ValidationMessageFormatType.HTML) {
            return textBuilder.toString();
        }
        if (formatType == ValidationMessageFormatType.JSON) {
            return jsonObject.toJsonString(this.usePrettyJson());
        }
        if (formatType == ValidationMessageFormatType.XML) {
            return this.getXmlManager().toXml(jsonObject, this.usePrettyXml());
        }
        throw new RuntimeException("Unamanaged type: " + (Object)((Object)formatType));
    }

    protected boolean usePrettyJson() {
        return true;
    }

    protected boolean usePrettyXml() {
        return true;
    }

    protected void addMessageFormattedSpecifickey(String key, List<ValidationMessage> messages, ValidationMessageFormatType formatType, StringBuilder textBuilder, JsonObject jsonObject) {
        if (StringUtils.isBlank((CharSequence)key) || messages == null || messages.size() == 0) {
            return;
        }
        if (formatType == ValidationMessageFormatType.JSON || formatType == ValidationMessageFormatType.XML) {
            jsonObject.put(key, messages);
            return;
        }
        if (formatType == ValidationMessageFormatType.PLAIN_TEXT) {
            this.addMessagesFormattedSpecifickeyTextPlain(key, textBuilder, messages);
        } else if (formatType == ValidationMessageFormatType.HTML) {
            this.addMessagesFormattedSpecifickeyHtml(key, textBuilder, messages);
        } else {
            throw new RuntimeException("Type not managed here: " + (Object)((Object)formatType));
        }
    }

    protected void addMessagesFormattedSpecifickeyTextPlain(String key, StringBuilder textBuilder, List<ValidationMessage> messages) {
        textBuilder.append("key \"").append(key).append("\"").append("\n");
        for (ValidationMessage message : messages) {
            textBuilder.append("    - ").append(message.getText()).append("\n");
        }
        textBuilder.append("\n");
    }

    protected void addMessagesFormattedSpecifickeyHtml(String key, StringBuilder textBuilder, List<ValidationMessage> messages) {
        textBuilder.append("<li class=\"" + this.getCssClassForErrorkey() + "\">").append(key).append("\n");
        textBuilder.append("    <ul>\n");
        for (ValidationMessage message : messages) {
            String cssClass = message.getValidationLevel() == ValidationLevel.SUCCESS ? this.getCssClassForSuccessMessage() : (message.getValidationLevel() == ValidationLevel.WARNING ? this.getCssClassForWarningMessage() : this.getCssClassForErrorMessage());
            textBuilder.append("        <li class=\"" + cssClass + "\">").append(message.getText()).append("</li>\n");
        }
        textBuilder.append("    </ul>\n");
        textBuilder.append("</li>\n");
    }

    protected String getCssClassForErrorkey() {
        return "validationKey";
    }

    protected String getCssClassForErrorMessage() {
        return "validationError";
    }

    protected String getCssClassForSuccessMessage() {
        return "validationSuccess";
    }

    protected String getCssClassForWarningMessage() {
        return "validationWarning";
    }

    @Override
    public ValidationBuilderKey validation(SimpleValidator validator) {
        return this.getValidationFactory().createValidationBuilderKey(this, validator);
    }

    protected String getArrayItselfDefaultValidationKey(String baseKey) {
        if (baseKey == null) {
            baseKey = "";
        }
        return "_" + baseKey;
    }

    protected String getArrayItselfDefaultSuccessMessageText() {
        return this.getSpincastDictionary().validation_array_itself_success_message_default_text();
    }

    protected String getArrayItselfDefaultValidationCode() {
        return "VALIDATION_TYPE_WHOLE_ARRAY_VALIDATION_RESULT_TYPE";
    }

    protected SimpleValidator getNotBlankValidatorInfo() {
        if (this.notBlankValidatorInfo == null) {
            this.notBlankValidatorInfo = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate != null && (!(elementToValidate instanceof String) || !StringUtils.isBlank((CharSequence)((String)elementToValidate)));
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_NOT_BLANK";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_not_blank_default_text();
                }
            };
        }
        return this.notBlankValidatorInfo;
    }

    @Override
    public ValidationBuilderKey validationNotBlank() {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getNotBlankValidatorInfo());
    }

    protected SimpleValidator getBlankValidatorInfo() {
        if (this.blankValidatorInfo == null) {
            this.blankValidatorInfo = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate == null || elementToValidate instanceof String && StringUtils.isBlank((CharSequence)((String)elementToValidate));
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_BLANK";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_blank_default_text();
                }
            };
        }
        return this.blankValidatorInfo;
    }

    @Override
    public ValidationBuilderKey validationBlank() {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getBlankValidatorInfo());
    }

    protected SimpleValidator getEmailValidatorInfo() {
        if (this.emailValidatorInfo == null) {
            this.emailValidatorInfo = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate != null && elementToValidate instanceof String && EmailValidator.getInstance().isValid((String)elementToValidate);
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_EMAIL";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_email_default_text();
                }
            };
        }
        return this.emailValidatorInfo;
    }

    @Override
    public ValidationBuilderKey validationEmail() {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getEmailValidatorInfo());
    }

    protected SimpleValidator getNullValidatorInfo() {
        if (this.nullValidatorInfo == null) {
            this.nullValidatorInfo = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate == null;
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_NULL";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_null_default_text();
                }
            };
        }
        return this.nullValidatorInfo;
    }

    @Override
    public ValidationBuilderKey validationNull() {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getNullValidatorInfo());
    }

    protected SimpleValidator getNotNullValidatorInfo() {
        if (this.notNullValidatorInfo == null) {
            this.notNullValidatorInfo = new SimpleValidator(){

                @Override
                public boolean validate(Object elementToValidate) {
                    boolean valid = elementToValidate != null;
                    return valid;
                }

                @Override
                public String getCode() {
                    return "VALIDATION_TYPE_NOT_NULL";
                }

                @Override
                public String getSuccessMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
                }

                @Override
                public String getFailMessage(Object elementToValidate) {
                    return ValidationSetDefault.this.getSpincastDictionary().validation_not_null_default_text();
                }
            };
        }
        return this.notNullValidatorInfo;
    }

    @Override
    public ValidationBuilderKey validationNotNull() {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getNotNullValidatorInfo());
    }

    protected SimpleValidator getPatternValidator(final String pattern) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                boolean valid = elementToValidate != null && Pattern.matches(pattern, elementToValidate.toString());
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_PATTERN";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_pattern_default_text(pattern);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationPattern(String pattern) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getPatternValidator(pattern));
    }

    protected SimpleValidator getNotPatternValidator(final String pattern) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                boolean valid = elementToValidate == null || !Pattern.matches(pattern, elementToValidate.toString());
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_NOT_PATTERN";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_not_pattern_default_text(pattern);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationNotPattern(String pattern) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getNotPatternValidator(pattern));
    }

    protected Integer getSize(Object element, boolean ignoreNullValues) {
        if (element == null) {
            return null;
        }
        if (element instanceof JsonObject) {
            if (!ignoreNullValues) {
                return ((JsonObject)element).size();
            }
            int size = 0;
            for (Map.Entry entry : (JsonObject)element) {
                if (entry == null || entry.getValue() == null) continue;
                ++size;
            }
            return size;
        }
        if (element instanceof JsonArray) {
            if (!ignoreNullValues) {
                return ((JsonArray)element).size();
            }
            int size = 0;
            for (Object oneElement : (JsonArray)element) {
                if (oneElement == null) continue;
                ++size;
            }
            return size;
        }
        if (element instanceof byte[]) {
            if (!ignoreNullValues) {
                return ((byte[])element).length;
            }
            int size = 0;
            byte[] byArray = (byte[])element;
            int oneElement = byArray.length;
            for (int i = 0; i < oneElement; ++i) {
                Byte oneElement2 = byArray[i];
                if (oneElement2 == null) continue;
                ++size;
            }
            return size;
        }
        if (element instanceof Object[]) {
            if (!ignoreNullValues) {
                return ((Object[])element).length;
            }
            int size = 0;
            for (Object oneElement : (Object[])element) {
                if (oneElement == null) continue;
                ++size;
            }
            return size;
        }
        if (element instanceof Collection) {
            if (!ignoreNullValues) {
                return ((Collection)element).size();
            }
            int size = 0;
            for (Object oneElement : (Collection)element) {
                if (oneElement == null) continue;
                ++size;
            }
            return size;
        }
        return null;
    }

    protected SimpleValidator getSizeValidator(final int size, final boolean ignoreNullValues) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                if (elementToValidate == null) {
                    return false;
                }
                Integer actualSize = ValidationSetDefault.this.getSize(elementToValidate, ignoreNullValues);
                boolean valid = actualSize != null && actualSize.equals(size);
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_SIZE";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                Integer actualSize = ValidationSetDefault.this.getSize(elementToValidate, ignoreNullValues);
                return ValidationSetDefault.this.getSpincastDictionary().validation_size_default_text(size, actualSize != null ? (long)actualSize.intValue() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationSize(int size, boolean ignoreNullValues) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getSizeValidator(size, ignoreNullValues));
    }

    protected SimpleValidator getMinSizeValidator(final int minSize, final boolean ignoreNullValues) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object element) {
                if (element == null) {
                    return false;
                }
                Integer size = ValidationSetDefault.this.getSize(element, ignoreNullValues);
                boolean valid = size != null && size >= minSize;
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_MIN_SIZE";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                Integer size = ValidationSetDefault.this.getSize(elementToValidate, ignoreNullValues);
                return ValidationSetDefault.this.getSpincastDictionary().validation_min_size_default_text(minSize, size != null ? (long)size.intValue() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationMinSize(int minSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getMinSizeValidator(minSize, ignoreNullValues));
    }

    protected SimpleValidator getMaxSizeValidator(final int maxSize, final boolean ignoreNullValues) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object element) {
                if (element == null) {
                    return true;
                }
                Integer size = ValidationSetDefault.this.getSize(element, ignoreNullValues);
                boolean valid = size != null && size <= maxSize;
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_MAX_SIZE";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                Integer size = ValidationSetDefault.this.getSize(elementToValidate, ignoreNullValues);
                return ValidationSetDefault.this.getSpincastDictionary().validation_max_size_default_text(maxSize, size != null ? (long)size.intValue() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationMaxSize(int maxSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getMaxSizeValidator(maxSize, ignoreNullValues));
    }

    protected SimpleValidator getLengthValidator(final int length) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object element) {
                boolean valid = element != null && element.toString().length() == length;
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_LENGTH";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_length_default_text(length, elementToValidate != null ? (long)elementToValidate.toString().length() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationLength(int length) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getLengthValidator(length));
    }

    protected SimpleValidator getMinLengthValidator(final int minLength) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object element) {
                boolean valid = element != null && element.toString().length() >= minLength;
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_MIN_LENGTH";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_min_length_default_text(minLength, elementToValidate != null ? (long)elementToValidate.toString().length() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationMinLength(int minLength) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getMinLengthValidator(minLength));
    }

    protected SimpleValidator getMaxLengthValidator(final int maxLength) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object element) {
                boolean valid = element == null || element.toString().length() <= maxLength;
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_MAX_LENGTH";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_max_length_default_text(maxLength, elementToValidate != null ? (long)elementToValidate.toString().length() : 0L);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationMaxLength(int maxLength) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getMaxLengthValidator(maxLength));
    }

    protected SimpleValidator getEquivalentValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                boolean valid = ValidationSetDefault.this.getObjectConverter().isEquivalent(elementToValidate, reference);
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_EQUALS";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_equivalent_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationEquivalent(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getEquivalentValidator(reference));
    }

    protected SimpleValidator getNotEquivalentValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                boolean valid = !ValidationSetDefault.this.getObjectConverter().isEquivalent(elementToValidate, reference);
                return valid;
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_NOT_EQUALS";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_not_equivalent_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationNotEquivalent(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getNotEquivalentValidator(reference));
    }

    protected SimpleValidator getLessValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                try {
                    int result = ValidationSetDefault.this.getObjectConverter().compareTo(elementToValidate, reference);
                    return result < 0;
                }
                catch (CantCompareException ex) {
                    return false;
                }
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_LESS";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_less_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationLess(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getLessValidator(reference));
    }

    protected SimpleValidator getGreaterValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                try {
                    int result = ValidationSetDefault.this.getObjectConverter().compareTo(elementToValidate, reference);
                    return result > 0;
                }
                catch (CantCompareException ex) {
                    return false;
                }
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_GREATER";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_greater_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationGreater(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getGreaterValidator(reference));
    }

    protected SimpleValidator getEquivalentOrLessValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                try {
                    int result = ValidationSetDefault.this.getObjectConverter().compareTo(elementToValidate, reference);
                    return result <= 0;
                }
                catch (CantCompareException ex) {
                    return false;
                }
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_EQUALS_OR_LESS";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_equivalent_or_less_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationEquivalentOrLess(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getEquivalentOrLessValidator(reference));
    }

    protected SimpleValidator getEquivalentOrGreaterValidator(final Object reference) {
        return new SimpleValidator(){

            @Override
            public boolean validate(Object elementToValidate) {
                try {
                    int result = ValidationSetDefault.this.getObjectConverter().compareTo(elementToValidate, reference);
                    return result >= 0;
                }
                catch (CantCompareException ex) {
                    return false;
                }
            }

            @Override
            public String getCode() {
                return "VALIDATION_TYPE_EQUALS_OR_GREATER";
            }

            @Override
            public String getSuccessMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_success_message_default_text();
            }

            @Override
            public String getFailMessage(Object elementToValidate) {
                return ValidationSetDefault.this.getSpincastDictionary().validation_equivalent_or_greater_default_text(elementToValidate, reference);
            }
        };
    }

    @Override
    public ValidationBuilderKey validationEquivalentOrGreater(Object reference) {
        return this.getValidationFactory().createValidationBuilderKey(this, this.getEquivalentOrGreaterValidator(reference));
    }

    @Override
    public JsonObject convertToJsonObject() {
        JsonObject obj = this.getJsonManager().create();
        boolean formIsValid = true;
        boolean formHasSuccesses = false;
        boolean formHasWarnings = false;
        boolean formHasErrors = false;
        for (Map.Entry<String, List<ValidationMessage>> entry : this.getMessages().entrySet()) {
            JsonObject field = this.getJsonManager().create();
            boolean keyIsValid = true;
            boolean keyHasSuccessMessages = false;
            boolean keyHasWarningMessages = false;
            boolean keyHasErrorMessages = false;
            JsonArray messages = this.getJsonManager().createArray();
            for (ValidationMessage validationMessage : entry.getValue()) {
                JsonObject message = validationMessage.convertToJsonObject();
                if (validationMessage.getValidationLevel() == ValidationLevel.ERROR) {
                    keyIsValid = false;
                    keyHasErrorMessages = true;
                    formIsValid = false;
                    formHasErrors = true;
                } else if (validationMessage.getValidationLevel() == ValidationLevel.WARNING) {
                    keyHasWarningMessages = true;
                    formHasWarnings = true;
                } else if (validationMessage.getValidationLevel() == ValidationLevel.SUCCESS) {
                    keyHasSuccessMessages = true;
                    formHasSuccesses = true;
                } else {
                    throw new RuntimeException("Level not managed : " + (Object)((Object)validationMessage.getValidationLevel()));
                }
                messages.add(message);
            }
            field.put("messages", messages);
            field.put("isValid", keyIsValid);
            field.put("hasErrors", keyHasErrorMessages);
            field.put("hasWarnings", keyHasWarningMessages);
            field.put("hasSuccesses", keyHasSuccessMessages);
            obj.putNoKeyParsing(entry.getKey(), field);
        }
        JsonObject setItself = this.getJsonManager().create();
        setItself.put("isValid", formIsValid);
        setItself.put("hasSuccesses", formHasSuccesses);
        setItself.put("hasWarnings", formHasWarnings);
        setItself.put("hasErrors", formHasErrors);
        obj.putNoKeyParsing(this.getSetItselfValidationKey(), setItself);
        return obj.clone(false);
    }

    protected String getSetItselfValidationKey() {
        return "_";
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        MapUtils.debugPrint((PrintStream)ps, (Object)"messages", this.getMessages());
        String content = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        return content;
    }

    @Override
    public ValidationSet prefixValidationKeys(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return this;
        }
        HashMap<String, List<ValidationMessage>> messagesPrefixed = new HashMap<String, List<ValidationMessage>>(this.getMessages());
        this.messages.clear();
        for (Map.Entry entry : messagesPrefixed.entrySet()) {
            this.messages.put(prefix + (String)entry.getKey(), (List<ValidationMessage>)entry.getValue());
        }
        return this;
    }
}

