/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPlugin;
import org.spincast.core.websocket.WebsocketContext;

public class GuiceTweaker
implements SpincastPlugin {
    public static final ThreadLocal<GuiceTweaker> threadLocal = new ThreadLocal();
    public static final String PLUGIN_ID = GuiceTweaker.class.getName();
    private List<SpincastPlugin> extraPlugins;
    private Set<Module> overridingModules;
    private Set<Key<?>> exactBindingsToRemove;
    private Set<Class<?>> bindingsHierarchiesToRemove;
    private Set<String> pluginsToDisable;
    private boolean bindCurrentClassByDefault = true;
    private Injector injector;

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    protected List<SpincastPlugin> getExtraPlugins() {
        if (this.extraPlugins == null) {
            this.extraPlugins = new ArrayList<SpincastPlugin>();
        }
        return this.extraPlugins;
    }

    protected Set<Module> getOverridingModules() {
        if (this.overridingModules == null) {
            this.overridingModules = new HashSet<Module>();
        }
        return this.overridingModules;
    }

    protected Set<Key<?>> getExactBindingsToRemove() {
        if (this.exactBindingsToRemove == null) {
            this.exactBindingsToRemove = new HashSet();
        }
        return this.exactBindingsToRemove;
    }

    public Set<Class<?>> getBindingsHierarchiesToRemove() {
        if (this.bindingsHierarchiesToRemove == null) {
            this.bindingsHierarchiesToRemove = new HashSet();
        }
        return this.bindingsHierarchiesToRemove;
    }

    public boolean isBindCurrentClassByDefault() {
        return this.bindCurrentClassByDefault;
    }

    @Override
    public void createdGuiceInjector(Injector injector) {
        this.injector = injector;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public Module beforePlugins(Module combinedModule) {
        Module newModule = combinedModule;
        GuiceModuleUtils guiceModuleUtils = new GuiceModuleUtils(newModule);
        if (this.getBindingsHierarchiesToRemove().size() > 0) {
            for (Class<?> parentClass : this.bindingsHierarchiesToRemove) {
                Set<Class<?>> classes = guiceModuleUtils.getBoundClassesExtending(parentClass);
                if (classes.size() <= 0) continue;
                for (Class<?> clazz : classes) {
                    this.getExactBindingsToRemove().add(Key.get(clazz));
                }
            }
        }
        if (this.getExactBindingsToRemove().size() > 0) {
            newModule = GuiceModuleUtils.removeBindings(newModule, this.getExactBindingsToRemove());
        }
        if (this.getOverridingModules() != null && this.getOverridingModules().size() > 0) {
            newModule = Modules.override((Module[])new Module[]{newModule}).with(this.getOverridingModules());
        }
        return newModule;
    }

    @Override
    public Module apply(Module currentModule) {
        for (SpincastPlugin plugin : this.getExtraPlugins()) {
            currentModule = plugin.apply(currentModule);
        }
        return currentModule;
    }

    public Module afterPlugins(Module combinedModule) {
        return combinedModule;
    }

    @Override
    public Set<String> getPluginsToDisable() {
        if (this.pluginsToDisable == null) {
            this.pluginsToDisable = new HashSet<String>();
        }
        return this.pluginsToDisable;
    }

    @Override
    public void setRequestContextImplementationClass(Class<? extends RequestContext<?>> requestContextImplementationClass) {
    }

    @Override
    public void setWebsocketContextImplementationClass(Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
    }

    public void overridingModule(Module overridingModule) {
        Objects.requireNonNull(overridingModule, "The module can't be NULL");
        this.getOverridingModules().add(overridingModule);
    }

    public void exactBindingToRemove(Key<?> key) {
        Objects.requireNonNull(key, "The key can't be NULL");
        this.getExactBindingsToRemove().add(key);
    }

    public void bindingHierarchyToRemove(Class<?> parentClass) {
        Objects.requireNonNull(parentClass, "The class can't be NULL");
        this.getBindingsHierarchiesToRemove().add(parentClass);
    }

    public void plugin(SpincastPlugin plugin) {
        Objects.requireNonNull(plugin, "The plugin can't be NULL");
        this.getExtraPlugins().add(plugin);
    }

    public void bindCurrentClassByDefault(boolean bindCurrentClassByDefault) {
        this.bindCurrentClassByDefault = bindCurrentClassByDefault;
    }

    public void pluginToDisable(String pluginId) {
        this.getPluginsToDisable().add(pluginId);
    }
}

