/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.config.SpincastInit;
import org.spincast.core.config.SpincastInitValidator;
import org.spincast.core.controllers.FrontController;
import org.spincast.core.controllers.SpincastFrontController;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieDefault;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.exchange.CacheHeadersRequestContextAddon;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.RequestContextBaseDeps;
import org.spincast.core.exchange.RequestContextFactory;
import org.spincast.core.exchange.RequestContextType;
import org.spincast.core.exchange.RequestRequestContextAddon;
import org.spincast.core.exchange.ResponseRequestContextAddon;
import org.spincast.core.exchange.VariablesRequestContextAddon;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.CorsFilterDefault;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.filters.SpincastFiltersDefault;
import org.spincast.core.guice.GuiceTweaker;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastRequestScope;
import org.spincast.core.guice.SpincastRequestScoped;
import org.spincast.core.guice.TestingMode;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonArrayDefault;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectDefault;
import org.spincast.core.json.JsonObjectFactory;
import org.spincast.core.json.JsonPathUtils;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.core.request.Form;
import org.spincast.core.request.FormDefault;
import org.spincast.core.request.FormFactory;
import org.spincast.core.routing.DefaultRouteParamAliasesBinder;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.routing.RedirectRuleBuilderFactory;
import org.spincast.core.routing.RouteBuilderFactory;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingRequestContextAddon;
import org.spincast.core.routing.StaticResourceFactory;
import org.spincast.core.server.Server;
import org.spincast.core.session.FlashMessage;
import org.spincast.core.session.FlashMessageDefault;
import org.spincast.core.session.FlashMessageFactory;
import org.spincast.core.session.FlashMessagesHolder;
import org.spincast.core.session.FlashMessagesHolderDefault;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.templating.TemplatingRequestContextAddon;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.ObjectConverterDefault;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.utils.SpincastUtilsDefault;
import org.spincast.core.utils.ssl.SSLContextFactory;
import org.spincast.core.utils.ssl.SSLContextFactoryDefault;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationMessage;
import org.spincast.core.validation.ValidationMessageDefault;
import org.spincast.core.validation.ValidationSet;
import org.spincast.core.validation.ValidationSetSimple;
import org.spincast.core.validation.Validators;
import org.spincast.core.validation.ValidatorsDefault;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketContextFactory;
import org.spincast.core.websocket.WebsocketContextType;
import org.spincast.core.websocket.WebsocketEndpointHandler;
import org.spincast.core.websocket.WebsocketEndpointHandlerDefault;
import org.spincast.core.websocket.WebsocketEndpointHandlerFactory;
import org.spincast.core.websocket.WebsocketEndpointToControllerManager;
import org.spincast.core.websocket.WebsocketEndpointToControllerManagerDefault;
import org.spincast.core.websocket.WebsocketRouteBuilderFactory;
import org.spincast.core.xml.XmlManager;

public class SpincastCorePluginModule
extends SpincastGuiceModuleBase {
    public SpincastCorePluginModule() {
    }

    public SpincastCorePluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
    }

    protected void configure() {
        this.validateRequirements();
        this.bindRequestContextType();
        this.bindWebsocketContextType();
        this.bindSpincastRequestScope();
        this.bindRequestContextInRequestScope();
        this.bindRequestContextBaseDeps();
        this.bindDefaultPredefinedRouteParamPatternsBinder();
        this.bindRequestContextFactory();
        this.bindFrontController();
        this.bindSpincastUtilsClass();
        this.bindSpincastFilters();
        this.bindJsonObjectFactory();
        this.bindWebsocketEndpointHandlerFactory();
        this.bindWebsocketContextFactory();
        this.bindWebsocketEndpointToControllerManager();
        this.bindSSLContextFactory();
        this.bindFormFactory();
        this.bindValidationFactory();
        this.bindValidators();
        this.bindFlashMessageFactory();
        this.bindFlashMessagesHolder();
        this.bindSpincastInitValidator();
        this.bindObjectConverter();
        this.bindCookieFactory();
        this.bindTestingModeFlag();
        this.spincastInit();
    }

    protected void validateRequirements() {
        this.requireBinding(Server.class);
        this.requireBinding(this.parameterizeWithContextInterfaces(Router.class));
        this.requireBinding(Key.get((TypeLiteral)new TypeLiteral<Router<?, ?>>(){}));
        this.requireBinding(this.parameterizeWithContextInterfaces(RouteBuilderFactory.class));
        this.requireBinding(this.parameterizeWithRequestContext(StaticResourceFactory.class));
        this.requireBinding(this.parameterizeWithContextInterfaces(RedirectRuleBuilderFactory.class));
        this.requireBinding(this.parameterizeWithContextInterfaces(WebsocketRouteBuilderFactory.class));
        this.requireBinding(ETagFactory.class);
        this.requireBinding(TemplatingEngine.class);
        this.requireBinding(JsonManager.class);
        this.requireBinding(JsonPathUtils.class);
        this.requireBinding(XmlManager.class);
        this.requireBinding(SpincastConfig.class);
        this.requireBinding(SpincastDictionary.class);
        this.requireBinding(LocaleResolver.class);
        this.requireBinding(this.parameterizeWithRequestContext(RequestRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(ResponseRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(RoutingRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(TemplatingRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(VariablesRequestContextAddon.class));
        this.requireBinding(this.parameterizeWithRequestContext(CacheHeadersRequestContextAddon.class));
    }

    protected void bindSpincastInitValidator() {
        this.bind(SpincastInitValidator.class).asEagerSingleton();
    }

    protected void bindRequestContextType() {
        Class<? extends RequestContext<?>> type = this.getRequestContextInterface();
        this.bind(Type.class).annotatedWith(RequestContextType.class).toInstance(type);
    }

    protected void bindWebsocketContextType() {
        Type type = this.getWebsocketContextInterface();
        this.bind(Type.class).annotatedWith(WebsocketContextType.class).toInstance((Object)type);
    }

    protected void bindSpincastRequestScope() {
        this.bindScope(SpincastRequestScoped.class, SpincastGuiceScopes.REQUEST);
        this.bind(SpincastRequestScope.class).toInstance((Object)SpincastGuiceScopes.REQUEST);
    }

    protected void bindRequestContextInRequestScope() {
        Key key = Key.get(this.getRequestContextInterface());
        this.bind(key).toProvider(SpincastRequestScope.getSeedErrorProvider(key)).in((Scope)SpincastGuiceScopes.REQUEST);
        TypeLiteral typeLiteral = new TypeLiteral<RequestContext<?>>(){};
        this.bind(Key.get((TypeLiteral)typeLiteral)).toProvider(SpincastRequestScope.getSeedErrorProvider(Key.get((TypeLiteral)typeLiteral))).in((Scope)SpincastGuiceScopes.REQUEST);
    }

    protected void bindRequestContextBaseDeps() {
        this.bind(this.parameterizeWithRequestContext(RequestContextBaseDeps.class)).in(Scopes.SINGLETON);
    }

    protected void bindSpincastFilters() {
        Key<SpincastFiltersDefault> key = this.getSpincastFiltersKey();
        try {
            key.getTypeLiteral().getSupertype(SpincastFilters.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Filters Key must implement " + SpincastFilters.class.getName() + " : " + key);
        }
        this.bind(this.parameterizeWithRequestContext(SpincastFilters.class)).to(key).in(Scopes.SINGLETON);
        this.bind(CorsFilter.class).to(this.getCorsFilterClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends CorsFilter> getCorsFilterClass() {
        return CorsFilterDefault.class;
    }

    protected Key<SpincastFiltersDefault> getSpincastFiltersKey() {
        return this.parameterizeWithContextInterfaces(SpincastFiltersDefault.class);
    }

    protected void bindDefaultPredefinedRouteParamPatternsBinder() {
        this.bind(this.parameterizeWithContextInterfaces(DefaultRouteParamAliasesBinder.class)).asEagerSingleton();
    }

    protected void bindRequestContextFactory() {
        Key key = Key.get(this.getRequestContextImplementationClass());
        Key<RequestContextFactory> requestContextFactoryKey = this.parameterizeWithRequestContext(RequestContextFactory.class);
        Annotation annotation = key.getAnnotation();
        if (annotation != null) {
            this.install(new FactoryModuleBuilder().implement(this.getRequestContextInterface(), annotation, key.getTypeLiteral()).build(requestContextFactoryKey));
        } else {
            this.install(new FactoryModuleBuilder().implement(this.getRequestContextInterface(), key.getTypeLiteral()).build(requestContextFactoryKey));
        }
    }

    protected void bindFrontController() {
        Key<?> key = this.getFrontControllerKey();
        try {
            key.getTypeLiteral().getSupertype(FrontController.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The front controller Key must implement " + FrontController.class.getName() + " : " + key);
        }
        this.bind(FrontController.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindSpincastUtilsClass() {
        Key<?> key = this.getSpincastUtilsKey();
        try {
            key.getTypeLiteral().getSupertype(SpincastUtils.class);
        }
        catch (Exception ex) {
            throw new RuntimeException("The Spincast Utils Key must implement " + SpincastUtils.class.getName() + " : " + key);
        }
        this.bind(SpincastUtils.class).to(key).in(Scopes.SINGLETON);
    }

    protected void bindJsonObjectFactory() {
        this.install(new FactoryModuleBuilder().implement(JsonObject.class, this.getJsonObjectImplClass()).implement(JsonArray.class, this.getJsonArrayImplClass()).build(JsonObjectFactory.class));
    }

    protected Key<?> getFrontControllerKey() {
        return this.parameterizeWithContextInterfaces(SpincastFrontController.class);
    }

    protected Key<?> getSpincastUtilsKey() {
        return Key.get(SpincastUtilsDefault.class);
    }

    protected Class<? extends JsonObject> getJsonObjectImplClass() {
        return JsonObjectDefault.class;
    }

    protected Class<? extends JsonArray> getJsonArrayImplClass() {
        return JsonArrayDefault.class;
    }

    protected void bindWebsocketEndpointHandlerFactory() {
        Key<WebsocketEndpointHandlerFactory> factoryKey = this.parameterizeWithContextInterfaces(WebsocketEndpointHandlerFactory.class);
        this.install(new FactoryModuleBuilder().implement(WebsocketEndpointHandler.class, this.getWebsocketEndpointHandlerKey().getTypeLiteral()).build(factoryKey));
    }

    protected Key<?> getWebsocketEndpointHandlerKey() {
        return this.parameterizeWithContextInterfaces(WebsocketEndpointHandlerDefault.class);
    }

    protected void bindWebsocketContextFactory() {
        Key<WebsocketContextFactory> factoryKey = this.parameterizeWithWebsocketContext(WebsocketContextFactory.class);
        this.install(new FactoryModuleBuilder().implement((Class)this.getWebsocketContextInterface(), this.getWebsocketContextImplementationClass()).build(factoryKey));
    }

    protected void bindWebsocketEndpointToControllerManager() {
        this.bind(WebsocketEndpointToControllerManager.class).to(this.getWebsocketEndpointToControllerKeysMapClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends WebsocketEndpointToControllerManager> getWebsocketEndpointToControllerKeysMapClass() {
        return WebsocketEndpointToControllerManagerDefault.class;
    }

    protected void bindSSLContextFactory() {
        this.bind(SSLContextFactory.class).to(this.getSSLContextFactoryClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends SSLContextFactory> getSSLContextFactoryClass() {
        return SSLContextFactoryDefault.class;
    }

    protected void bindValidators() {
        this.bind(Validators.class).to(this.getValidatorsImplClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends Validators> getValidatorsImplClass() {
        return ValidatorsDefault.class;
    }

    protected void bindFormFactory() {
        this.install(new FactoryModuleBuilder().implement(Form.class, this.getFormImplClass()).build(FormFactory.class));
    }

    protected Class<? extends Form> getFormImplClass() {
        return FormDefault.class;
    }

    protected void bindValidationFactory() {
        this.install(new FactoryModuleBuilder().implement(ValidationSet.class, this.getValidationSetImplClass()).implement(ValidationMessage.class, this.getValidationMessageImplClass()).build(ValidationFactory.class));
    }

    protected Class<? extends ValidationSet> getValidationSetImplClass() {
        return ValidationSetSimple.class;
    }

    protected Class<? extends ValidationMessage> getValidationMessageImplClass() {
        return ValidationMessageDefault.class;
    }

    protected void bindFlashMessageFactory() {
        this.install(new FactoryModuleBuilder().implement(FlashMessage.class, this.getFlashMessageImplClass()).build(FlashMessageFactory.class));
    }

    protected Class<? extends FlashMessage> getFlashMessageImplClass() {
        return FlashMessageDefault.class;
    }

    protected void bindFlashMessagesHolder() {
        this.bind(FlashMessagesHolder.class).to(this.getFlashMessagesHolderImplClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends FlashMessagesHolder> getFlashMessagesHolderImplClass() {
        return FlashMessagesHolderDefault.class;
    }

    protected void bindObjectConverter() {
        this.bind(ObjectConverter.class).to(this.getObjectConverterImplClass()).in(Scopes.SINGLETON);
    }

    protected Class<? extends ObjectConverter> getObjectConverterImplClass() {
        return ObjectConverterDefault.class;
    }

    protected void bindCookieFactory() {
        this.install(new FactoryModuleBuilder().implement(Cookie.class, this.getCookieImplClass()).build(CookieFactory.class));
    }

    protected Class<? extends Cookie> getCookieImplClass() {
        return CookieDefault.class;
    }

    protected void bindTestingModeFlag() {
        boolean isTestingMode = false;
        GuiceTweaker guiceTweaker = GuiceTweaker.threadLocal.get();
        if (guiceTweaker != null) {
            isTestingMode = true;
        } else {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            List<StackTraceElement> list = Arrays.asList(stackTrace);
            for (StackTraceElement element : list) {
                if (!element.getClassName().startsWith("org.junit.") && !element.getClassName().startsWith("org.testng.")) continue;
                isTestingMode = true;
            }
        }
        this.bind(Boolean.class).annotatedWith(TestingMode.class).toInstance((Object)isTestingMode);
    }

    protected void spincastInit() {
        this.bind(SpincastInit.class).asEagerSingleton();
    }
}

