/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.spincast.core.utils.Pair;
import org.spincast.core.utils.SpincastStatics;

public abstract class DictionaryBase {
    private Map<String, Map<String, String>> messages;

    protected final void key(String key, Pair ... langMsgs) {
        if (langMsgs == null || langMsgs.length == 0) {
            return;
        }
        Map<String, String> map = this.getMessages().get(key);
        if (map == null) {
            map = new HashMap<String, String>();
            this.getMessages().put(key, map);
        }
        for (Pair langMsg : langMsgs) {
            map.put(langMsg.getKey(), SpincastStatics.stringValueOrNull(langMsg.getValue()));
        }
    }

    protected Pair msg(String lang, String msg) {
        return Pair.of(lang, msg);
    }

    protected Map<String, Map<String, String>> getMessages() {
        if (this.messages == null) {
            this.messages = new HashMap<String, Map<String, String>>();
        }
        return this.messages;
    }
}

