/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpincastRequestScope
implements Scope {
    protected final Logger logger = LoggerFactory.getLogger(SpincastRequestScope.class);
    private final ThreadLocal<Map<Key<?>, Object>> values = new ThreadLocal();

    public void enter() {
        Preconditions.checkState((this.values.get() == null ? 1 : 0) != 0, (Object)"A scoping block is already in progress");
        this.values.set(Maps.newHashMap());
    }

    public void exit() {
        Preconditions.checkState((this.values.get() != null ? 1 : 0) != 0, (Object)"No scoping block in progress");
        this.values.remove();
    }

    public <T> void seed(Key<T> key, T value) {
        Map<Key<?>, Object> scopedObjects = this.getScopedObjectMap(key);
        if (scopedObjects.containsKey(key)) {
            this.logger.warn("Replacing key '" + key + "' in our custom " + SpincastRequestScope.class.getSimpleName() + "!");
        }
        scopedObjects.put(key, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(Key.get(clazz), value);
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopedObjects = SpincastRequestScope.this.getScopedObjectMap(key);
                Object current = scopedObjects.get(key);
                if (current == null && !scopedObjects.containsKey(key)) {
                    current = unscoped.get();
                    if (Scopes.isCircularProxy((Object)current)) {
                        return current;
                    }
                    scopedObjects.put(key, current);
                }
                return current;
            }
        };
    }

    protected <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        Map<Key<?>, Object> scopedObjects = this.values.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }

    public static <T> Provider<T> getSeedErrorProvider(final Key key) {
        return new Provider<Object>(){

            public Object get() {
                throw new IllegalStateException("If you got here then it means that your code asked for scoped object " + key + " which should have been" + " explicitly seeded in this the " + SpincastRequestScope.class + " scope by calling" + " " + SpincastRequestScope.class + "#seed(), but was not.");
            }
        };
    }
}

