/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.ElementTransformer;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectArrayBase;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.ToJsonObjectConvertible;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.SpincastUtils;

public class JsonObjectDefault
extends JsonObjectArrayBase
implements JsonObject {
    protected final Logger logger = LoggerFactory.getLogger(JsonObjectDefault.class);
    private final Map<String, Object> map;

    @AssistedInject
    public JsonObjectDefault(JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        this((Map<String, Object>)null, true, jsonManager, spincastUtils, objectConverter);
    }

    @AssistedInject
    public JsonObjectDefault(@Assisted @Nullable Map<String, Object> initialMap, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        this(initialMap, true, jsonManager, spincastUtils, objectConverter);
    }

    @AssistedInject
    public JsonObjectDefault(@Assisted @Nullable Map<String, Object> initialMap, @Assisted boolean mutable, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        super(mutable, jsonManager, spincastUtils, objectConverter);
        Map<String, Object> map;
        if (initialMap != null) {
            if (!mutable) {
                for (Object element : initialMap.values()) {
                    if (!(element instanceof JsonObjectOrArray) || !((JsonObjectOrArray)element).isMutable()) continue;
                    throw new RuntimeException("To create an immutable JsonObject from an initial Map, all the JsonObject and JsonArray elements of that Map must already be immutable too. Here, at least one element is not immutable : " + element);
                }
            }
            map = initialMap;
        } else {
            map = new HashMap<String, Object>();
        }
        if (!mutable) {
            map = Collections.unmodifiableMap(map);
        }
        this.map = map;
    }

    @AssistedInject
    public JsonObjectDefault(@Assisted @Nullable JsonObject configToMerge, @Assisted boolean mutable, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        super(mutable, jsonManager, spincastUtils, objectConverter);
        Map<String, Object> map = new HashMap<String, Object>();
        if (configToMerge != null) {
            configToMerge = configToMerge.clone(mutable);
            for (Map.Entry entry : configToMerge) {
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (!mutable) {
            map = Collections.unmodifiableMap(map);
        }
        this.map = map;
    }

    protected Map<String, Object> getMap() {
        return this.map;
    }

    @Override
    protected JsonObject putAsIs(String key, Object value) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        Objects.requireNonNull(key, "The key can't be NULL");
        this.getMap().put(key, value);
        return this;
    }

    @Override
    public JsonObject setNoKeyParsing(String jsonPath, Object value) {
        this.put(jsonPath, value, false, false);
        return this;
    }

    @Override
    public JsonObject setNoKeyParsing(String jsonPath, Object value, boolean clone) {
        this.put(jsonPath, value, clone, false);
        return this;
    }

    @Override
    public JsonObject merge(Map<String, ?> map) {
        return this.merge(map, false);
    }

    @Override
    public JsonObject merge(Map<String, ?> map, boolean clone) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        if (map == null) {
            return this;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue(), clone);
        }
        return this;
    }

    @Override
    public JsonObject merge(JsonObject jsonObj) {
        return this.merge(jsonObj, false);
    }

    @Override
    public JsonObject merge(ToJsonObjectConvertible obj) {
        JsonObject jsonObj = null;
        if (obj != null) {
            jsonObj = obj.convertToJsonObject();
        }
        return this.merge(jsonObj, false);
    }

    @Override
    public JsonObject merge(JsonObject jsonObj, boolean clone) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        if (jsonObj == null) {
            return this;
        }
        for (Map.Entry entry : jsonObj) {
            this.put((String)entry.getKey(), entry.getValue(), clone, false);
        }
        return this;
    }

    @Override
    public JsonObject remove(String jsonPath) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getJsonManager().removeElementAtJsonPath(this, jsonPath);
        return this;
    }

    @Override
    public JsonObject removeNoKeyParsing(String key) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getMap().remove(key);
        return this;
    }

    @Override
    public JsonObject clear() {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getMap().clear();
        return this;
    }

    @Override
    public boolean isElementExistsNoKeyParsing(String key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.getMap().entrySet().iterator();
    }

    @Override
    protected Object getElementNoKeyParsing(String jsonPath, boolean hasDefaultValue, Object defaultValue) {
        if (this.isElementExistsNoKeyParsing(jsonPath)) {
            return this.getMap().get(jsonPath);
        }
        if (hasDefaultValue) {
            return defaultValue;
        }
        return null;
    }

    @Override
    public Map<String, Object> convertToPlainMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof JsonObject) {
                value = ((JsonObject)((Object)value)).convertToPlainMap();
            } else if (value instanceof JsonArray) {
                value = ((JsonArray)((Object)value)).convertToPlainList();
            }
            map.put(entry.getKey(), value);
        }
        return map;
    }

    @Override
    public <T> T convert(Class<T> clazz) {
        Objects.requireNonNull(clazz, "The class can't be NULL");
        return this.getJsonManager().fromString(this.toJsonString(), clazz);
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEquivalentTo(JsonObject other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.getMap().entrySet()) {
            String key = entry.getKey();
            Object thisElement = entry.getValue();
            Object otherElement = other.getObject(key);
            Object otherElementConverted = this.getObjectConverter().convertTo(otherElement, thisElement != null ? thisElement.getClass() : null);
            if (thisElement != null && thisElement instanceof JsonObject) {
                if (otherElementConverted != null && !(otherElementConverted instanceof JsonObject)) {
                    return false;
                }
                if (((JsonObject)thisElement).isEquivalentTo((JsonObject)otherElementConverted)) continue;
                return false;
            }
            if (thisElement != null && thisElement instanceof JsonArray) {
                if (otherElementConverted != null && !(otherElementConverted instanceof JsonArray)) {
                    return false;
                }
                if (((JsonArray)thisElement).isEquivalentTo((JsonArray)otherElementConverted)) continue;
                return false;
            }
            if (thisElement != null && thisElement instanceof byte[]) {
                if (otherElementConverted != null && !(otherElementConverted instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])thisElement, (byte[])otherElementConverted)) continue;
                return false;
            }
            if (Objects.equals(thisElement, otherElementConverted)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonObject clone(boolean mutable) {
        return this.getJsonManager().cloneJsonObject(this, mutable);
    }

    @Override
    public void transformAll(ElementTransformer transformer, boolean recursive) {
        for (String key : this.getMap().keySet()) {
            this.transform(key, transformer);
            if (!recursive) continue;
            Object obj = this.getObject(key);
            if (obj instanceof JsonArray) {
                ((JsonArray)obj).transformAll(transformer, recursive);
                continue;
            }
            if (!(obj instanceof JsonObject)) continue;
            ((JsonObject)obj).transformAll(transformer, recursive);
        }
    }

    protected static interface IFirstElementGetter<T> {
        public T get(JsonArray var1, boolean var2, T var3);
    }
}

