/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import com.google.inject.util.Modules;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.DontIntercept;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.utils.SpincastStatics;

public class GuiceModuleUtils {
    protected static final Logger logger = LoggerFactory.getLogger(GuiceModuleUtils.class);
    private Module module;
    private List<Element> elements;

    public GuiceModuleUtils(Module module) {
        Objects.requireNonNull(module, "The module can't be NULL");
        this.module = module;
    }

    public GuiceModuleUtils(Set<Module> modules) {
        this(Modules.combine(modules));
    }

    public GuiceModuleUtils(Module ... modules) {
        this(Modules.combine((Module[])modules));
    }

    protected Module getModule() {
        return this.module;
    }

    protected List<Element> getElements() {
        if (this.elements == null) {
            this.elements = Elements.getElements((Module[])new Module[]{this.module});
        }
        return this.elements;
    }

    public boolean isKeyBound(Class<?> clazz) {
        return this.isKeyBound(Key.get(clazz));
    }

    public boolean isKeyBound(final Key<?> keyToCheck) {
        final boolean[] keyFound = new boolean[]{false};
        for (Element element : this.getElements()) {
            if (keyFound[0]) break;
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    Key key = binding.getKey();
                    if (key.equals((Object)keyToCheck)) {
                        keyFound[0] = true;
                    }
                    return null;
                }
            });
        }
        return keyFound[0];
    }

    public <T> Class<? extends T> getBindingTarget(Key<T> specificKey) {
        Objects.requireNonNull(specificKey, "The key can't be NULL");
        Set<Class<T>> boundClasses = this.getBoundClasses(null, specificKey);
        if (boundClasses == null || boundClasses.size() == 0) {
            return null;
        }
        return boundClasses.iterator().next();
    }

    public <T> Class<? extends T> getBindingTarget(Class<T> specificClass) {
        return this.getBindingTarget(Key.get(specificClass));
    }

    public <T> Set<Class<? extends T>> getBoundClassesExtending(Class<? extends T> parentType) {
        Objects.requireNonNull(parentType, "The parent type can't be NULL");
        return this.getBoundClasses(parentType, null);
    }

    protected <T> Set<Class<? extends T>> getBoundClasses(final Class<? extends T> parentType, final Key<?> specificKey) {
        final HashSet<Class<? extends T>> bindings = new HashSet<Class<? extends T>>();
        for (Element element : this.getElements()) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <B> Void visit(Binding<B> binding) {
                    binding.acceptTargetVisitor((BindingTargetVisitor)new DefaultBindingTargetVisitor<B, Void>(){

                        public Void visit(InstanceBinding<? extends B> instanceBinding) {
                            Key key = instanceBinding.getKey();
                            Object instance = instanceBinding.getInstance();
                            if (instance instanceof Class) {
                                Class bindingClass = (Class)instance;
                                if (specificKey != null) {
                                    if (specificKey.equals((Object)key)) {
                                        Class temp = bindingClass;
                                        bindings.add(temp);
                                    }
                                } else if (parentType.isAssignableFrom(bindingClass)) {
                                    Class temp = bindingClass;
                                    bindings.add(temp);
                                }
                            }
                            return null;
                        }

                        public Void visit(UntargettedBinding<? extends B> untargettedBinding) {
                            Key key = untargettedBinding.getKey();
                            Class keyClass = key.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals((Object)key)) {
                                    Class temp = keyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(keyClass)) {
                                Class temp = keyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }

                        public Void visit(LinkedKeyBinding<? extends B> linkedKeyBinding) {
                            Key bindingKey = linkedKeyBinding.getKey();
                            Class bindingKeyClass = bindingKey.getTypeLiteral().getRawType();
                            Key linkedKey = linkedKeyBinding.getLinkedKey();
                            Class linkedKeyClass = linkedKey.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals((Object)bindingKey)) {
                                    Class temp = linkedKeyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(bindingKeyClass)) {
                                Class temp = linkedKeyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }
                    });
                    return null;
                }
            });
        }
        return bindings;
    }

    public static SpincastGuiceModuleBase createInterceptorModule(final Class<?> toIntercept, final Class<?> implementationClass, final boolean ignoreMethodsAnnotatedWithInject) {
        Objects.requireNonNull(toIntercept, "The Class to intercept can't be NULL");
        Objects.requireNonNull(implementationClass, "The implementation class can't be NULL");
        final HashMap<String, Method> toInterceptMethodsMap = new HashMap<String, Method>();
        Set<Method> toInterceptMethods = SpincastStatics.getAllMethods(implementationClass, false);
        for (Method toInterceptMethod : toInterceptMethods) {
            String methodKey = GuiceModuleUtils.createMethodeSignatureKey(toInterceptMethod);
            toInterceptMethodsMap.put(methodKey, toInterceptMethod);
        }
        return new SpincastGuiceModuleBase(){

            @Override
            protected void configure() {
                MethodInterceptor interceptor = new MethodInterceptor(){
                    @Inject
                    protected Provider<Injector> injector;
                    private Object implementation;

                    public Object getImplementation() {
                        if (this.implementation == null) {
                            this.implementation = ((Injector)this.injector.get()).getInstance(implementationClass);
                        }
                        return this.implementation;
                    }

                    public Object invoke(MethodInvocation invocation) throws Throwable {
                        Method method = invocation.getMethod();
                        String methodKey = GuiceModuleUtils.createMethodeSignatureKey(method);
                        if (!toInterceptMethodsMap.containsKey(methodKey) || method.isAnnotationPresent(DontIntercept.class)) {
                            return invocation.proceed();
                        }
                        if (ignoreMethodsAnnotatedWithInject && (method.isAnnotationPresent(Inject.class) || method.isAnnotationPresent(javax.inject.Inject.class))) {
                            return invocation.proceed();
                        }
                        Method toInterceptMethod = (Method)toInterceptMethodsMap.get(methodKey);
                        toInterceptMethod.setAccessible(true);
                        try {
                            return toInterceptMethod.invoke(this.getImplementation(), invocation.getArguments());
                        }
                        catch (Exception ex) {
                            logger.error("invocation error", (Throwable)ex);
                            throw SpincastStatics.runtimize(ex);
                        }
                    }
                };
                this.requestInjection(interceptor);
                AbstractMatcher<Class> matcher = new AbstractMatcher<Class>(){
                    Matcher<Class> matcherToIntercept;
                    Matcher<Class> matcherImpl;
                    {
                        this.matcherToIntercept = Matchers.subclassesOf((Class)toIntercept);
                        this.matcherImpl = Matchers.subclassesOf((Class)implementationClass);
                    }

                    public boolean matches(Class t) {
                        return this.matcherToIntercept.matches((Object)t) && !this.matcherImpl.matches((Object)t);
                    }
                };
                this.bindInterceptor((Matcher)matcher, Matchers.any(), new MethodInterceptor[]{interceptor});
            }
        };
    }

    protected static String createMethodeSignatureKey(Method method) {
        if (method == null) {
            return null;
        }
        String key = method.getName() + " " + Arrays.toString(method.getParameterTypes());
        return key;
    }

    public static Module removeBindings(Module module, final Set<Key<?>> keysToRemove) {
        if (keysToRemove == null || keysToRemove.size() == 0) {
            return module;
        }
        ArrayList elements = new ArrayList(Elements.getElements((Module[])new Module[]{module}));
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            boolean remove = (Boolean)element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Boolean>(){

                public <T> Boolean visit(Binding<T> binding) {
                    return keysToRemove.contains(binding.getKey());
                }

                public Boolean visitOther(Element other) {
                    return false;
                }
            });
            if (!remove) continue;
            i.remove();
        }
        Module newModule = Elements.getModule(elements);
        return newModule;
    }
}

