/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.websocket;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastRequestScoped;
import org.spincast.core.json.JsonManager;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.timezone.TimeZoneResolver;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketContextBaseDeps;
import org.spincast.core.websocket.WebsocketPeerManager;
import org.spincast.core.xml.XmlManager;

public abstract class WebsocketContextBase<W extends WebsocketContext<?>> {
    protected static final Logger logger = LoggerFactory.getLogger(WebsocketContextBase.class);
    private final String endpointId;
    private final String peerId;
    private final WebsocketPeerManager peerManager;
    private final LocaleResolver localeResolver;
    private final TimeZoneResolver timeZoneResolver;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final TemplatingEngine templatingEngine;
    private final Provider<Injector> injectorProvider;
    private Map<Key<?>, Object> instanceFromGuiceCache;

    public WebsocketContextBase(String endpointId, String peerId, WebsocketPeerManager peerManager, WebsocketContextBaseDeps<W> deps) {
        this.endpointId = endpointId;
        this.peerId = peerId;
        this.peerManager = peerManager;
        this.localeResolver = deps.getLocaleResolver();
        this.timeZoneResolver = deps.getTimeZoneResolver();
        this.jsonManager = deps.getJsonManager();
        this.xmlManager = deps.getXmlManager();
        this.templatingEngine = deps.getTemplatingEngine();
        this.injectorProvider = deps.getInjectorProvider();
    }

    public WebsocketPeerManager peerManager() {
        return this.peerManager;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public void sendMessageToCurrentPeer(String message) {
        this.peerManager().sendMessage(message);
    }

    public void sendMessageToCurrentPeer(byte[] bytes) {
        this.peerManager().sendMessage(bytes);
    }

    public void closeConnectionWithCurrentPeer() {
        this.peerManager().closeConnection();
    }

    public JsonManager json() {
        return this.jsonManager;
    }

    public XmlManager xml() {
        return this.xmlManager;
    }

    public TemplatingEngine templating() {
        return this.templatingEngine;
    }

    protected Map<Key<?>, Object> getInstanceFromGuiceCache() {
        if (this.instanceFromGuiceCache == null) {
            this.instanceFromGuiceCache = new HashMap();
        }
        return this.instanceFromGuiceCache;
    }

    public Injector guice() {
        return (Injector)this.injectorProvider.get();
    }

    public <T> T get(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can't be NULL");
        return this.get(Key.get(clazz));
    }

    public <T> T get(Key<T> key) {
        Objects.requireNonNull(key, "key can't be NULL");
        Object obj = null;
        Map<Key<?>, Object> cache = this.getInstanceFromGuiceCache();
        if (!cache.containsKey(key)) {
            obj = this.guice().getInstance(key);
            Binding binding = this.guice().getBinding(key);
            if (Scopes.isScoped((Binding)binding, (Scope)SpincastGuiceScopes.REQUEST, SpincastRequestScoped.class) || Scopes.isScoped((Binding)binding, (Scope)Scopes.SINGLETON, Singleton.class)) {
                cache.put(key, obj);
            }
        } else {
            Object asT;
            obj = asT = cache.get(key);
        }
        return (T)obj;
    }

    protected LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public Locale getLocaleToUse() {
        return this.getLocaleResolver().getLocaleToUse();
    }

    protected TimeZoneResolver getTimeZoneResolver() {
        return this.timeZoneResolver;
    }

    public TimeZone getTimeZoneToUse() {
        return this.getTimeZoneResolver().getTimeZoneToUse();
    }
}

