/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.websocket;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.server.Server;
import org.spincast.core.websocket.WebsocketConnectionConfig;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketController;
import org.spincast.core.websocket.WebsocketEndpointHandler;
import org.spincast.core.websocket.WebsocketEndpointHandlerFactory;
import org.spincast.core.websocket.WebsocketEndpointManager;
import org.spincast.core.websocket.WebsocketEndpointToControllerManager;
import org.spincast.core.websocket.WebsocketRoute;
import org.spincast.core.websocket.exceptions.WebsocketEndpointAlreadyManagedByAnotherControllerException;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class WebsocketRouteHandler<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements Handler<R> {
    protected static final Logger logger = LoggerFactory.getLogger(WebsocketRouteHandler.class);
    private final WebsocketRoute<R, W> websocketRoute;
    private final Server server;
    private final WebsocketEndpointHandlerFactory<R, W> websocketServerEndpointHandlerFactory;
    private final WebsocketEndpointToControllerManager websocketEndpointToControllerManager;
    private final Map<String, Object> endpointCreationLock = new ConcurrentHashMap<String, Object>();
    private final Object endpointLockCreationLock = new Object();
    private final Map<String, WebsocketEndpointHandler> serverEndpointHandlers = new HashMap<String, WebsocketEndpointHandler>();

    @AssistedInject
    public WebsocketRouteHandler(@Assisted WebsocketRoute<R, W> websocketRoute, Server server, WebsocketEndpointHandlerFactory<R, W> websocketServerEndpointHandlerFactory, WebsocketEndpointToControllerManager websocketEndpointToControllerKeysMap) {
        this.websocketRoute = websocketRoute;
        this.server = server;
        this.websocketServerEndpointHandlerFactory = websocketServerEndpointHandlerFactory;
        this.websocketEndpointToControllerManager = websocketEndpointToControllerKeysMap;
    }

    protected WebsocketRoute<R, W> getWebsocketRoute() {
        return this.websocketRoute;
    }

    protected Server getServer() {
        return this.server;
    }

    protected Map<String, WebsocketEndpointHandler> getServerEndpointHandlers() {
        return this.serverEndpointHandlers;
    }

    protected WebsocketEndpointHandlerFactory<R, W> getWebsocketServerEndpointHandlerFactory() {
        return this.websocketServerEndpointHandlerFactory;
    }

    protected WebsocketEndpointToControllerManager getWebsocketEndpointToControllerManager() {
        return this.websocketEndpointToControllerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getEndpointCreationLock(String endpointId) {
        Object lock = this.endpointCreationLock.get(endpointId);
        if (lock == null) {
            Object object = this.endpointLockCreationLock;
            synchronized (object) {
                lock = this.endpointCreationLock.get(endpointId);
                if (lock == null) {
                    lock = new Object();
                    this.endpointCreationLock.put(endpointId, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(R context) {
        WebsocketConnectionConfig connectionConfig = this.getWebsocketRoute().getWebsocketController().onPeerPreConnect(context);
        if (connectionConfig == null) {
            this.manageCancellationFromOnPeerPreConnect();
            return;
        }
        String endpointId = connectionConfig.getEndpointId();
        if (StringUtils.isBlank((CharSequence)endpointId)) {
            throw new RuntimeException("The WebSocket endpoint id can't be empty.");
        }
        String peerId = connectionConfig.getPeerId();
        if (StringUtils.isBlank((CharSequence)peerId)) {
            peerId = this.generatePeerId(context, endpointId);
        }
        if (!this.getWebsocketEndpointToControllerManager().isManagingEndpoint(endpointId, this.getWebsocketRoute().getWebsocketController())) {
            Object object = this.getEndpointCreationLock(endpointId);
            synchronized (object) {
                if (!this.getWebsocketEndpointToControllerManager().isManagingEndpoint(endpointId, this.getWebsocketRoute().getWebsocketController())) {
                    try {
                        this.getWebsocketEndpointToControllerManager().addEndpointController(endpointId, this.getWebsocketRoute().getWebsocketController());
                    }
                    catch (WebsocketEndpointAlreadyManagedByAnotherControllerException ex) {
                        throw new RuntimeException("The endpoint '" + endpointId + "' is already managed by another controller : " + ex.getCurrentManagingControllerKey() + ". It can't be managed by: " + ex.getNewControllerKey());
                    }
                    WebsocketEndpointManager websocketEndpointManager = this.getServer().getWebsocketEndpointManager(endpointId);
                    if (websocketEndpointManager != null) {
                        throw new RuntimeException("No existing controller was found to manage the WebSocket endpoint '" + endpointId + "' but we found a " + WebsocketEndpointManager.class.getSimpleName() + " object in the server.");
                    }
                    WebsocketEndpointHandler websocketEndpointHandler = this.createWebsocketEndpointHandler(endpointId, this.getWebsocketRoute().getWebsocketController());
                    websocketEndpointManager = this.getServer().websocketCreateEndpoint(endpointId, websocketEndpointHandler);
                    this.getWebsocketRoute().getWebsocketController().onEndpointReady(websocketEndpointManager);
                }
            }
        }
        this.getServer().websocketConnection(context.exchange(), endpointId, peerId);
        throw new SkipRemainingHandlersException();
    }

    protected void manageCancellationFromOnPeerPreConnect() {
        throw new SkipRemainingHandlersException();
    }

    protected WebsocketEndpointHandler createWebsocketEndpointHandler(final String endpointId, WebsocketController<R, W> controller) {
        final WebsocketEndpointHandler controllerHandler = this.getWebsocketServerEndpointHandlerFactory().create(endpointId, controller);
        return new WebsocketEndpointHandler(){

            @Override
            public void onPeerMessage(String peerId, byte[] message) {
                controllerHandler.onPeerMessage(peerId, message);
            }

            @Override
            public void onPeerMessage(String peerId, String message) {
                controllerHandler.onPeerMessage(peerId, message);
            }

            @Override
            public void onPeerConnected(String peerId) {
                controllerHandler.onPeerConnected(peerId);
            }

            @Override
            public void onPeerClosed(String peerId) {
                controllerHandler.onPeerClosed(peerId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndpointClosed() {
                Object object = WebsocketRouteHandler.this.getEndpointCreationLock(endpointId);
                synchronized (object) {
                    WebsocketRouteHandler.this.getWebsocketEndpointToControllerManager().removeEndpointController(endpointId);
                    controllerHandler.onEndpointClosed();
                }
            }
        };
    }

    protected String generatePeerId(R context, String endpointId) {
        return endpointId + "_" + UUID.randomUUID().toString();
    }
}

