/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.utils;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.time.FastDateFormat;

public class SpincastStatics {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastStatics.class);
    private static SpincastStatics instance;
    private static FastDateFormat iso8601DateParser1;
    private static FastDateFormat iso8601DateParser2;
    private static FastDateFormat iso8601DateParser3;
    private static FastDateFormat iso8601DateParser4;
    private static FastDateFormat iso8601DateParser5;
    private static FastDateFormat iso8601DateParser6;

    protected static SpincastStatics getInstance() {
        if (instance == null) {
            instance = new SpincastStatics();
        }
        return instance;
    }

    public static void setInstance(SpincastStatics instance) {
        SpincastStatics.instance = instance;
    }

    public static FastDateFormat getIso8601DateParserDefault() {
        return iso8601DateParser1;
    }

    protected static FastDateFormat getIso8601DateParser1() {
        return iso8601DateParser1;
    }

    protected static FastDateFormat getIso8601DateParser2() {
        return iso8601DateParser2;
    }

    protected static FastDateFormat getIso8601DateParser3() {
        return iso8601DateParser3;
    }

    protected static FastDateFormat getIso8601DateParser4() {
        return iso8601DateParser4;
    }

    protected static FastDateFormat getIso8601DateParser5() {
        return iso8601DateParser5;
    }

    protected static FastDateFormat getIso8601DateParser6() {
        return iso8601DateParser6;
    }

    public static RuntimeException runtimize(Exception ex) {
        return SpincastStatics.getInstance().runtimizePrivate(ex);
    }

    protected RuntimeException runtimizePrivate(Exception ex) {
        RuntimeException exceptionToReturn;
        Throwable wrappedException;
        Objects.requireNonNull(ex, "NULL exception");
        if (ex instanceof InvocationTargetException && (wrappedException = ((InvocationTargetException)ex).getTargetException()) != null && wrappedException instanceof Exception) {
            ex = (Exception)wrappedException;
        }
        if (ex instanceof InterruptedException && (exceptionToReturn = this.manageInterruptedException(ex)) != null) {
            return exceptionToReturn;
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex.getMessage(), ex);
    }

    protected RuntimeException manageInterruptedException(Exception ex) {
        Thread.currentThread().interrupt();
        return new RuntimeException(ex.getMessage(), ex);
    }

    public static String getStackTrace(Throwable ex) {
        return SpincastStatics.getInstance().getStackTraceInstance(ex);
    }

    protected String getStackTraceInstance(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public static <K, V> Map<K, V> map(K key1, V value1) {
        return SpincastStatics.getInstance().mapInstance(key1, value1);
    }

    public static Map<String, Object> params(String key1, Object value1) {
        return SpincastStatics.map(key1, value1);
    }

    protected <K, V> Map<K, V> mapInstance(K key1, V value1) {
        Objects.requireNonNull(key1, "The keys can't be NULL");
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2) {
        return SpincastStatics.getInstance().mapInstance(key1, value1, key2, value2);
    }

    public static Map<String, Object> params(String key1, Object value1, String key2, Object value2) {
        return SpincastStatics.map(key1, value1, key2, value2);
    }

    protected <K, V> Map<K, V> mapInstance(K key1, V value1, K key2, V value2) {
        Objects.requireNonNull(key2, "The keys can't be NULL");
        Map<K, V> map = this.mapInstance(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3) {
        return SpincastStatics.getInstance().mapInstance(key1, value1, key2, value2, key3, value3);
    }

    public static Map<String, Object> params(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return SpincastStatics.map(key1, value1, key2, value2, key3, value3);
    }

    protected <K, V> Map<K, V> mapInstance(K key1, V value1, K key2, V value2, K key3, V value3) {
        Objects.requireNonNull(key3, "The keys can't be NULL");
        Map<K, V> map = this.mapInstance(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return SpincastStatics.getInstance().mapInstance(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Map<String, Object> params(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        return SpincastStatics.map(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    protected <K, V> Map<K, V> mapInstance(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        Objects.requireNonNull(key4, "The keys can't be NULL");
        Map<K, V> map = this.mapInstance(key1, value1, key2, value2, key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        return SpincastStatics.getInstance().mapInstance(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static Map<String, Object> params(String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        return SpincastStatics.map(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    protected <K, V> Map<K, V> mapInstance(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        Objects.requireNonNull(key5, "The keys can't be NULL");
        Map<K, V> map = this.mapInstance(key1, value1, key2, value2, key3, value3, key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static Set<Method> getAllMethods(Class<?> clazz) {
        return SpincastStatics.getAllMethods(clazz, true);
    }

    public static Set<Method> getAllMethods(Class<?> clazz, boolean includeJavaLangObjectMethods) {
        return SpincastStatics.getInstance().getAllMethodsInstance(clazz, includeJavaLangObjectMethods);
    }

    protected Set<Method> getAllMethodsInstance(Class<?> clazz, boolean includeJavaLangObjectMethods) {
        Class<?> superClass;
        Objects.requireNonNull(clazz, "The class can't be NULL");
        HashSet<Method> allMethods = new HashSet<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Method[] methods = clazz.getMethods();
        if (clazz.getSuperclass() != null && (!(superClass = clazz.getSuperclass()).equals(Object.class) || includeJavaLangObjectMethods)) {
            Set<Method> superClassMethods = SpincastStatics.getAllMethods(superClass, includeJavaLangObjectMethods);
            allMethods.addAll(superClassMethods);
        }
        allMethods.addAll(Arrays.asList(declaredMethods));
        allMethods.addAll(Arrays.asList(methods));
        return allMethods;
    }

    public static Date parseISO8601date(String str) {
        return SpincastStatics.getInstance().parseISO8601dateInstance(str);
    }

    public Date parseISO8601dateInstance(String str) {
        if (str == null) {
            return null;
        }
        Date date = null;
        try {
            date = SpincastStatics.getIso8601DateParser1().parse(str);
            return date;
        }
        catch (Exception exception) {
            try {
                date = SpincastStatics.getIso8601DateParser2().parse(str);
                return date;
            }
            catch (Exception exception2) {
                try {
                    date = SpincastStatics.getIso8601DateParser3().parse(str);
                    return date;
                }
                catch (Exception exception3) {
                    try {
                        date = SpincastStatics.getIso8601DateParser4().parse(str);
                        return date;
                    }
                    catch (Exception exception4) {
                        try {
                            date = SpincastStatics.getIso8601DateParser5().parse(str);
                            return date;
                        }
                        catch (Exception exception5) {
                            try {
                                date = SpincastStatics.getIso8601DateParser6().parse(str);
                                return date;
                            }
                            catch (Exception ex) {
                                throw SpincastStatics.runtimize(ex);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void closeQuietly(InputStream stream) {
        SpincastStatics.getInstance().closeQuietlyInstance(stream);
    }

    public void closeQuietlyInstance(InputStream stream) {
        IOUtils.closeQuietly((InputStream)stream);
    }

    public static void closeQuietly(OutputStream stream) {
        SpincastStatics.getInstance().closeQuietlyInstance(stream);
    }

    public void closeQuietlyInstance(OutputStream stream) {
        IOUtils.closeQuietly((OutputStream)stream);
    }

    public static void closeQuietly(Reader reader) {
        SpincastStatics.getInstance().closeQuietlyInstance(reader);
    }

    public void closeQuietlyInstance(Reader reader) {
        IOUtils.closeQuietly((Reader)reader);
    }

    public static void closeQuietly(Closeable closeable) {
        SpincastStatics.getInstance().closeQuietlyInstance(closeable);
    }

    public void closeQuietlyInstance(Closeable closeable) {
        IOUtils.closeQuietly((Closeable)closeable);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<? super T> clazz) {
        return SpincastStatics.getInstance().toArrayInstance(collection, clazz);
    }

    public <T> T[] toArrayInstance(Collection<T> collection, Class<? super T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(array);
    }

    public static String stringValueOrNull(Object obj) {
        return SpincastStatics.getInstance().stringValueOrNullInstance(obj);
    }

    public String stringValueOrNullInstance(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static Long longValueOrNull(Object obj) {
        return SpincastStatics.getInstance().longValueOrNullInstance(obj);
    }

    public Long longValueOrNullInstance(Object obj) {
        if (obj == null) {
            return null;
        }
        return Long.parseLong(obj.toString());
    }

    public static <T> List<T> toList(T[] array, boolean emptyListIfNullArray) {
        return SpincastStatics.getInstance().toListInstance(array, emptyListIfNullArray);
    }

    public <T> List<T> toListInstance(T[] array, boolean emptyListIfNullArray) {
        if (array == null) {
            return emptyListIfNullArray ? new ArrayList() : null;
        }
        return new ArrayList<T>(Arrays.asList(array));
    }

    public static void mkDirsOrThrow(File dir) {
        SpincastStatics.getInstance().mkDirsOrThrowInstance(dir);
    }

    public void mkDirsOrThrowInstance(File dir) {
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            return;
        }
        boolean res = dir.mkdirs();
        if (!res) {
            throw new RuntimeException("Unable to create directory: " + dir.getAbsolutePath());
        }
    }

    static {
        iso8601DateParser1 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", (TimeZone)TimeZone.getTimeZone("UTC"));
        iso8601DateParser2 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ", (TimeZone)TimeZone.getTimeZone("UTC"));
        iso8601DateParser3 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX", (TimeZone)TimeZone.getTimeZone("UTC"));
        iso8601DateParser4 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mmZ", (TimeZone)TimeZone.getTimeZone("UTC"));
        iso8601DateParser5 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm", (TimeZone)TimeZone.getTimeZone("UTC"));
        iso8601DateParser6 = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)TimeZone.getTimeZone("UTC"));
    }
}

