/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.defaults.guice;

import com.google.inject.Module;
import org.spincast.core.guice.SpincastCoreGuiceModule;
import org.spincast.plugins.config.SpincastConfigPluginGuiceModule;
import org.spincast.plugins.cookies.SpincastCookiesPluginGuiceModule;
import org.spincast.plugins.dictionary.SpincastDictionaryPluginGuiceModule;
import org.spincast.plugins.jacksonjson.SpincastJacksonJsonPluginGuiceModule;
import org.spincast.plugins.jacksonxml.SpincastJacksonXmlPluginGuiceModule;
import org.spincast.plugins.localeresolver.SpincastLocaleResolverPluginGuiceModule;
import org.spincast.plugins.pebble.SpincastPebblePluginGuiceModule;
import org.spincast.plugins.request.SpincastRequestPluginGuiceModule;
import org.spincast.plugins.response.SpincastResponsePluginGuiceModule;
import org.spincast.plugins.routing.SpincastRoutingPluginGuiceModule;
import org.spincast.plugins.templatingaddon.SpincastTemplatingAddonPluginGuiceModule;
import org.spincast.plugins.undertow.SpincastUndertowPluginGuiceModule;
import org.spincast.plugins.variables.SpincastVariablesPluginGuiceModule;

public class SpincastDefaultGuiceModule
extends SpincastCoreGuiceModule {
    public SpincastDefaultGuiceModule() {
        this(null);
    }

    public SpincastDefaultGuiceModule(String[] mainArgs) {
        super(mainArgs);
    }

    protected void configure() {
        super.configure();
        this.bindConfigPlugin();
        this.bindDictionaryPlugin();
        this.bindServerPlugin();
        this.bindTemplatingEnginePlugin();
        this.binJsonManagerPlugin();
        this.binXmlManagerPlugin();
        this.bindCookiesPlugin();
        this.bindRequestPlugin();
        this.bindResponsePlugin();
        this.bindRoutingPlugin();
        this.bindTemplatingPlugin();
        this.bindVariablesPlugin();
        this.bindLocaleResolverPlugin();
    }

    protected void bindConfigPlugin() {
        this.install((Module)new SpincastConfigPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindDictionaryPlugin() {
        this.install((Module)new SpincastDictionaryPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindServerPlugin() {
        this.install((Module)new SpincastUndertowPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindTemplatingEnginePlugin() {
        this.install((Module)new SpincastPebblePluginGuiceModule(this.getRequestContextType()));
    }

    protected void binJsonManagerPlugin() {
        this.install((Module)new SpincastJacksonJsonPluginGuiceModule(this.getRequestContextType()));
    }

    protected void binXmlManagerPlugin() {
        this.install((Module)new SpincastJacksonXmlPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindCookiesPlugin() {
        this.install((Module)new SpincastCookiesPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindRequestPlugin() {
        this.install((Module)new SpincastRequestPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindResponsePlugin() {
        this.install((Module)new SpincastResponsePluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindRoutingPlugin() {
        this.installRoutingPlugin();
    }

    protected void installRoutingPlugin() {
        this.install((Module)new SpincastRoutingPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindTemplatingPlugin() {
        this.install((Module)new SpincastTemplatingAddonPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindVariablesPlugin() {
        this.install((Module)new SpincastVariablesPluginGuiceModule(this.getRequestContextType()));
    }

    protected void bindLocaleResolverPlugin() {
        this.install((Module)new SpincastLocaleResolverPluginGuiceModule(this.getRequestContextType()));
    }
}

