/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.defaults.bootstrapping;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.DefaultRequestContextDefault;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.GuiceTweaker;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.guice.SpincastContextTypesInterested;
import org.spincast.core.guice.SpincastCorePlugin;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastPlugin;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.DefaultWebsocketContextDefault;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.defaults.bootstrapping.Spincast;
import org.spincast.plugins.config.SpincastConfigPlugin;
import org.spincast.plugins.dictionary.SpincastDictionaryPlugin;
import org.spincast.plugins.httpcaching.SpincastHttpCachingPlugin;
import org.spincast.plugins.jacksonjson.SpincastJacksonJsonPlugin;
import org.spincast.plugins.jacksonxml.SpincastJacksonXmlPlugin;
import org.spincast.plugins.localeresolver.SpincastLocaleResolverPlugin;
import org.spincast.plugins.pebble.SpincastPebblePlugin;
import org.spincast.plugins.request.SpincastRequestPlugin;
import org.spincast.plugins.response.SpincastResponsePlugin;
import org.spincast.plugins.routing.SpincastRoutingPlugin;
import org.spincast.plugins.templatingaddon.SpincastTemplatingAddonPlugin;
import org.spincast.plugins.timezoneresolver.SpincastTimeZoneResolverPlugin;
import org.spincast.plugins.undertow.SpincastUndertowPlugin;
import org.spincast.plugins.variables.SpincastVariablesPlugin;

public class SpincastBootstrapper {
    protected final Logger logger = LoggerFactory.getLogger(SpincastBootstrapper.class);
    private static Map<String, Module> defaultModulesMap = null;
    private static Module defaultModuleWithCore;
    private static Module defaultModuleWithoutCore;
    private Set<Module> modules;
    private List<SpincastPlugin> plugins;
    private Set<String> pluginsToDisable;
    private boolean disableAllDefaultPlugins = false;
    private boolean disableCorePlugin = false;
    private boolean disableDefaultRoutingPlugin = false;
    private boolean disableDefaultJsonPlugin = false;
    private boolean disableDefaultXmlPlugin = false;
    private boolean disableDefaultRequestPlugin = false;
    private boolean disableDefaultResponsePlugin = false;
    private boolean disableDefaultTemplatingPlugin = false;
    private boolean disableDefaultTemplatingAddonPlugin = false;
    private boolean disableDefaultVariablesPlugin = false;
    private boolean disableDefaultLocaleResolverPlugin = false;
    private boolean disableDefaultTimeZoneResolverPlugin = false;
    private boolean disableDefaultHttpCachingPlugin = false;
    private boolean disableDefaultCookiesPlugin = false;
    private boolean disableDefaultConfigPlugin = false;
    private boolean disableDefaultDictionaryPlugin = false;
    private boolean disableDefaultServerPlugin = false;
    private boolean bindCallerClass = true;
    private boolean bindCallerClassSet = false;
    private Class<?> appClass;
    private Class<? extends RequestContext<?>> requestContextImplementationClass = null;
    private Class<? extends WebsocketContext<?>> websocketContextImplementationClass = null;

    protected Class<? extends RequestContext<?>> getRequestContextImplementationClass() {
        if (this.requestContextImplementationClass == null) {
            this.requestContextImplementationClass = DefaultRequestContextDefault.class;
        }
        return this.requestContextImplementationClass;
    }

    protected Class<? extends WebsocketContext<?>> getWebsocketContextImplementationClass() {
        if (this.websocketContextImplementationClass == null) {
            this.websocketContextImplementationClass = DefaultWebsocketContextDefault.class;
        }
        return this.websocketContextImplementationClass;
    }

    protected Class<?> getAppClass() {
        return this.appClass;
    }

    protected boolean isBindCallerClass() {
        return this.bindCallerClass;
    }

    protected boolean isBindCallerClassSet() {
        return this.bindCallerClassSet;
    }

    protected boolean isDisableAllDefaultPlugins() {
        return this.disableAllDefaultPlugins;
    }

    protected boolean isDisableCorePlugin() {
        return this.disableCorePlugin;
    }

    protected boolean isDisableDefaultRoutingPlugin() {
        return this.disableDefaultRoutingPlugin;
    }

    protected boolean isDisableDefaultJsonPlugin() {
        return this.disableDefaultJsonPlugin;
    }

    protected boolean isDisableDefaultXmlPlugin() {
        return this.disableDefaultXmlPlugin;
    }

    protected boolean isDisableDefaultRequestPlugin() {
        return this.disableDefaultRequestPlugin;
    }

    protected boolean isDisableDefaultResponsePlugin() {
        return this.disableDefaultResponsePlugin;
    }

    protected boolean isDisableDefaultTemplatingPlugin() {
        return this.disableDefaultTemplatingPlugin;
    }

    protected boolean isDisableDefaultTemplatingAddonPlugin() {
        return this.disableDefaultTemplatingAddonPlugin;
    }

    protected boolean isDisableDefaultVariablesPlugin() {
        return this.disableDefaultVariablesPlugin;
    }

    protected boolean isDisableDefaultLocaleResolverPlugin() {
        return this.disableDefaultLocaleResolverPlugin;
    }

    protected boolean isDisableDefaultTimeZoneResolverPlugin() {
        return this.disableDefaultTimeZoneResolverPlugin;
    }

    protected boolean isDisableDefaultHttpCachingPlugin() {
        return this.disableDefaultHttpCachingPlugin;
    }

    protected boolean isDisableDefaultCookiesPlugin() {
        return this.disableDefaultCookiesPlugin;
    }

    protected boolean isDisableDefaultConfigPlugin() {
        return this.disableDefaultConfigPlugin;
    }

    protected boolean isDisableDefaultDictionaryPlugin() {
        return this.disableDefaultDictionaryPlugin;
    }

    protected boolean isDisableDefaultServerPlugin() {
        return this.disableDefaultServerPlugin;
    }

    protected static Map<String, Module> getDefaultModulesMap() {
        if (defaultModulesMap == null) {
            defaultModulesMap = new HashMap<String, Module>();
        }
        return defaultModulesMap;
    }

    protected List<SpincastPlugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<SpincastPlugin>();
        }
        return this.plugins;
    }

    protected Set<Module> getModules() {
        if (this.modules == null) {
            this.modules = new HashSet<Module>();
        }
        return this.modules;
    }

    protected Set<String> getPluginsToDisable() {
        if (this.pluginsToDisable == null) {
            this.pluginsToDisable = new HashSet<String>();
        }
        return this.pluginsToDisable;
    }

    public SpincastBootstrapper requestContextImplementationClass(Class<? extends RequestContext<?>> clazz) {
        if (clazz != null && clazz.isInterface()) {
            throw new RuntimeException("You have to bind the *implementation* class of your custom RequestContext type, not its interface!");
        }
        this.requestContextImplementationClass = clazz;
        return this;
    }

    public SpincastBootstrapper websocketContextImplementationClass(Class<? extends WebsocketContext<?>> clazz) {
        if (clazz != null && clazz.isInterface()) {
            throw new RuntimeException("You have to bind the *implementation* class of your custom WebsocketContext type, not its interface!");
        }
        this.websocketContextImplementationClass = clazz;
        return this;
    }

    public SpincastBootstrapper bindCurrentClass(boolean bindCallerClass) {
        this.bindCallerClass = bindCallerClass;
        this.bindCallerClassSet = true;
        return this;
    }

    public SpincastBootstrapper appClass(Class<?> appClass) {
        this.appClass = appClass;
        return this;
    }

    public SpincastBootstrapper disableAllDefaultPlugins() {
        this.disableAllDefaultPlugins = true;
        return this;
    }

    public SpincastBootstrapper disableCorePlugin() {
        this.disableCorePlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultRoutingPlugin() {
        this.disableDefaultRoutingPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultJsonPlugin() {
        this.disableDefaultJsonPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultXmlPlugin() {
        this.disableDefaultXmlPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultRequestPlugin() {
        this.disableDefaultRequestPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultResponsePlugin() {
        this.disableDefaultResponsePlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultTemplatingPlugin() {
        this.disableDefaultTemplatingPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultTemplatingAddonPlugin() {
        this.disableDefaultTemplatingAddonPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultVariablesPlugin() {
        this.disableDefaultVariablesPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultLocaleResolverPlugin() {
        this.disableDefaultLocaleResolverPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultTimeZoneResolverPlugin() {
        this.disableDefaultTimeZoneResolverPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultHttpCachingPlugin() {
        this.disableDefaultHttpCachingPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultCookiesPlugin() {
        this.disableDefaultCookiesPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultConfigPlugin() {
        this.disableDefaultConfigPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultDictionaryPlugin() {
        this.disableDefaultDictionaryPlugin = true;
        return this;
    }

    public SpincastBootstrapper disableDefaultServerPlugin() {
        this.disableDefaultServerPlugin = true;
        return this;
    }

    public SpincastBootstrapper module(Module module) {
        Objects.requireNonNull(module, "The module can't be NULL");
        this.getModules().add(module);
        return this;
    }

    public SpincastBootstrapper modules(List<Module> modules) {
        if (modules == null || modules.size() == 0) {
            return this;
        }
        for (Module module : modules) {
            this.module(module);
        }
        return this;
    }

    public SpincastBootstrapper plugin(SpincastPlugin plugin) {
        Objects.requireNonNull(plugin, "The plugin can't be NULL");
        this.getPlugins().add(plugin);
        return this;
    }

    public SpincastBootstrapper plugins(List<SpincastPlugin> plugins) {
        if (plugins == null || plugins.size() == 0) {
            return this;
        }
        for (SpincastPlugin plugin : plugins) {
            this.plugin(plugin);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Injector init(String[] mainArgs) {
        try {
            void var4_14;
            void var4_11;
            GuiceTweaker guiceTweaker;
            if (!this.isDisableAllDefaultPlugins()) {
                this.getPlugins().addAll(this.getDefaultPlugins());
            }
            if ((guiceTweaker = (GuiceTweaker)GuiceTweaker.threadLocal.get()) != null) {
                guiceTweaker.setRequestContextImplementationClass(this.getRequestContextImplementationClass());
                guiceTweaker.setWebsocketContextImplementationClass(this.getWebsocketContextImplementationClass());
                this.getPlugins().add((SpincastPlugin)guiceTweaker);
            }
            for (SpincastPlugin spincastPlugin : this.getPlugins()) {
                if (spincastPlugin.getPluginsToDisable() == null || this.getPluginsToDisable().contains(spincastPlugin.getId())) continue;
                this.getPluginsToDisable().addAll(spincastPlugin.getPluginsToDisable());
            }
            this.addMainArgsModule(mainArgs);
            Class<?> appClass = null;
            if (this.getAppClass() != null) {
                appClass = this.getAppClass();
                this.getModules().add((Module)new SpincastGuiceModuleBase(){

                    protected void configure() {
                        this.bind(SpincastBootstrapper.this.getAppClass()).in(Scopes.SINGLETON);
                    }
                });
            } else if (this.isBindCallerClass() && (guiceTweaker == null || !guiceTweaker.isDisableBindCurrentClass())) {
                appClass = this.addCallerClassModule();
            }
            for (Module module : this.getModules()) {
                if (!(module instanceof SpincastContextTypesInterested)) continue;
                this.setSpincastContextes((SpincastContextTypesInterested)module);
            }
            for (SpincastPlugin spincastPlugin : this.getPlugins()) {
                this.setSpincastContextes((SpincastContextTypesInterested)spincastPlugin);
            }
            Module module = Modules.combine(this.getModules());
            if (guiceTweaker != null) {
                Module module2 = guiceTweaker.beforePlugins(module);
            }
            for (SpincastPlugin plugin : this.getPlugins()) {
                if (!this.getPluginsToDisable().contains(plugin.getId())) {
                    Module module3 = plugin.apply((Module)var4_11);
                    this.logger.info("Plugin '" + plugin.getId() + "' applied.");
                    continue;
                }
                this.logger.info("Plugin '" + plugin.getId() + "' ignored.");
            }
            if (guiceTweaker != null) {
                Module module4 = guiceTweaker.afterPlugins((Module)var4_11);
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{var4_14});
            for (SpincastPlugin plugin : this.getPlugins()) {
                plugin.createdGuiceInjector(injector);
            }
            if (appClass != null) {
                injector.getInstance(appClass);
            }
            return injector;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected Class<?> addCallerClassModule() {
        Class<?> callerClass = null;
        try {
            String caller = this.getCallerClassName();
            if (caller == null) {
                throw new RuntimeException("Unable to get the name of the caller class! You may want to disable its automatic binding by using \".bindCallerClass(false)\".");
            }
            callerClass = Class.forName(caller);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to create the class of the caller.You may want to disable its automatic binding by using \".bindCallerClass(false)\".");
        }
        final Class<?> callerClassFinal = callerClass;
        if (callerClassFinal != null) {
            this.getModules().add((Module)new SpincastGuiceModuleBase(){

                protected void configure() {
                    this.bind(callerClassFinal).in(Scopes.SINGLETON);
                }
            });
        }
        return callerClass;
    }

    protected String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(SpincastBootstrapper.class.getName()) || ste.getClassName().equals(Spincast.class.getName()) || ste.getClassName().equals(Thread.class.getName())) continue;
            return ste.getClassName();
        }
        return null;
    }

    protected void addMainArgsModule(String[] mainArgs) {
        if (mainArgs == null) {
            mainArgs = new String[]{};
        }
        final String[] mainArgsFinal = mainArgs;
        this.getModules().add((Module)new SpincastGuiceModuleBase(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<String[]>(){}).annotatedWith(MainArgs.class).toInstance((Object)mainArgsFinal);
                this.bind((TypeLiteral)new TypeLiteral<List<String>>(){}).annotatedWith(MainArgs.class).toInstance(Arrays.asList(mainArgsFinal));
            }
        });
    }

    protected List<SpincastPlugin> getDefaultPlugins() {
        return this.getDefaultPlugins(true);
    }

    protected List<SpincastPlugin> getDefaultPlugins(boolean addCodePlugin) {
        ArrayList<SpincastPlugin> plugins = new ArrayList<SpincastPlugin>();
        if (addCodePlugin && !this.disableCorePlugin && !this.pluginBound(SpincastCorePlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastCorePlugin());
        }
        if (!this.isDisableDefaultRoutingPlugin() && !this.pluginBound(SpincastRoutingPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastRoutingPlugin());
        }
        if (!this.isDisableDefaultJsonPlugin() && !this.pluginBound(SpincastJacksonJsonPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastJacksonJsonPlugin());
        }
        if (!this.isDisableDefaultXmlPlugin() && !this.pluginBound(SpincastJacksonXmlPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastJacksonXmlPlugin());
        }
        if (!this.isDisableDefaultRequestPlugin() && !this.pluginBound(SpincastRequestPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastRequestPlugin());
        }
        if (!this.isDisableDefaultResponsePlugin() && !this.pluginBound(SpincastResponsePlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastResponsePlugin());
        }
        if (!this.isDisableDefaultTemplatingPlugin() && !this.pluginBound(SpincastPebblePlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastPebblePlugin());
        }
        if (!this.isDisableDefaultTemplatingAddonPlugin() && !this.pluginBound(SpincastTemplatingAddonPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastTemplatingAddonPlugin());
        }
        if (!this.isDisableDefaultVariablesPlugin() && !this.pluginBound(SpincastVariablesPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastVariablesPlugin());
        }
        if (!this.isDisableDefaultLocaleResolverPlugin() && !this.pluginBound(SpincastLocaleResolverPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastLocaleResolverPlugin());
        }
        if (!this.isDisableDefaultTimeZoneResolverPlugin() && !this.pluginBound(SpincastTimeZoneResolverPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastTimeZoneResolverPlugin());
        }
        if (!this.isDisableDefaultHttpCachingPlugin() && !this.pluginBound(SpincastHttpCachingPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastHttpCachingPlugin());
        }
        if (!this.isDisableDefaultConfigPlugin() && !this.pluginBound(SpincastConfigPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastConfigPlugin());
        }
        if (!this.isDisableDefaultDictionaryPlugin() && !this.pluginBound(SpincastDictionaryPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastDictionaryPlugin());
        }
        if (!this.isDisableDefaultServerPlugin() && !this.pluginBound(SpincastUndertowPlugin.class)) {
            plugins.add((SpincastPlugin)this.getSpincastUndertowPlugin());
        }
        return plugins;
    }

    protected boolean pluginBound(Class<? extends SpincastPlugin> clazz) {
        List<SpincastPlugin> plugins = this.getPlugins();
        for (SpincastPlugin plugin : plugins) {
            if (!clazz.isAssignableFrom(plugin.getClass())) continue;
            return true;
        }
        Set<Module> modules = this.getModules();
        for (Module module : modules) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return true;
        }
        return false;
    }

    protected SpincastCorePlugin getSpincastCorePlugin() {
        return new SpincastCorePlugin();
    }

    protected SpincastConfigPlugin getSpincastConfigPlugin() {
        return new SpincastConfigPlugin();
    }

    protected SpincastRoutingPlugin getSpincastRoutingPlugin() {
        return new SpincastRoutingPlugin();
    }

    protected SpincastJacksonJsonPlugin getSpincastJacksonJsonPlugin() {
        return new SpincastJacksonJsonPlugin();
    }

    protected SpincastJacksonXmlPlugin getSpincastJacksonXmlPlugin() {
        return new SpincastJacksonXmlPlugin();
    }

    protected SpincastRequestPlugin getSpincastRequestPlugin() {
        return new SpincastRequestPlugin();
    }

    protected SpincastResponsePlugin getSpincastResponsePlugin() {
        return new SpincastResponsePlugin();
    }

    protected SpincastPebblePlugin getSpincastPebblePlugin() {
        return new SpincastPebblePlugin();
    }

    protected SpincastTemplatingAddonPlugin getSpincastTemplatingAddonPlugin() {
        return new SpincastTemplatingAddonPlugin();
    }

    protected SpincastVariablesPlugin getSpincastVariablesPlugin() {
        return new SpincastVariablesPlugin();
    }

    protected SpincastLocaleResolverPlugin getSpincastLocaleResolverPlugin() {
        return new SpincastLocaleResolverPlugin();
    }

    protected SpincastTimeZoneResolverPlugin getSpincastTimeZoneResolverPlugin() {
        return new SpincastTimeZoneResolverPlugin();
    }

    protected SpincastHttpCachingPlugin getSpincastHttpCachingPlugin() {
        return new SpincastHttpCachingPlugin();
    }

    protected SpincastDictionaryPlugin getSpincastDictionaryPlugin() {
        return new SpincastDictionaryPlugin();
    }

    protected SpincastUndertowPlugin getSpincastUndertowPlugin() {
        return new SpincastUndertowPlugin();
    }

    protected void setSpincastContextes(SpincastContextTypesInterested interested) {
        interested.setRequestContextImplementationClass(this.getRequestContextImplementationClass());
        interested.setWebsocketContextImplementationClass(this.getWebsocketContextImplementationClass());
    }

    public static Module getDefaultModule() {
        return SpincastBootstrapper.getCoreAndDefaultModuleInternal(DefaultRequestContextDefault.class, DefaultWebsocketContextDefault.class, true);
    }

    public static Module getDefaultModule(boolean includeCoreModule) {
        return SpincastBootstrapper.getCoreAndDefaultModuleInternal(DefaultRequestContextDefault.class, DefaultWebsocketContextDefault.class, includeCoreModule);
    }

    public static Module getDefaultModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        return SpincastBootstrapper.getCoreAndDefaultModuleInternal(requestContextImplementationClass, websocketContextImplementationClass, false);
    }

    public static Module getDefaultModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass, boolean includeCoreModule) {
        return SpincastBootstrapper.getCoreAndDefaultModuleInternal(requestContextImplementationClass, websocketContextImplementationClass, includeCoreModule);
    }

    protected static Module getCoreAndDefaultModuleInternal(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass, boolean addCodePlugin) {
        if (addCodePlugin) {
            if (defaultModuleWithCore != null) {
                return defaultModuleWithCore;
            }
        } else if (defaultModuleWithoutCore != null) {
            return defaultModuleWithoutCore;
        }
        SpincastBootstrapper bootstrapper = new SpincastBootstrapper();
        bootstrapper.requestContextImplementationClass(requestContextImplementationClass);
        bootstrapper.websocketContextImplementationClass(websocketContextImplementationClass);
        SpincastGuiceModuleBase module = new SpincastGuiceModuleBase(){

            protected void configure() {
            }
        };
        List<SpincastPlugin> defaultPlugins = bootstrapper.getDefaultPlugins(addCodePlugin);
        for (SpincastPlugin plugin : defaultPlugins) {
            bootstrapper.setSpincastContextes((SpincastContextTypesInterested)plugin);
            module = plugin.apply((Module)module);
        }
        if (addCodePlugin) {
            defaultModuleWithCore = module;
        } else {
            defaultModuleWithoutCore = module;
        }
        return module;
    }

    protected static String createModulesMapKey(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass, boolean addCore) {
        return (requestContextImplementationClass != null ? requestContextImplementationClass.getName() : "[null]") + "|" + (websocketContextImplementationClass != null ? websocketContextImplementationClass.getName() : "[null]") + "|" + String.valueOf(addCore);
    }
}

