/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dictionary;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.plugins.dictionary.SpincastDictionaryPluginModule;

public class SpincastDictionaryPlugin
extends SpincastPluginBase {
    public static final String PLUGIN_ID = SpincastDictionaryPlugin.class.getName();

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    @Override
    public Module apply(Module module) {
        Class<Dictionary> dictionaryImplClass = null;
        GuiceModuleUtils guiceModuleUtils = new GuiceModuleUtils(module);
        Set<Class<Dictionary>> classes = guiceModuleUtils.getBoundClassesExtending(Dictionary.class);
        if (classes.size() > 0) {
            Class<Dictionary> temp;
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + Dictionary.class.getName() + " has been found. Bindings found :\n";
                for (Class<Dictionary> clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            dictionaryImplClass = temp = classes.iterator().next();
        }
        Module pluginModule = this.getPluginModule(dictionaryImplClass);
        this.setContextTypes(pluginModule);
        module = Modules.override(module).with(pluginModule);
        return module;
    }

    protected Module getPluginModule(Class<? extends Dictionary> dictionaryImplClass) {
        return new SpincastDictionaryPluginModule(dictionaryImplClass);
    }
}

