/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.exchange;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.CacheHeadersRequestContextAddon;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.RequestContextBaseDeps;
import org.spincast.core.exchange.RequestRequestContextAddon;
import org.spincast.core.exchange.ResponseRequestContextAddon;
import org.spincast.core.exchange.VariablesRequestContextAddon;
import org.spincast.core.guice.SpincastGuiceScopes;
import org.spincast.core.guice.SpincastRequestScoped;
import org.spincast.core.json.JsonManager;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.core.routing.RoutingRequestContextAddon;
import org.spincast.core.templating.TemplatingRequestContextAddon;
import org.spincast.core.timezone.TimeZoneResolver;
import org.spincast.core.xml.XmlManager;

public abstract class RequestContextBase<R extends RequestContext<R>> {
    protected final Logger logger = LoggerFactory.getLogger(RequestContextBase.class);
    private final Object exchange;
    private final Provider<Injector> injectorProvider;
    private final LocaleResolver localeResolver;
    private final TimeZoneResolver timeZoneResolver;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final Provider<VariablesRequestContextAddon<R>> variablesRequestContextAddonProvider;
    private final Provider<RequestRequestContextAddon<R>> requestRequestContextAddonProvider;
    private final Provider<ResponseRequestContextAddon<R>> responseRequestContextAddonProvider;
    private final Provider<RoutingRequestContextAddon<R>> routingRequestContextAddonProvider;
    private final Provider<TemplatingRequestContextAddon<R>> templatingRequestContextAddonProvider;
    private final Provider<CacheHeadersRequestContextAddon<R>> cacheHeadersRequestContextAddonProvider;
    private VariablesRequestContextAddon<R> variablesRequestContextAddon;
    private ResponseRequestContextAddon<R> responseRequestContextAddon;
    private RoutingRequestContextAddon<R> routingRequestContextAddon;
    private RequestRequestContextAddon<R> requestRequestContextRequestAddon;
    private TemplatingRequestContextAddon<R> templatingRequestContextAddon;
    private CacheHeadersRequestContextAddon<R> cacheHeadersRequestContextAddon;
    private Map<Key<?>, Object> instanceFromGuiceCache;

    public RequestContextBase(Object exchange, RequestContextBaseDeps<R> requestContextBaseDeps) {
        this.exchange = exchange;
        this.injectorProvider = requestContextBaseDeps.getInjectorProvider();
        this.localeResolver = requestContextBaseDeps.getLocaleResolver();
        this.timeZoneResolver = requestContextBaseDeps.getTimeZoneResolver();
        this.jsonManager = requestContextBaseDeps.getJsonManager();
        this.xmlManager = requestContextBaseDeps.getXmlManager();
        this.variablesRequestContextAddonProvider = requestContextBaseDeps.getVariablesRequestContextAddonProvider();
        this.requestRequestContextAddonProvider = requestContextBaseDeps.getRequestRequestContextAddonProvider();
        this.responseRequestContextAddonProvider = requestContextBaseDeps.getResponseRequestContextAddonProvider();
        this.routingRequestContextAddonProvider = requestContextBaseDeps.getRoutingRequestContextAddonProvider();
        this.templatingRequestContextAddonProvider = requestContextBaseDeps.getTemplatingRequestContextAddonProvider();
        this.cacheHeadersRequestContextAddonProvider = requestContextBaseDeps.getCacheHeadersRequestContextAddonProvider();
    }

    public Injector guice() {
        return this.injectorProvider.get();
    }

    public Object exchange() {
        return this.exchange;
    }

    protected LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public Locale getLocaleToUse() {
        return this.getLocaleResolver().getLocaleToUse();
    }

    protected TimeZoneResolver getTimeZoneResolver() {
        return this.timeZoneResolver;
    }

    public TimeZone getTimeZoneToUse() {
        return this.getTimeZoneResolver().getTimeZoneToUse();
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected Provider<RequestRequestContextAddon<R>> getRequestRequestContextAddonProvider() {
        return this.requestRequestContextAddonProvider;
    }

    protected Provider<RoutingRequestContextAddon<R>> getRoutingRequestContextAddonProvider() {
        return this.routingRequestContextAddonProvider;
    }

    protected Provider<ResponseRequestContextAddon<R>> getResponseRequestContextAddonProvider() {
        return this.responseRequestContextAddonProvider;
    }

    protected Provider<VariablesRequestContextAddon<R>> getVariablesRequestContextAddonProvider() {
        return this.variablesRequestContextAddonProvider;
    }

    protected Provider<TemplatingRequestContextAddon<R>> getTemplatingRequestContextAddonProvider() {
        return this.templatingRequestContextAddonProvider;
    }

    protected Provider<CacheHeadersRequestContextAddon<R>> getCacheHeadersRequestContextAddonProvider() {
        return this.cacheHeadersRequestContextAddonProvider;
    }

    protected Map<Key<?>, Object> getInstanceFromGuiceCache() {
        if (this.instanceFromGuiceCache == null) {
            this.instanceFromGuiceCache = new HashMap();
        }
        return this.instanceFromGuiceCache;
    }

    public VariablesRequestContextAddon<R> variables() {
        if (this.variablesRequestContextAddon == null) {
            this.variablesRequestContextAddon = this.getVariablesRequestContextAddonProvider().get();
        }
        return this.variablesRequestContextAddon;
    }

    public RequestRequestContextAddon<R> request() {
        if (this.requestRequestContextRequestAddon == null) {
            this.requestRequestContextRequestAddon = this.getRequestRequestContextAddonProvider().get();
        }
        return this.requestRequestContextRequestAddon;
    }

    public ResponseRequestContextAddon<R> response() {
        if (this.responseRequestContextAddon == null) {
            this.responseRequestContextAddon = this.getResponseRequestContextAddonProvider().get();
        }
        return this.responseRequestContextAddon;
    }

    public RoutingRequestContextAddon<R> routing() {
        if (this.routingRequestContextAddon == null) {
            this.routingRequestContextAddon = this.getRoutingRequestContextAddonProvider().get();
        }
        return this.routingRequestContextAddon;
    }

    public TemplatingRequestContextAddon<R> templating() {
        if (this.templatingRequestContextAddon == null) {
            this.templatingRequestContextAddon = this.getTemplatingRequestContextAddonProvider().get();
        }
        return this.templatingRequestContextAddon;
    }

    public CacheHeadersRequestContextAddon<R> cacheHeaders() {
        if (this.cacheHeadersRequestContextAddon == null) {
            this.cacheHeadersRequestContextAddon = this.getCacheHeadersRequestContextAddonProvider().get();
        }
        return this.cacheHeadersRequestContextAddon;
    }

    public JsonManager json() {
        return this.getJsonManager();
    }

    public XmlManager xml() {
        return this.getXmlManager();
    }

    public <T> T get(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can't be NULL");
        return this.get(Key.get(clazz));
    }

    public <T> T get(Key<T> key) {
        Objects.requireNonNull(key, "key can't be NULL");
        Object obj = null;
        Map<Key<?>, Object> cache = this.getInstanceFromGuiceCache();
        if (!cache.containsKey(key)) {
            obj = this.guice().getInstance(key);
            Binding<T> binding = this.guice().getBinding(key);
            if (Scopes.isScoped(binding, SpincastGuiceScopes.REQUEST, SpincastRequestScoped.class) || Scopes.isScoped(binding, Scopes.SINGLETON, Singleton.class)) {
                cache.put(key, obj);
            }
        } else {
            Object asT;
            obj = asT = cache.get(key);
        }
        return (T)obj;
    }

    public String toString() {
        String msg = "[" + (Object)((Object)this.request().getHttpMethod()) + "] " + this.request().getFullUrl();
        if (this.routing().isForwarded()) {
            msg = msg + " ( forwarded from : " + this.request().getFullUrlOriginal() + " )";
        }
        return msg;
    }
}

