/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Exposed;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.throwingproviders.CheckedProvideUtils;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.ThrowingProviderBinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class CheckedProviderMethod<T>
implements CheckedProvider<T>,
HasDependencies {
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final Object instance;
    private final Method method;
    private final ImmutableSet<Dependency<?>> dependencies;
    private final List<Provider<?>> parameterProviders;
    private final boolean exposed;
    private final Class<? extends CheckedProvider> checkedProvider;
    private final List<TypeLiteral<?>> exceptionTypes;
    private final boolean scopeExceptions;

    CheckedProviderMethod(Key<T> key, Method method, Object instance, ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Class<? extends CheckedProvider> checkedProvider, List<TypeLiteral<?>> exceptionTypes, boolean scopeExceptions) {
        this.key = key;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.dependencies = dependencies;
        this.method = method;
        this.parameterProviders = parameterProviders;
        this.exposed = method.isAnnotationPresent(Exposed.class);
        this.checkedProvider = checkedProvider;
        this.exceptionTypes = exceptionTypes;
        this.scopeExceptions = scopeExceptions;
        method.setAccessible(true);
    }

    void configure(Binder binder) {
        binder = binder.withSource(this.method);
        ThrowingProviderBinder.SecondaryBinder<CheckedProvider, T> sbinder = ThrowingProviderBinder.create(binder).bind(this.checkedProvider, this.key.getTypeLiteral());
        if (this.key.getAnnotation() != null) {
            sbinder = sbinder.annotatedWith(this.key.getAnnotation());
        } else if (this.key.getAnnotationType() != null) {
            sbinder = sbinder.annotatedWith(this.key.getAnnotationType());
        }
        sbinder.scopeExceptions(this.scopeExceptions);
        ScopedBindingBuilder sbbuilder = sbinder.toProviderMethod(this);
        if (this.scopeAnnotation != null) {
            sbbuilder.in(this.scopeAnnotation);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(sbinder.getKey());
        }
        CheckedProvideUtils.validateExceptions(binder, this.exceptionTypes, sbinder.getExceptionTypes(), this.checkedProvider);
    }

    @Override
    public T get() throws Exception {
        Object[] parameters = new Object[this.parameterProviders.size()];
        Arrays.setAll(parameters, i -> this.parameterProviders.get(i).get());
        try {
            Object result = this.method.invoke(this.instance, parameters);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException(t);
        }
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "@CheckedProvides " + StackTraceElements.forMember(this.method);
    }
}

