/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.tokenParser;

import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.PrintNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.node.expression.FilterExpression;
import com.mitchellbosecke.pebble.node.expression.FilterInvocationExpression;
import com.mitchellbosecke.pebble.node.expression.RenderableNodeExpression;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;

public class FilterTokenParser
implements TokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        ArrayList<FilterInvocationExpression> filterInvocationExpressions = new ArrayList<FilterInvocationExpression>();
        filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        while (stream.current().test(Token.Type.OPERATOR, "|")) {
            stream.next();
            filterInvocationExpressions.add(parser.getExpressionParser().parseFilterInvocationExpression());
        }
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(tkn -> tkn.test(Token.Type.NAME, "endfilter"));
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        Expression<Object> lastExpression = new RenderableNodeExpression(body, stream.current().getLineNumber());
        for (Expression expression : filterInvocationExpressions) {
            FilterExpression filterExpression = new FilterExpression();
            filterExpression.setRight(expression);
            filterExpression.setLeft(lastExpression);
            lastExpression = filterExpression;
        }
        return new PrintNode(lastExpression, lineNumber);
    }

    @Override
    public String getTag() {
        return "filter";
    }
}

