/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.ErrorId;
import com.google.inject.internal.Errors;
import com.google.inject.spi.Message;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.ThrowingInject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

class CheckedProvideUtils {
    private static final String CONSTRUCTOR_RULES = "Classes must have either one (and only one) constructor annotated with @ThrowingInject.";

    private CheckedProvideUtils() {
    }

    static <T> Constructor<? extends T> findThrowingConstructor(TypeLiteral<? extends T> typeLiteral, Binder binder) {
        Class<T> rawType = typeLiteral.getRawType();
        Errors errors = new Errors(rawType);
        Constructor<?> cxtor = null;
        for (Constructor<?> constructor : rawType.getDeclaredConstructors()) {
            Annotation misplacedBindingAnnotation;
            if (!constructor.isAnnotationPresent(ThrowingInject.class)) continue;
            if (cxtor != null) {
                errors.addMessage(ErrorId.MISSING_CONSTRUCTOR, "%s has more than one constructor annotated with @ThrowingInject. Classes must have either one (and only one) constructor annotated with @ThrowingInject.", rawType);
            }
            if ((misplacedBindingAnnotation = Annotations.findBindingAnnotation(errors, cxtor = constructor, cxtor.getAnnotations())) == null) continue;
            errors.misplacedBindingAnnotation(cxtor, misplacedBindingAnnotation);
        }
        if (cxtor == null) {
            errors.addMessage(ErrorId.MISSING_CONSTRUCTOR, "Could not find a suitable constructor in %s. Classes must have either one (and only one) constructor annotated with @ThrowingInject.", rawType);
        }
        for (Message msg : errors.getMessages()) {
            binder.addError(msg);
        }
        return cxtor;
    }

    static void validateExceptions(Binder binder, Iterable<TypeLiteral<?>> actualExceptionTypes, Iterable<Class<? extends Throwable>> expectedExceptionTypes, Class<? extends CheckedProvider> checkedProvider) {
        for (TypeLiteral<?> exType : actualExceptionTypes) {
            Class<?> exActual = exType.getRawType();
            if (RuntimeException.class.isAssignableFrom(exActual) || Error.class.isAssignableFrom(exActual)) continue;
            boolean notAssignable = true;
            for (Class<? extends Throwable> exExpected : expectedExceptionTypes) {
                if (!exExpected.isAssignableFrom(exActual)) continue;
                notAssignable = false;
                break;
            }
            if (!notAssignable) continue;
            binder.addError("%s is not compatible with the exceptions (%s) declared in the CheckedProvider interface (%s)", exActual, expectedExceptionTypes, checkedProvider);
        }
    }
}

