/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension;

import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.ExtensionCustomizer;
import com.mitchellbosecke.pebble.extension.ExtensionRegistry;
import com.mitchellbosecke.pebble.extension.core.AttributeResolverExtension;
import com.mitchellbosecke.pebble.extension.core.CoreExtension;
import com.mitchellbosecke.pebble.extension.escaper.EscaperExtension;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import com.mitchellbosecke.pebble.extension.i18n.I18nExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class ExtensionRegistryFactory {
    private final List<Extension> userProvidedExtensions = new ArrayList<Extension>();
    private final EscaperExtension escaperExtension = new EscaperExtension();
    private boolean allowOverrideCoreOperators = false;
    private Function<Extension, Extension> customizer = Function.identity();

    public ExtensionRegistry buildExtensionRegistry() {
        ExtensionRegistry extensionRegistry = new ExtensionRegistry();
        Stream.of(new CoreExtension(), this.escaperExtension, new I18nExtension()).map(this.customizer::apply).forEach(extensionRegistry::addExtension);
        for (Extension userProvidedExtension : this.userProvidedExtensions) {
            if (this.allowOverrideCoreOperators) {
                extensionRegistry.addOperatorOverridingExtension(userProvidedExtension);
                continue;
            }
            extensionRegistry.addExtension(userProvidedExtension);
        }
        extensionRegistry.addExtension(this.customizer.apply(new AttributeResolverExtension()));
        return extensionRegistry;
    }

    public void autoEscaping(boolean autoEscaping) {
        this.escaperExtension.setAutoEscaping(autoEscaping);
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.escaperExtension.addEscapingStrategy(name, strategy);
    }

    public void extension(Extension ... extensions) {
        Collections.addAll(this.userProvidedExtensions, extensions);
    }

    public void allowOverrideCoreOperators(boolean allowOverrideCoreOperators) {
        this.allowOverrideCoreOperators = allowOverrideCoreOperators;
    }

    public void defaultEscapingStrategy(String strategy) {
        this.escaperExtension.setDefaultStrategy(strategy);
    }

    public void registerExtensionCustomizer(Function<Extension, ExtensionCustomizer> customizer) {
        this.customizer = customizer::apply;
    }
}

