/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.shaded.org.apache.commons.digester.plugins.strategies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.spincast.shaded.org.apache.commons.digester.Digester;
import org.spincast.shaded.org.apache.commons.digester.plugins.PluginException;
import org.spincast.shaded.org.apache.commons.digester.plugins.RuleLoader;
import org.spincast.shaded.org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.spincast.shaded.org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public class LoaderFromStream
extends RuleLoader {
    private byte[] input;

    public LoaderFromStream(InputStream s2) throws Exception {
        this.load(s2);
    }

    private void load(InputStream s2) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        while ((i = s2.read(buf)) != -1) {
            baos.write(buf, 0, i);
        }
        this.input = baos.toByteArray();
    }

    public void addRules(Digester d, String path) throws PluginException {
        Log log = d.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("LoaderFromStream: loading rules for plugin at path [" + path + "]");
        }
        InputSource source = new InputSource(new ByteArrayInputStream(this.input));
        FromXmlRuleSet ruleSet = new FromXmlRuleSet(source);
        ruleSet.addRuleInstances(d, path);
    }
}

