/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import java.io.File;

public class SpincastFileSystemFileResourceManager
extends FileResourceManager {
    private final File file;

    public SpincastFileSystemFileResourceManager(File file) {
        this(file, 1024L);
    }

    public SpincastFileSystemFileResourceManager(File file, long transferMinSize) {
        super(transferMinSize, true, false, new String[0]);
        if (file == null) {
            throw new RuntimeException("The file to serve can't be null...");
        }
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeException("The file \"" + file.getAbsolutePath() + "\" to serve exists but is a directory!");
        }
        this.file = file;
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    public Resource getResource(String path) {
        if (this.getFile() == null || !this.getFile().exists()) {
            return null;
        }
        return new FileResource(this.getFile(), this, this.getFile().getAbsolutePath());
    }
}

