/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpcaching;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.CacheHeadersRequestContextAddon;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.ETag;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.routing.HttpMethod;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;

public class SpincastCacheHeadersRequestContextAddon<R extends RequestContext<?>>
implements CacheHeadersRequestContextAddon<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastCacheHeadersRequestContextAddon.class);
    private final R requestContext;
    private final ETagFactory etagFactory;
    private ETag eTag = null;
    private boolean eTagWeakComparison = false;
    private Date lastModificationDate;

    @Inject
    public SpincastCacheHeadersRequestContextAddon(R requestContext, ETagFactory etagFactory) {
        this.requestContext = requestContext;
        this.etagFactory = etagFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected ETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    protected ETag getETag() {
        return this.eTag;
    }

    protected void setETag(ETag eTag) {
        this.eTag = eTag;
    }

    protected boolean isETagWeakComparison() {
        return this.eTagWeakComparison;
    }

    protected void setETagWeakComparison(boolean eTagWeakComparison) {
        this.eTagWeakComparison = eTagWeakComparison;
    }

    protected Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    protected void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    @Override
    public CacheHeadersRequestContextAddon<R> eTag(String currentTag) {
        return this.eTag(currentTag, false, false);
    }

    @Override
    public CacheHeadersRequestContextAddon<R> eTag(String currentTag, boolean currentTagIsWeak) {
        return this.eTag(currentTag, currentTagIsWeak, false);
    }

    @Override
    public CacheHeadersRequestContextAddon<R> eTag(String currentTag, boolean currentTagIsWeak, boolean weakComparison) {
        if (currentTag == null) {
            this.setETag(null);
            this.getRequestContext().response().removeHeader("ETag");
        } else {
            ETag eTag = this.getEtagFactory().create(currentTag, currentTagIsWeak, false);
            this.setETag(eTag);
            this.getRequestContext().response().setHeader("ETag", eTag.getHeaderValue());
        }
        HttpMethod httpMethod = this.getRequestContext().request().getHttpMethod();
        if (weakComparison && httpMethod != HttpMethod.GET && httpMethod != HttpMethod.HEAD) {
            weakComparison = false;
            this.logger.warn("ETag weak comparison is only allowed for GET and HEAD methods. Current HTTP method is " + (Object)((Object)httpMethod) + ". " + "See https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.26");
        }
        this.setETagWeakComparison(weakComparison);
        return this;
    }

    @Override
    public CacheHeadersRequestContextAddon<R> lastModified(Date lastModificationDate) {
        this.setLastModificationDate(lastModificationDate);
        if (lastModificationDate == null) {
            this.getRequestContext().response().removeHeader("Last-Modified");
        } else {
            this.getRequestContext().response().setHeader("Last-Modified", this.formatDateForHttpHeader(lastModificationDate));
        }
        return this;
    }

    protected boolean isEtagsFromIfMatchHeaderContainsAWildcard() {
        for (ETag eTag : this.getRequestContext().request().getEtagsFromIfMatchHeader()) {
            if (!eTag.isWildcard()) continue;
            return true;
        }
        return false;
    }

    public List<ETag> getEtagsFromIfMatchHeader() {
        return this.getRequestContext().request().getEtagsFromIfMatchHeader();
    }

    public List<ETag> getEtagsFromIfNoneMatchHeader() {
        return this.getRequestContext().request().getEtagsFromIfNoneMatchHeader();
    }

    protected boolean isEtagsFromIfNoneMatchHeaderContainsAWildcard() {
        for (ETag eTag : this.getEtagsFromIfNoneMatchHeader()) {
            if (!eTag.isWildcard()) continue;
            return true;
        }
        return false;
    }

    protected boolean isIfMatchEtagMatches() {
        List<ETag> eTags = this.getEtagsFromIfMatchHeader();
        if (eTags == null || eTags.size() == 0) {
            return false;
        }
        for (ETag eTag : eTags) {
            if (!this.isEtagMatches(eTag, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean isIfNoneMatchEtagMatches() {
        List<ETag> eTags = this.getEtagsFromIfNoneMatchHeader();
        if (eTags == null || eTags.size() == 0) {
            return false;
        }
        for (ETag eTag : eTags) {
            if (!this.isEtagMatches(eTag, this.isETagWeakComparison())) continue;
            return true;
        }
        return false;
    }

    protected boolean isEtagMatches(ETag requestETag, boolean weakComparison) {
        ETag newETag = this.getETag();
        if (requestETag != null && requestETag.isWildcard()) {
            return true;
        }
        if (requestETag == null || newETag == null) {
            return false;
        }
        return newETag.matches(requestETag, weakComparison);
    }

    protected Date getDateFromIfModifiedSinceHeader() {
        return this.getRequestContext().request().getDateFromIfModifiedSinceHeader();
    }

    protected Date getDateFromIfUnmodifiedSinceHeader() {
        return this.getRequestContext().request().getDateFromIfUnmodifiedSinceHeader();
    }

    protected String formatDateForHttpHeader(Date date) {
        Objects.requireNonNull(date, "The date can't be NULL");
        return org.spincast.shaded.org.apache.http.client.utils.DateUtils.formatDate(date);
    }

    @Override
    public CacheHeadersRequestContextAddon<R> cache(int seconds) {
        return this.cache(seconds, false, null);
    }

    @Override
    public CacheHeadersRequestContextAddon<R> cache(int seconds, boolean isPrivate) {
        return this.cache(seconds, isPrivate, null);
    }

    @Override
    public CacheHeadersRequestContextAddon<R> cache(int seconds, boolean isPrivate, Integer cdnSeconds) {
        if (seconds <= 0) {
            return this.noCache();
        }
        this.getRequestContext().response().removeHeader("Pragma");
        StringBuilder builder = new StringBuilder();
        if (isPrivate) {
            builder.append("private");
        } else {
            builder.append("public");
        }
        builder.append(", max-age=").append(seconds);
        if (cdnSeconds != null) {
            if (cdnSeconds < 0) {
                cdnSeconds = 0;
            }
            builder.append(", s-maxage=").append(cdnSeconds);
        }
        this.getRequestContext().response().setHeader("Cache-Control", builder.toString());
        Date date = DateUtils.addSeconds(new Date(), seconds);
        String dateStr = org.spincast.shaded.org.apache.http.client.utils.DateUtils.formatDate(date);
        this.getRequestContext().response().setHeader("Expires", dateStr);
        return this;
    }

    @Override
    public SpincastCacheHeadersRequestContextAddon<R> noCache() {
        this.getRequestContext().response().removeHeader("ETag");
        this.getRequestContext().response().removeHeader("Last-Modified");
        this.getRequestContext().response().setHeader("Pragma", "no-cache");
        this.getRequestContext().response().setHeader("Expires", "Tue, 03 Jul 2001 06:00:00 GMT");
        this.getRequestContext().response().setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate, proxy-revalidate");
        return this;
    }

    @Override
    public boolean validate(boolean resourceCurrentlyExists) {
        if (!resourceCurrentlyExists) {
            if (this.isEtagsFromIfMatchHeaderContainsAWildcard() || this.getEtagsFromIfMatchHeader().size() > 0 || this.getDateFromIfUnmodifiedSinceHeader() != null) {
                this.getRequestContext().response().setStatusCode(412);
                return true;
            }
            return false;
        }
        boolean eTagHeadersAllowNotModifiedResponse = true;
        boolean eTagHeadersWantToSendNotModifiedResponse = false;
        if (this.getETag() != null) {
            if (this.getEtagsFromIfMatchHeader().size() > 0) {
                if (!this.isIfMatchEtagMatches()) {
                    this.getRequestContext().response().setStatusCode(412);
                    return true;
                }
                eTagHeadersAllowNotModifiedResponse = false;
            }
            if (this.getEtagsFromIfNoneMatchHeader().size() > 0) {
                if (this.isEtagsFromIfNoneMatchHeaderContainsAWildcard()) {
                    this.getRequestContext().response().setStatusCode(412);
                    return true;
                }
                if (this.isIfNoneMatchEtagMatches()) {
                    eTagHeadersWantToSendNotModifiedResponse = true;
                } else {
                    eTagHeadersAllowNotModifiedResponse = false;
                }
            }
        }
        boolean lastModifiedDateHeadersAllowNotModifiedResponse = true;
        boolean lastModifiedDateHeadersWantToSendNotModifiedResponse = false;
        if (this.getLastModificationDate() != null) {
            Date ifModifiedSinceDate;
            Date ifUnmodifiedSinceHeader = this.getDateFromIfUnmodifiedSinceHeader();
            if (ifUnmodifiedSinceHeader != null) {
                if (this.getLastModificationDate().getTime() - ifUnmodifiedSinceHeader.getTime() > 0L) {
                    this.getRequestContext().response().setStatusCode(412);
                    return true;
                }
                lastModifiedDateHeadersAllowNotModifiedResponse = false;
            }
            if ((ifModifiedSinceDate = this.getDateFromIfModifiedSinceHeader()) != null) {
                if (this.getLastModificationDate().getTime() - ifModifiedSinceDate.getTime() > 0L) {
                    lastModifiedDateHeadersAllowNotModifiedResponse = false;
                } else {
                    lastModifiedDateHeadersWantToSendNotModifiedResponse = true;
                }
            }
        }
        if (eTagHeadersAllowNotModifiedResponse && lastModifiedDateHeadersWantToSendNotModifiedResponse || lastModifiedDateHeadersAllowNotModifiedResponse && eTagHeadersWantToSendNotModifiedResponse) {
            this.getRequestContext().response().setStatusCode(304);
            return true;
        }
        return false;
    }
}

