/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="UT")
public interface WebSocketLogger
extends BasicLogger {
    public static final WebSocketLogger ROOT_LOGGER = Logger.getMessageLogger(WebSocketLogger.class, WebSocketLogger.class.getPackage().getName());
    public static final WebSocketLogger REQUEST_LOGGER = Logger.getMessageLogger(WebSocketLogger.class, WebSocketLogger.class.getPackage().getName() + ".request");
    public static final WebSocketLogger EXTENSION_LOGGER = Logger.getMessageLogger(WebSocketLogger.class, WebSocketLogger.class.getPackage().getName() + ".extension");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25001, value="WebSocket handshake failed")
    public void webSocketHandshakeFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25002, value="StreamSinkFrameChannel %s was closed before writing was finished, web socket connection is now unusable")
    public void closedBeforeFinishedWriting(StreamSinkFrameChannel var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=25003, value="Decoding WebSocket Frame with opCode %s")
    public void decodingFrameWithOpCode(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25004, value="Failure during execution of SendCallback")
    public void sendCallbackExecutionError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25005, value="Failed to set idle timeout")
    public void setIdleTimeFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25006, value="Failed to get idle timeout")
    public void getIdleTimeFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25007, value="Unhandled exception for annotated endpoint %s")
    public void unhandledErrorInAnnotatedEndpoint(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=25008, value="Incorrect parameter %s for extension")
    public void incorrectExtensionParameter(WebSocketExtension.Parameter var1);
}

