/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.templatingaddon;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.templating.TemplatingRequestContextAddon;

public class SpincastTemplatingRequestContextAddon<R extends RequestContext<?>>
implements TemplatingRequestContextAddon<R> {
    private final R requestContext;
    private final TemplatingEngine templatingEngine;
    private final LocaleResolver localeResolver;
    private final JsonManager jsonManager;
    private Map<String, Object> templatingGlobalVariables;

    @Inject
    public SpincastTemplatingRequestContextAddon(R requestContext, TemplatingEngine templatingEngine, LocaleResolver localeResolver, JsonManager jsonManager) {
        this.requestContext = requestContext;
        this.templatingEngine = templatingEngine;
        this.localeResolver = localeResolver;
        this.jsonManager = jsonManager;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    protected LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected Locale getLocaleToUse() {
        return this.getLocaleResolver().getLocaleToUse();
    }

    @Override
    public Map<String, Object> getTemplatingGlobalVariables() {
        if (this.templatingGlobalVariables == null) {
            this.templatingGlobalVariables = new HashMap<String, Object>();
        }
        return this.templatingGlobalVariables;
    }

    @Override
    public String evaluate(String content, Map<String, Object> params) {
        return this.evaluate(content, params, this.getLocaleToUse());
    }

    @Override
    public String evaluate(String content, Map<String, Object> params, Locale locale) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        JsonObject model = this.getJsonManager().fromMap(params);
        return this.evaluate(content, model, locale);
    }

    @Override
    public String evaluate(String content, JsonObject model) {
        return this.evaluate(content, model, this.getLocaleToUse());
    }

    @Override
    public String evaluate(String content, JsonObject model, Locale locale) {
        if (model == null) {
            model = this.getJsonManager().create();
        }
        model.merge(this.getTemplatingGlobalVariables());
        return this.getTemplatingEngine().evaluate(content, model, locale);
    }

    @Override
    public String fromTemplate(String templatePath, JsonObject model) {
        return this.fromTemplate(templatePath, true, model, this.getLocaleToUse());
    }

    @Override
    public String fromTemplate(String templatePath, JsonObject model, Locale locale) {
        return this.fromTemplate(templatePath, true, model, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, JsonObject model) {
        return this.fromTemplate(templatePath, isClasspathPath, model, this.getLocaleToUse());
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params) {
        return this.fromTemplate(templatePath, true, params, this.getLocaleToUse());
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params) {
        return this.fromTemplate(templatePath, isClasspathPath, params, this.getLocaleToUse());
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params, Locale locale) {
        return this.fromTemplate(templatePath, true, params, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, JsonObject model, Locale locale) {
        return this.fromTemplate(templatePath, isClasspathPath, model != null ? model.convertToPlainMap() : null, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params, Locale locale) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.putAll(this.getTemplatingGlobalVariables());
        return this.getTemplatingEngine().fromTemplate(templatePath, isClasspathPath, params, locale);
    }

    @Override
    public void addTemplatingGlobalVariable(String key, Object value) {
        value = this.convertTemplatingGlobalVariableValue(value);
        this.getTemplatingGlobalVariables().put(key, value);
    }

    protected Object convertTemplatingGlobalVariableValue(Object value) {
        if (value != null) {
            if (value instanceof JsonObject) {
                value = ((JsonObject)value).convertToPlainMap();
            } else if (value instanceof JsonArray) {
                value = ((JsonArray)value).convertToPlainList();
            }
        }
        return value;
    }

    @Override
    public void addTemplatingGlobalVariables(Map<String, Object> variables) {
        this.getTemplatingGlobalVariables().putAll(variables);
    }

    @Override
    public Object getTemplatingGlobalVariable(String key) {
        return this.getTemplatingGlobalVariables().get(key);
    }

    @Override
    public void deleteAllTemplatingGlobalVariables() {
        this.getTemplatingGlobalVariables().clear();
    }

    @Override
    public void deleteTemplatingGlobalVariable(String key) {
        this.getTemplatingGlobalVariables().remove(key);
    }

    @Override
    public String createPlaceholder(String variable) {
        return this.getTemplatingEngine().createPlaceholder(variable);
    }

    @Override
    public Map<String, Object> getSpincastReservedMap() {
        HashMap<String, Object> map = (HashMap<String, Object>)this.getTemplatingGlobalVariable("spincast");
        if (map == null) {
            map = new HashMap<String, Object>();
            this.addTemplatingGlobalVariable("spincast", map);
        } else if (!(map instanceof Map)) {
            throw new RuntimeException("The 'spincast' root variable is reserved for Spincast and must be an instance of Map<String, Object>.");
        }
        return map;
    }
}

