/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.pebble;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.core.DefaultFilter;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.ScopeChain;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonObject;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.pebble.SpincastMainPebbleExtension;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngine;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngineConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.text.StringEscapeUtils;

public class SpincastMainPebbleExtensionDefault
extends AbstractExtension
implements SpincastMainPebbleExtension {
    public static final String FILTER_NAME_CHECKED = "checked";
    public static final String FILTER_NAME_SELECTED = "selected";
    public static final String FILTER_NAME_VALIDATION_MESSAGES = "validationMessages";
    public static final String FILTER_NAME_VALIDATION_GROUP_MESSAGES = "validationGroupMessages";
    public static final String FILTER_NAME_VALIDATION_CLASS = "validationClass";
    public static final String FILTER_NAME_VALIDATION_FRESH = "validationFresh";
    public static final String FILTER_NAME_VALIDATION_SUBMITTED = "validationSubmitted";
    public static final String FILTER_NAME_VALIDATION_IS_VALID = "validationIsValid";
    public static final String FILTER_NAME_VALIDATION_HAS_SUCCESSES = "validationHasSuccesses";
    public static final String FILTER_NAME_VALIDATION_HAS_WARNINGS = "validationHasWarnings";
    public static final String FILTER_NAME_VALIDATION_HAS_ERRORS = "validationHasErrors";
    public static final String FILTER_NAME_VALIDATION_GET = "get";
    public static final String FILTER_NAME_ESCAPE_BUT_REPLACE_NEWLINE_BY_BR = "newline2br";
    public static final String FILTER_NAME_BOOLEAN = "boolean";
    public static final String FUNCTION_NAME_VALIDATION_GET = "get";
    public static final String FUNCTION_NAME_VALIDATION_JS_ONE_LINE = "jsOneLine";
    public static final String FUNCTION_NAME_MESSAGE = "msg";
    public static final String FUNCTION_NAME_QUERYSTRING_APPEND = "querystring";
    private final Provider<TemplatingEngine> templatingEngineProvider;
    private final SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig;
    private TemplatingEngine templatingEngine;
    private final ObjectConverter objectConverter;
    private final SpincastUtils spincastUtils;
    private final Dictionary dictionary;
    private final Provider<RequestContext<?>> requestContextProvider;

    @Inject
    public SpincastMainPebbleExtensionDefault(Provider<TemplatingEngine> templatingEngineProvider, SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig, ObjectConverter objectConverter, SpincastUtils spincastUtils, Dictionary dictionary, Provider<RequestContext<?>> requestContextProvider) {
        this.templatingEngineProvider = templatingEngineProvider;
        this.spincastPebbleTemplatingEngineConfig = spincastPebbleTemplatingEngineConfig;
        this.objectConverter = objectConverter;
        this.spincastUtils = spincastUtils;
        this.dictionary = dictionary;
        this.requestContextProvider = requestContextProvider;
    }

    public TemplatingEngine getTemplatingEngine() {
        if (this.templatingEngine == null) {
            this.templatingEngine = this.templatingEngineProvider.get();
        }
        return this.templatingEngine;
    }

    protected ObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    protected SpincastPebbleTemplatingEngineConfig getSpincastPebbleTemplatingEngineConfig() {
        return this.spincastPebbleTemplatingEngineConfig;
    }

    @Override
    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        Filter filter = this.getCheckedFilter();
        if (filter != null) {
            filters.put(this.getCheckedFilterName(), filter);
        }
        if ((filter = this.getSelectedFilter()) != null) {
            filters.put(this.getSelectedFilterName(), filter);
        }
        if ((filter = this.getValidationMessagesFilter(this.getValidationMessagesTemplatePath())) != null) {
            filters.put(this.getValidationMessagesFilterName(), filter);
        }
        if ((filter = this.getValidationMessagesFilter(this.getValidationGroupMessagesTemplatePath())) != null) {
            filters.put(this.getValidationGroupMessagesFilterName(), filter);
        }
        if ((filter = this.getValidationClassFilter()) != null) {
            filters.put(this.getValidationClassFilterName(), filter);
        }
        if ((filter = this.getValidationFreshFilter()) != null) {
            filters.put(this.getValidationFreshFilterName(), filter);
        }
        if ((filter = this.getValidationSubmittedFilter()) != null) {
            filters.put(this.getValidationSubmittedFilterName(), filter);
        }
        if ((filter = this.getValidationIsValidFilter()) != null) {
            filters.put(this.getValidationIsValidFilterName(), filter);
        }
        if ((filter = this.getValidationHasSuccessesFilter()) != null) {
            filters.put(this.getValidationHasSuccessesFilterName(), filter);
        }
        if ((filter = this.getValidationHasWarningsFilter()) != null) {
            filters.put(this.getValidationHasWarningsFilterName(), filter);
        }
        if ((filter = this.getValidationHasErrorsFilter()) != null) {
            filters.put(this.getValidationHasErrorsFilterName(), filter);
        }
        if ((filter = this.getGetFilter()) != null) {
            filters.put(this.getGetFilterName(), filter);
        }
        if ((filter = this.getNewlineToBrFilter()) != null) {
            filters.put(this.getNewlineToBrFilterName(), filter);
        }
        if ((filter = this.getBooleanFilter()) != null) {
            filters.put(this.getBooleanFilterName(), filter);
        }
        return filters;
    }

    @Override
    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put(this.getGetFunctionName(), this.getGetFunction());
        functions.put(this.getJsOneLinerOutputFunctionName(), this.getJsOneLinerOutputFunction());
        functions.put(this.getMessageFunctionName(), this.getMessageFunction());
        functions.put(this.getQuerystringAppendFunctionName(), this.getQuerystringAppendFunction());
        return functions;
    }

    protected EvaluationContext getEvaluationContext(Map<String, Object> args) {
        return (EvaluationContext)args.get("_context");
    }

    protected PebbleTemplate getPebbleTemplate(Map<String, Object> args) {
        return (PebbleTemplate)args.get("_self");
    }

    protected ScopeChain getScopeChain(Map<String, Object> args) {
        return this.getEvaluationContext(args).getScopeChain();
    }

    protected Object getModelElement(Map<String, Object> args, String property) {
        return this.getScopeChain(args).get(property);
    }

    protected String getPropertyAsString(Map<String, Object> args, String property) {
        return (String)this.getModelElement(args, property);
    }

    protected Map<String, Object> getPropertyAsMap(Map<String, Object> args, String property) {
        return (Map)this.getModelElement(args, property);
    }

    protected Set<Object> convertToSet(Object obj) {
        HashSet<Object> values = new HashSet<Object>();
        if (obj instanceof Collection) {
            values.addAll((Collection)obj);
        } else if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            for (int i = 0; i < arr.length; ++i) {
                values.add(arr[i]);
            }
        } else {
            values.add(obj);
        }
        return values;
    }

    protected String getValidationClassError() {
        return "has-error";
    }

    protected Object getValidationClassWarning() {
        return "has-warning";
    }

    protected Object getValidationClassSuccess() {
        return "has-success";
    }

    protected Object getValidationClassNoMessage() {
        return "has-no-message";
    }

    protected String getValidationMessagesTemplatePath() {
        return this.getSpincastPebbleTemplatingEngineConfig().getValidationMessagesTemplatePath();
    }

    protected String getValidationGroupMessagesTemplatePath() {
        return this.getSpincastPebbleTemplatingEngineConfig().getValidationGroupMessagesTemplatePath();
    }

    protected String getCheckedFilterName() {
        return FILTER_NAME_CHECKED;
    }

    protected Filter getCheckedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("acceptableValues");
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                Set<Object> values = SpincastMainPebbleExtensionDefault.this.convertToSet(value);
                Set<Object> acceptableValues = SpincastMainPebbleExtensionDefault.this.convertToSet(args.get("acceptableValues"));
                if (SpincastMainPebbleExtensionDefault.this.getObjectConverter().isAtLeastOneEquivalentElementInCommon(values, acceptableValues)) {
                    return SpincastMainPebbleExtensionDefault.FILTER_NAME_CHECKED;
                }
                return "";
            }
        };
        return filter;
    }

    protected String getSelectedFilterName() {
        return FILTER_NAME_SELECTED;
    }

    protected Filter getSelectedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("acceptableValues");
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                Set<Object> values = SpincastMainPebbleExtensionDefault.this.convertToSet(value);
                Set<Object> acceptableValues = SpincastMainPebbleExtensionDefault.this.convertToSet(args.get("acceptableValues"));
                if (SpincastMainPebbleExtensionDefault.this.getObjectConverter().isAtLeastOneEquivalentElementInCommon(values, acceptableValues)) {
                    return SpincastMainPebbleExtensionDefault.FILTER_NAME_SELECTED;
                }
                return "";
            }
        };
        return filter;
    }

    protected String getValidationMessagesFilterName() {
        return FILTER_NAME_VALIDATION_MESSAGES;
    }

    protected String getValidationGroupMessagesFilterName() {
        return FILTER_NAME_VALIDATION_GROUP_MESSAGES;
    }

    protected Filter getValidationMessagesFilter(final String templatePath) {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return "";
                }
                Map validationResultMap = (Map)value;
                String html = SpincastMainPebbleExtensionDefault.this.getTemplatingEngine().fromTemplate(templatePath, SpincastStatics.params("validation", validationResultMap));
                return new SafeString(html);
            }
        };
        return filter;
    }

    protected String getValidationClassFilterName() {
        return FILTER_NAME_VALIDATION_CLASS;
    }

    protected Filter getValidationClassFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return SpincastMainPebbleExtensionDefault.this.getValidationClassNoMessage();
                }
                Map validationResultMap = (Map)value;
                Boolean hasErrors = (Boolean)validationResultMap.get("hasErrors");
                if (hasErrors == null || hasErrors.booleanValue()) {
                    return SpincastMainPebbleExtensionDefault.this.getValidationClassError();
                }
                Boolean hasWarnings = (Boolean)validationResultMap.get("hasWarnings");
                if (hasWarnings != null && hasWarnings.booleanValue()) {
                    return SpincastMainPebbleExtensionDefault.this.getValidationClassWarning();
                }
                Boolean hasSuccesses = (Boolean)validationResultMap.get("hasSuccesses");
                if (hasSuccesses != null && hasSuccesses.booleanValue()) {
                    return SpincastMainPebbleExtensionDefault.this.getValidationClassSuccess();
                }
                return SpincastMainPebbleExtensionDefault.this.getValidationClassNoMessage();
            }
        };
        return filter;
    }

    protected String getValidationFreshFilterName() {
        return FILTER_NAME_VALIDATION_FRESH;
    }

    protected Filter getValidationFreshFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null) {
                    return true;
                }
                return false;
            }
        };
        return filter;
    }

    protected String getValidationSubmittedFilterName() {
        return FILTER_NAME_VALIDATION_SUBMITTED;
    }

    protected Filter getValidationSubmittedFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null) {
                    return false;
                }
                return true;
            }
        };
        return filter;
    }

    protected String getValidationIsValidFilterName() {
        return FILTER_NAME_VALIDATION_IS_VALID;
    }

    protected Filter getValidationIsValidFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return true;
                }
                Map validationResultMap = (Map)value;
                Object isValid = validationResultMap.get("isValid");
                return isValid != null && isValid instanceof Boolean && (Boolean)isValid != false;
            }
        };
        return filter;
    }

    protected String getValidationHasSuccessesFilterName() {
        return FILTER_NAME_VALIDATION_HAS_SUCCESSES;
    }

    protected Filter getValidationHasSuccessesFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasSuccesses = validationResultMap.get("hasSuccesses");
                return hasSuccesses != null && hasSuccesses instanceof Boolean && (Boolean)hasSuccesses != false;
            }
        };
        return filter;
    }

    protected String getValidationHasWarningsFilterName() {
        return FILTER_NAME_VALIDATION_HAS_WARNINGS;
    }

    protected Filter getValidationHasWarningsFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasWarnings = validationResultMap.get("hasWarnings");
                return hasWarnings != null && hasWarnings instanceof Boolean && (Boolean)hasWarnings != false;
            }
        };
        return filter;
    }

    protected String getValidationHasErrorsFilterName() {
        return FILTER_NAME_VALIDATION_HAS_ERRORS;
    }

    protected Filter getValidationHasErrorsFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof Map)) {
                    return false;
                }
                Map validationResultMap = (Map)value;
                Object hasErrors = validationResultMap.get("hasErrors");
                return hasErrors != null && hasErrors instanceof Boolean && (Boolean)hasErrors != false;
            }
        };
        return filter;
    }

    protected String getGetFilterName() {
        return "get";
    }

    protected Filter getGetFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object value, Map<String, Object> args) {
                if (value == null || !(value instanceof String)) {
                    return null;
                }
                String key = (String)value;
                Map spincastMap = (Map)SpincastMainPebbleExtensionDefault.this.getModelElement(args, "spincast");
                if (spincastMap == null) {
                    return null;
                }
                JsonObject paramsAsJsonObject = (JsonObject)spincastMap.get(SpincastPebbleTemplatingEngine.PEBBLE_PARAMS_AS_JSONOBJECT);
                if (paramsAsJsonObject == null) {
                    return null;
                }
                Object result = paramsAsJsonObject.getObject(key, "");
                if (result instanceof JsonObject) {
                    return ((JsonObject)result).convertToPlainMap();
                }
                if (result instanceof JsonArray) {
                    return ((JsonArray)result).convertToPlainList();
                }
                return result;
            }
        };
        return filter;
    }

    protected String getNewlineToBrFilterName() {
        return FILTER_NAME_ESCAPE_BUT_REPLACE_NEWLINE_BY_BR;
    }

    protected Filter getNewlineToBrFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("escape");
            }

            @Override
            public Object apply(Object textObj, Map<String, Object> args) {
                boolean escape = true;
                Object escapeObj = args.get("escape");
                if (escapeObj != null && escapeObj instanceof Boolean) {
                    escape = (Boolean)escapeObj;
                }
                String text = "";
                if (textObj != null) {
                    text = textObj.toString();
                    if (escape) {
                        text = StringEscapeUtils.escapeHtml4(text);
                    }
                    text = text.replaceAll("(\r\n|\n)", "<br />\n");
                }
                return new SafeString(text);
            }
        };
        return filter;
    }

    protected String getBooleanFilterName() {
        return FILTER_NAME_BOOLEAN;
    }

    protected Filter getBooleanFilter() {
        DefaultFilter filter = new DefaultFilter(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object apply(Object obj, Map<String, Object> args) {
                if (obj == null) {
                    return false;
                }
                String str = obj.toString();
                return Boolean.valueOf(str);
            }
        };
        return filter;
    }

    protected String getGetFunctionName() {
        return "get";
    }

    protected Function getGetFunction() {
        return new Function(){

            @Override
            public List<String> getArgumentNames() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("jsonPath");
                return names;
            }

            @Override
            public Object execute(Map<String, Object> args) {
                String key = (String)args.get("jsonPath");
                if (StringUtils.isBlank(key)) {
                    return null;
                }
                Map spincastMap = (Map)SpincastMainPebbleExtensionDefault.this.getModelElement(args, "spincast");
                if (spincastMap == null) {
                    return null;
                }
                JsonObject paramsAsJsonObject = (JsonObject)spincastMap.get(SpincastPebbleTemplatingEngine.PEBBLE_PARAMS_AS_JSONOBJECT);
                if (paramsAsJsonObject == null) {
                    return null;
                }
                Object result = paramsAsJsonObject.getObject(key, "");
                if (result instanceof JsonObject) {
                    return ((JsonObject)result).convertToPlainMap();
                }
                if (result instanceof JsonArray) {
                    return ((JsonArray)result).convertToPlainList();
                }
                return result;
            }
        };
    }

    protected String getJsOneLinerOutputFunctionName() {
        return FUNCTION_NAME_VALIDATION_JS_ONE_LINE;
    }

    protected Function getJsOneLinerOutputFunction() {
        return new Function(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object execute(Map<String, Object> args) {
                Object codeObj = args.get("0");
                if (codeObj == null) {
                    return "";
                }
                String code = codeObj.toString();
                if (StringUtils.isBlank(code)) {
                    return "";
                }
                Boolean singleQuotesDelimiter = false;
                Object arg1 = args.get("1");
                if (arg1 != null && arg1 instanceof Boolean) {
                    singleQuotesDelimiter = (Boolean)args.get("1");
                }
                String codeFormatted = SpincastMainPebbleExtensionDefault.this.getSpincastUtils().inQuotesStringFormat(code, singleQuotesDelimiter);
                return new SafeString(codeFormatted);
            }
        };
    }

    protected String getMessageFunctionName() {
        return FUNCTION_NAME_MESSAGE;
    }

    protected Function getMessageFunction() {
        return new Function(){

            @Override
            public List<String> getArgumentNames() {
                return null;
            }

            @Override
            public Object execute(Map<String, Object> args) {
                if (args == null || args.size() == 0) {
                    return "";
                }
                Object firstArg = args.get("1");
                boolean forceEvaluation = false;
                if (firstArg != null && firstArg instanceof Boolean) {
                    forceEvaluation = (Boolean)firstArg;
                    args.remove("1");
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                String msgKey = null;
                String paramKey = null;
                for (Map.Entry<String, Object> entry : args.entrySet()) {
                    String key = entry.getKey();
                    String val = String.valueOf(entry.getValue());
                    if (!key.matches("^\\d+$")) continue;
                    if (msgKey == null) {
                        msgKey = val;
                        continue;
                    }
                    if (paramKey == null) {
                        paramKey = val;
                        continue;
                    }
                    params.put(paramKey, val);
                    paramKey = null;
                }
                if (paramKey != null) {
                    throw new RuntimeException("A value is missing for one of the key of the custom 'msg' Pebble function... The key without value is : \"" + paramKey + "\"");
                }
                if (params.size() == 0 && !forceEvaluation) {
                    params = null;
                }
                return SpincastMainPebbleExtensionDefault.this.getDictionary().get(msgKey, params);
            }
        };
    }

    protected String getQuerystringAppendFunctionName() {
        return FUNCTION_NAME_QUERYSTRING_APPEND;
    }

    protected Function getQuerystringAppendFunction() {
        return new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("querystringToAppend");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                String[] querystringTokens;
                Object querystringToAppendObj = args.get("querystringToAppend");
                if (querystringToAppendObj == null) {
                    return "";
                }
                String querystring = querystringToAppendObj.toString();
                if (StringUtils.isBlank(querystring = StringUtils.stripStart(querystring, "?&"))) {
                    return "";
                }
                HashMap<Object, Object> currentQueryStringParams = new HashMap();
                try {
                    RequestContext<?> context = SpincastMainPebbleExtensionDefault.this.getRequestContextProvider().get();
                    HashMap<String, List<String>> temp = new HashMap<String, List<String>>(context.request().getQueryStringParams());
                    if (temp != null) {
                        currentQueryStringParams = temp;
                    }
                }
                catch (OutOfScopeException | ProvisionException context) {
                    // empty catch block
                }
                LinkedHashMap newQueryStringParams = new LinkedHashMap();
                for (String qsToken : querystringTokens = querystring.split("&")) {
                    String[] keyVal;
                    if (StringUtils.isBlank(qsToken) || (keyVal = qsToken.split("=")) == null || keyVal.length != 2) continue;
                    String key = keyVal[0];
                    String val = keyVal[1];
                    if (StringUtils.isBlank(key)) continue;
                    currentQueryStringParams.remove(key);
                    ArrayList<String> vals = (ArrayList<String>)newQueryStringParams.get(key);
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        newQueryStringParams.put(key, vals);
                    }
                    val = SpincastMainPebbleExtensionDefault.this.encodeQuerystringValue(val);
                    vals.add(val);
                }
                LinkedHashMap finalQueryStringParams = new LinkedHashMap();
                for (Map.Entry entry : currentQueryStringParams.entrySet()) {
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    if (values == null || values.size() == 0) continue;
                    ArrayList<String> valuesEncoded = new ArrayList<String>();
                    for (String value : values) {
                        value = SpincastMainPebbleExtensionDefault.this.encodeQuerystringValue(value);
                        valuesEncoded.add(value);
                    }
                    finalQueryStringParams.put(key, valuesEncoded);
                }
                finalQueryStringParams.putAll(newQueryStringParams);
                StringBuilder builder = new StringBuilder("?");
                for (Map.Entry entry : finalQueryStringParams.entrySet()) {
                    String key = (String)entry.getKey();
                    List vals = (List)entry.getValue();
                    for (String val : vals) {
                        builder.append(key).append("=").append(val).append("&");
                    }
                }
                builder = builder.deleteCharAt(builder.length() - 1);
                return new SafeString(builder.toString());
            }
        };
    }

    protected String encodeQuerystringValue(String value) {
        if (value == null) {
            return "";
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
        return value;
    }
}

