/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.validation.ValidationLevel;
import org.spincast.core.validation.ValidationMessage;

public class ValidationMessageDefault
implements ValidationMessage {
    private final JsonManager jsonManager;
    private final ValidationLevel validationLevel;
    private final String code;
    private final String text;
    private final boolean htmlEscape;
    private JsonObject jsonObjectVersion;

    @AssistedInject
    public ValidationMessageDefault(@Assisted(value="validationLevel") ValidationLevel validationLevel, @Assisted(value="code") String code, @Assisted(value="text") String text, @Assisted(value="htmlEscape") boolean htmlEscape, JsonManager jsonManager) {
        this.validationLevel = validationLevel;
        this.code = code;
        this.text = text;
        this.htmlEscape = htmlEscape;
        this.jsonManager = jsonManager;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isHtmlEscape() {
        return this.htmlEscape;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public boolean isWarning() {
        return this.getValidationLevel() == ValidationLevel.WARNING;
    }

    @Override
    public boolean isSuccess() {
        return this.getValidationLevel() == ValidationLevel.SUCCESS;
    }

    @Override
    public boolean isError() {
        return this.getValidationLevel() == ValidationLevel.ERROR;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    @Override
    public JsonObject convertToJsonObject() {
        if (this.jsonObjectVersion == null) {
            JsonObject obj = this.getJsonManager().create();
            obj.set("code", this.getCode());
            obj.set("level", this.getValidationLevel().toString());
            obj.set("text", this.getText());
            obj.set("htmlEscape", this.isHtmlEscape());
            this.jsonObjectVersion = obj.clone(false);
        }
        return this.jsonObjectVersion;
    }

    public String toString() {
        return this.getCode() + " - " + this.getText();
    }
}

