/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketController;
import org.spincast.core.websocket.WebsocketRoute;

public class SpincastWebsocketRoute<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements WebsocketRoute<R, W> {
    private final String id;
    private final boolean spicastCoreRouteOrPluginRoute;
    private final String path;
    private final List<Handler<R>> beforeFilters;
    private final Set<String> filterIdsToSkip;
    private final WebsocketController<R, W> websocketController;
    private final Set<String> classes;

    @AssistedInject
    public SpincastWebsocketRoute(@Assisted(value="isSpicastCoreRouteOrPluginRoute") boolean spicastCoreRouteOrPluginRoute, @Assisted(value="id") @Nullable String id, @Assisted(value="path") String path, @Assisted(value="before") @Nullable List<Handler<R>> beforeFilters, @Assisted(value="filterIdsToSkip") @Nullable Set<String> filterIdsToSkip, @Assisted(value="controller") WebsocketController<R, W> websocketController, @Assisted(value="classes") Set<String> classes) {
        this.spicastCoreRouteOrPluginRoute = spicastCoreRouteOrPluginRoute;
        this.id = id;
        this.path = path;
        this.beforeFilters = beforeFilters;
        this.filterIdsToSkip = filterIdsToSkip;
        this.websocketController = websocketController;
        this.classes = classes;
    }

    @Override
    public boolean isSpicastCoreRouteOrPluginRoute() {
        return this.spicastCoreRouteOrPluginRoute;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getClasses() {
        return this.classes;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<Handler<R>> getBeforeFilters() {
        return this.beforeFilters;
    }

    @Override
    public Set<String> getFilterIdsToSkip() {
        return this.filterIdsToSkip;
    }

    @Override
    public WebsocketController<R, W> getWebsocketController() {
        return this.websocketController;
    }

    public String toString() {
        return "Websocket route - " + (String)(this.getId() != null ? this.getId() + " - " : "") + this.getPath();
    }
}

