/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.routing;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.RedirectRuleBuilder;
import org.spincast.core.routing.Route;
import org.spincast.core.routing.RouteBuilder;
import org.spincast.core.routing.RoutingResult;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.routing.StaticResource;
import org.spincast.core.routing.StaticResourceBuilder;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketRoute;
import org.spincast.core.websocket.WebsocketRouteBuilder;

public interface Router<R extends RequestContext<?>, W extends WebsocketContext<?>> {
    public static final String DEFAULT_ROUTE_PATH = "/*{path}";

    public RouteBuilder<R> GET(String var1);

    public RouteBuilder<R> POST(String var1);

    public RouteBuilder<R> PUT(String var1);

    public RouteBuilder<R> DELETE(String var1);

    public RouteBuilder<R> OPTIONS(String var1);

    public RouteBuilder<R> TRACE(String var1);

    public RouteBuilder<R> HEAD(String var1);

    public RouteBuilder<R> PATCH(String var1);

    public RouteBuilder<R> ALL(String var1);

    public RouteBuilder<R> SOME(String var1, Set<HttpMethod> var2);

    public RouteBuilder<R> SOME(String var1, HttpMethod ... var2);

    public RouteBuilder<R> before();

    public RouteBuilder<R> before(String var1);

    public RouteBuilder<R> after();

    public RouteBuilder<R> after(String var1);

    public RouteBuilder<R> beforeAndAfter();

    public RouteBuilder<R> beforeAndAfter(String var1);

    public void exception(Handler<R> var1);

    public void exception(String var1, Handler<R> var2);

    public void notFound(Handler<R> var1);

    public void notFound(String var1, Handler<R> var2);

    public StaticResourceBuilder<R> file(String var1);

    public StaticResourceBuilder<R> dir(String var1);

    public void cors();

    public void cors(Set<String> var1);

    public void cors(Set<String> var1, Set<String> var2);

    public void cors(Set<String> var1, Set<String> var2, Set<String> var3);

    public void cors(Set<String> var1, Set<String> var2, Set<String> var3, boolean var4);

    public void cors(Set<String> var1, Set<String> var2, Set<String> var3, boolean var4, Set<HttpMethod> var5);

    public void cors(Set<String> var1, Set<String> var2, Set<String> var3, boolean var4, Set<HttpMethod> var5, int var6);

    public void cors(String var1);

    public void cors(String var1, Set<String> var2);

    public void cors(String var1, Set<String> var2, Set<String> var3);

    public void cors(String var1, Set<String> var2, Set<String> var3, Set<String> var4);

    public void cors(String var1, Set<String> var2, Set<String> var3, Set<String> var4, boolean var5);

    public void cors(String var1, Set<String> var2, Set<String> var3, Set<String> var4, boolean var5, Set<HttpMethod> var6);

    public void cors(String var1, Set<String> var2, Set<String> var3, Set<String> var4, boolean var5, Set<HttpMethod> var6, int var7);

    public void addStaticResource(StaticResource<R> var1);

    public RoutingResult<R> route(R var1);

    public RoutingResult<R> route(R var1, RoutingType var2);

    public void addRoute(Route<R> var1);

    public void removeAllRoutes();

    public void removeAllRoutes(boolean var1);

    public void removeRoute(String var1);

    public Route<R> getRoute(String var1);

    public List<Route<R>> getGlobalBeforeFiltersRoutes();

    public List<Route<R>> getMainRoutes();

    public List<Route<R>> getGlobalAfterFiltersRoutes();

    public void addRouteParamPatternAlias(String var1, String var2);

    public Map<String, String> getRouteParamPatternAliases();

    public void httpAuth(String var1, String var2);

    public WebsocketRouteBuilder<R, W> websocket(String var1);

    public void addWebsocketRoute(WebsocketRoute<R, W> var1);

    public RedirectRuleBuilder redirect(String var1);
}

