/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.client.ClientRequest;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.TruncatedResponseException;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

final class HttpRequestConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final Logger log = Logger.getLogger("io.undertow.client.request");
    private final ByteBufferPool pool;
    private int state = 1;
    private Iterator<HttpString> nameIterator;
    private String string;
    private HttpString headerName;
    private Iterator<String> valueIterator;
    private int charIndex;
    private PooledByteBuffer pooledBuffer;
    private final ClientRequest request;
    private static final int STATE_BODY = 0;
    private static final int STATE_START = 1;
    private static final int STATE_HDR_NAME = 2;
    private static final int STATE_HDR_D = 3;
    private static final int STATE_HDR_DS = 4;
    private static final int STATE_HDR_VAL = 5;
    private static final int STATE_HDR_EOL_CR = 6;
    private static final int STATE_HDR_EOL_LF = 7;
    private static final int STATE_HDR_FINAL_CR = 8;
    private static final int STATE_HDR_FINAL_LF = 9;
    private static final int STATE_BUF_FLUSH = 10;
    private static final int MASK_STATE = 15;
    private static final int FLAG_SHUTDOWN = 16;

    HttpRequestConduit(StreamSinkConduit next, ByteBufferPool pool, ClientRequest request) {
        super(next);
        this.pool = pool;
        this.request = request;
    }

    /*
     * Unable to fully structure code
     */
    private int processWrite(int state, ByteBuffer userData) throws IOException {
        if (state == 1) {
            this.pooledBuffer = this.pool.allocate();
        }
        request = this.request;
        buffer = this.pooledBuffer.getBuffer();
        nameIterator = this.nameIterator;
        valueIterator = this.valueIterator;
        charIndex = this.charIndex;
        string = this.string;
        headerName = this.headerName;
        if (state != 1 && buffer.hasRemaining()) {
            HttpRequestConduit.log.trace("Flushing remaining buffer");
            do {
                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                return state;
            } while (buffer.hasRemaining());
        }
        buffer.clear();
        block14: while (true) {
            switch (state) {
                case 0: {
                    return state;
                }
                case 1: {
                    HttpRequestConduit.log.trace("Starting request");
                    if (!HttpRequestConduit.$assertionsDisabled && buffer.remaining() < 50) {
                        throw new AssertionError();
                    }
                    request.getMethod().appendTo(buffer);
                    buffer.put((byte)32);
                    string = request.getPath();
                    length = string.length();
                    for (charIndex = 0; charIndex < length; ++charIndex) {
                        buffer.put((byte)string.charAt(charIndex));
                    }
                    buffer.put((byte)32);
                    request.getProtocol().appendTo(buffer);
                    buffer.put((byte)13).put((byte)10);
                    headers = request.getRequestHeaders();
                    nameIterator = headers.getHeaderNames().iterator();
                    if (!nameIterator.hasNext()) {
                        HttpRequestConduit.log.trace("No request headers");
                        buffer.put((byte)13).put((byte)10);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            res = ((StreamSinkConduit)this.next).write(buffer);
                            if (res != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 10;
                        }
                        this.pooledBuffer.close();
                        this.pooledBuffer = null;
                        HttpRequestConduit.log.trace("Body");
                        return 0;
                    }
                    headerName = nameIterator.next();
                    charIndex = 0;
                }
                case 2: {
                    HttpRequestConduit.log.tracef("Processing header '%s'", (Object)headerName);
                    length = headerName.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put(headerName.byteAt(charIndex++));
                            continue;
                        }
                        HttpRequestConduit.log.trace("Buffer flush");
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            HttpRequestConduit.log.trace("Continuation");
                            return 2;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                case 3: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 3;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)58);
                }
                case 4: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 4;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)32);
                    if (valueIterator == null) {
                        valueIterator = request.getRequestHeaders().get(headerName).iterator();
                    }
                    if (!HttpRequestConduit.$assertionsDisabled && !valueIterator.hasNext()) {
                        throw new AssertionError();
                    }
                    string = valueIterator.next();
                    charIndex = 0;
                }
                case 5: {
                    HttpRequestConduit.log.tracef("Processing header value '%s'", (Object)string);
                    length = string.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)string.charAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            HttpRequestConduit.log.trace("Continuation");
                            return 5;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    charIndex = 0;
                    if (!valueIterator.hasNext()) {
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 6;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 7;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        if (nameIterator.hasNext()) {
                            headerName = nameIterator.next();
                            valueIterator = null;
                            state = 2;
                            continue block14;
                        }
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 8;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 9;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        this.nameIterator = null;
                        this.valueIterator = null;
                        this.string = null;
                        buffer.flip();
                        if (userData == null) {
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 10;
                            } while (buffer.hasRemaining());
                        } else {
                            b = new ByteBuffer[]{buffer, userData};
                            do {
                                if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                                HttpRequestConduit.log.trace("Continuation");
                                return 10;
                            } while (buffer.hasRemaining());
                        }
                        this.pooledBuffer.close();
                        this.pooledBuffer = null;
                        HttpRequestConduit.log.trace("Body");
                        return 0;
                    }
                }
                case 6: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 6;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 7: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 7;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    if (valueIterator.hasNext()) {
                        state = 2;
                        continue block14;
                    }
                    if (nameIterator.hasNext()) {
                        headerName = nameIterator.next();
                        valueIterator = null;
                        state = 2;
                        continue block14;
                    }
                }
                case 8: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 8;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 9: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            HttpRequestConduit.log.trace("Continuation");
                            return 9;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    this.nameIterator = null;
                    this.valueIterator = null;
                    this.string = null;
                    buffer.flip();
                    if (userData != null) ** GOTO lbl297
                    do {
                        if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                        HttpRequestConduit.log.trace("Continuation");
                        return 10;
                    } while (buffer.hasRemaining());
                    ** GOTO lbl303
lbl297:
                    // 1 sources

                    b = new ByteBuffer[]{buffer, userData};
                    do {
                        if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                        HttpRequestConduit.log.trace("Continuation");
                        return 10;
                    } while (buffer.hasRemaining());
                }
lbl303:
                // 3 sources

                case 10: {
                    this.pooledBuffer.close();
                    this.pooledBuffer = null;
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        log.trace("write");
        int oldState = this.state;
        int state = oldState & 0xF;
        int alreadyWritten = 0;
        int originalRemaining = -1;
        try {
            if (state != 0) {
                originalRemaining = src.remaining();
                if ((state = this.processWrite(state, src)) != 0) {
                    int n = 0;
                    return n;
                }
                alreadyWritten = originalRemaining - src.remaining();
                if (Bits.allAreSet(oldState, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            if (alreadyWritten != originalRemaining) {
                int n = ((StreamSinkConduit)this.next).write(src) + alreadyWritten;
                return n;
            }
            int n = alreadyWritten;
            return n;
        }
        finally {
            this.state = oldState & 0xFFFFFFF0 | state;
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        log.trace("write");
        if (length == 0) {
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = length == 1 ? (long)((StreamSinkConduit)this.next).write(srcs[offset]) : ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        log.trace("transfer");
        if (count == 0L) {
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(src, position, count);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        log.trace("transfer");
        if (count == 0L) {
            throughBuffer.clear().limit(0);
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        log.trace("flush");
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    log.trace("Flush false because headers aren't written yet");
                    boolean bl = false;
                    return bl;
                }
                if (Bits.allAreSet(oldVal, 16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
            }
            log.trace("Delegating flush");
            boolean bl = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        log.trace("shutdown");
        int oldVal = this.state;
        if (Bits.allAreClear(oldVal, 15)) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        this.state = oldVal | 0x10;
    }

    @Override
    public void truncateWrites() throws IOException {
        log.trace("close");
        int oldVal = this.state;
        if (Bits.allAreClear(oldVal, 15)) {
            try {
                ((StreamSinkConduit)this.next).truncateWrites();
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.close();
                    this.pooledBuffer = null;
                }
            }
            return;
        }
        this.state = oldVal & 0xFFFFFFF0 | 0x10 | 0;
        throw new TruncatedResponseException();
    }

    @Override
    public XnioWorker getWorker() {
        return ((StreamSinkConduit)this.next).getWorker();
    }
}

