/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.server.protocol.http.JDK8HackAlpnOpenListener;
import io.undertow.server.protocol.http.JDK9AlpnOpenListener;
import io.undertow.server.protocol.http.JettyAlpnOpenListener;
import io.undertow.util.ALPN;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public class AlpnOpenListener
implements ChannelListener<StreamConnection>,
OpenListener {
    private final AlpnDelegateListener delegate;

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this(new XnioByteBufferPool(bufferPool), undertowOptions, fallbackProtocol, fallbackListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool) {
        this(bufferPool, OptionMap.EMPTY, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        if (ALPN.JDK_9_ALPN_METHODS != null) {
            this.delegate = new JDK9AlpnOpenListener(bufferPool, undertowOptions, fallbackProtocol, fallbackListener);
        } else if (JDK8HackAlpnOpenListener.ENABLED) {
            AlpnDelegateListener delegate;
            try {
                delegate = new JDK8HackAlpnOpenListener(bufferPool, undertowOptions, fallbackProtocol, fallbackListener);
            }
            catch (Throwable e) {
                UndertowLogger.ROOT_LOGGER.debug("JDK8 ALPN Hack failed ", e);
                delegate = new JettyAlpnOpenListener(bufferPool, undertowOptions, fallbackProtocol, fallbackListener);
            }
            this.delegate = delegate;
        } else {
            this.delegate = new JettyAlpnOpenListener(bufferPool, undertowOptions, fallbackProtocol, fallbackListener);
        }
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.delegate.getRootHandler();
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.delegate.setRootHandler(rootHandler);
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.delegate.getUndertowOptions();
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        this.delegate.setUndertowOptions(undertowOptions);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.delegate.getBufferPool();
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        return this.delegate.getConnectorStatistics();
    }

    public AlpnOpenListener addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.delegate.addProtocol(name, listener, weight);
        return this;
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        this.delegate.handleEvent(channel);
    }

    static interface AlpnDelegateListener
    extends OpenListener {
        public void addProtocol(String var1, DelegateOpenListener var2, int var3);
    }

    private static class ListenerEntry {
        DelegateOpenListener listener;
        int weight;

        ListenerEntry(DelegateOpenListener listener, int weight) {
            this.listener = listener;
            this.weight = weight;
        }
    }
}

