/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.variables;

import com.google.inject.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.VariablesRequestContextAddon;
import org.spincast.core.json.JsonObject;

public class SpincastVariablesRequestContextAddon<R extends RequestContext<?>>
implements VariablesRequestContextAddon<R> {
    private final Map<String, Object> requestScopedVariables = new HashMap<String, Object>();

    @Override
    public void add(String key, Object obj) {
        this.getRequestScopedVariables().put(key, obj);
    }

    @Override
    public void add(Map<String, Object> variables) {
        if (variables == null) {
            return;
        }
        this.getRequestScopedVariables().putAll(variables);
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.getRequestScopedVariables());
    }

    protected Map<String, Object> getRequestScopedVariables() {
        return this.requestScopedVariables;
    }

    @Override
    public Object get(String key) {
        return this.getRequestScopedVariables().get(key);
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        Object asT = this.get(key);
        return (T)asT;
    }

    @Override
    public <T> T get(String key, Key<T> typeKey) {
        return this.get(key, typeKey.getTypeLiteral().getRawType());
    }

    @Override
    public JsonObject getAsJsonObject(String key) {
        Object obj = this.getRequestScopedVariables().get(key);
        if (obj == null) {
            return null;
        }
        return (JsonObject)obj;
    }

    @Override
    public String getAsString(String key) {
        Object obj = this.getRequestScopedVariables().get(key);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public void remove(String key) {
        this.getRequestScopedVariables().remove(key);
    }
}

