/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.plugins.config.SpincastConfigPluginModule;

public class SpincastConfigPlugin
extends SpincastPluginBase {
    public static final String PLUGIN_ID = SpincastConfigPlugin.class.getName();

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    @Override
    public Module apply(Module module) {
        Class<SpincastConfig> specificConfigImplClass = null;
        GuiceModuleUtils guiceModuleUtils = new GuiceModuleUtils(module);
        Set<Class<SpincastConfig>> classes = guiceModuleUtils.getBoundClassesExtending(SpincastConfig.class);
        if (classes.size() > 0) {
            Class<SpincastConfig> temp;
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + SpincastConfig.class.getName() + " has been found. Bindings found :\n";
                for (Class<SpincastConfig> clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            specificConfigImplClass = temp = classes.iterator().next();
        }
        Module pluginModule = this.getPluginModule(specificConfigImplClass);
        this.setContextTypes(pluginModule);
        module = Modules.override(module).with(pluginModule);
        return module;
    }

    protected Module getPluginModule(Class<? extends SpincastConfig> specificConfigImplClass) {
        return new SpincastConfigPluginModule(specificConfigImplClass);
    }
}

