/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.filters;

import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.CorsFilterClient;
import org.spincast.core.filters.CorsFilterResponse;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class CorsFilterDefault
implements CorsFilter {
    protected static final Logger logger = LoggerFactory.getLogger(CorsFilterDefault.class);

    @Override
    public CorsFilterResponse apply(CorsFilterClient corsFilterClient) {
        Objects.requireNonNull(corsFilterClient, "corsFilterClient can't be NULL");
        String origin = corsFilterClient.getHeaderFirst("Origin");
        if (origin == null) {
            return CorsFilterResponse.NOT_CORS;
        }
        String host = corsFilterClient.getHeaderFirst("Host");
        if (host != null) {
            try {
                String originHost = new URI(origin).getHost();
                if (host.equals(originHost)) {
                    return CorsFilterResponse.NOT_CORS;
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        if (corsFilterClient.isHeadersSent()) {
            String message = "Headers already sent: if this is a cors request, it will fail. The request URL is: " + corsFilterClient.getFullUrl();
            if (corsFilterClient.getHeaderFirst("Access-Control-Request-Method") != null) {
                logger.error(message);
            } else {
                logger.info(message);
            }
            return CorsFilterResponse.HEADERS_ALREADY_SENT;
        }
        Set<String> allowedOrigins = corsFilterClient.getAllowedOrigins();
        HashSet<String> allowedOriginsLowercased = new HashSet<String>();
        if (allowedOrigins == null) {
            allowedOrigins = new HashSet<String>();
        }
        for (String allowedOrigin : allowedOrigins) {
            if (allowedOrigin == null) continue;
            allowedOriginsLowercased.add(allowedOrigin.toLowerCase().trim());
        }
        Set<String> extraHeadersAllowedToBeRead = corsFilterClient.getExtraHeadersAllowedToBeRead();
        HashSet<String> extraHeadersAllowedToBeReadLowercased = new HashSet<String>();
        if (extraHeadersAllowedToBeRead == null) {
            extraHeadersAllowedToBeRead = new HashSet<String>();
        }
        for (String headerAllowedToBeRead : extraHeadersAllowedToBeRead) {
            if (headerAllowedToBeRead == null) continue;
            extraHeadersAllowedToBeReadLowercased.add(headerAllowedToBeRead.toLowerCase().trim());
        }
        Set<String> extraHeadersAllowedToBeSent = corsFilterClient.getExtraHeadersAllowedToBeSent();
        HashSet<String> extraHeadersAllowedToBeSentLowercased = new HashSet<String>();
        if (extraHeadersAllowedToBeSent == null) {
            extraHeadersAllowedToBeSent = new HashSet<String>();
        }
        for (String extraHeaderAllowedToBeSent : extraHeadersAllowedToBeSent) {
            if (extraHeaderAllowedToBeSent == null) continue;
            extraHeadersAllowedToBeSentLowercased.add(extraHeaderAllowedToBeSent.toLowerCase().trim());
        }
        Set<HttpMethod> allowedMethods = corsFilterClient.getAllowedMethods();
        if (allowedMethods == null) {
            allowedMethods = new HashSet<HttpMethod>();
        }
        allowedMethods.add(HttpMethod.OPTIONS);
        if (!this.isCorsOriginValid(corsFilterClient, allowedOriginsLowercased)) {
            corsFilterClient.resetEverything();
            corsFilterClient.setStatusCode(200);
            logger.info("Invalid origin for a cors request : " + origin);
            return CorsFilterResponse.INVALID_CORS_REQUEST;
        }
        if (!this.isPreflightRequest(corsFilterClient)) {
            this.corsCore(corsFilterClient, allowedOrigins, corsFilterClient.isAllowCookies());
            this.corsAddExtraHeadersAllowedToBeRead(corsFilterClient, extraHeadersAllowedToBeRead);
            return CorsFilterResponse.SIMPLE;
        }
        corsFilterClient.resetEverything();
        corsFilterClient.setStatusCode(200);
        boolean preflightRequestValid = true;
        if (!this.isCorsRequestMethodHeaderValid(corsFilterClient, allowedMethods)) {
            logger.info("Invalid 'Access-Control-Allow-Methods' cors header received : " + corsFilterClient.getHeaderFirst("Access-Control-Request-Method"));
            preflightRequestValid = false;
        }
        if (preflightRequestValid && !this.isCorsRequestedHeadersToBeSentValid(corsFilterClient, extraHeadersAllowedToBeSentLowercased)) {
            logger.info("Invalid 'Access-Control-Request-Headers' cors header received : " + corsFilterClient.getHeaderFirst("Access-Control-Request-Headers"));
            preflightRequestValid = false;
        }
        if (preflightRequestValid) {
            this.corsCore(corsFilterClient, allowedOrigins, corsFilterClient.isAllowCookies());
            this.corsAddAllowMethods(corsFilterClient, allowedMethods);
            this.corsAddExtraHeadersAllowedToBeSent(corsFilterClient, extraHeadersAllowedToBeSent);
            this.corsAddMaxAge(corsFilterClient, corsFilterClient.getMaxAgeInSeconds());
        }
        return CorsFilterResponse.PREFLIGHT;
    }

    protected boolean isCorsOriginValid(CorsFilterClient corsFilterClient, Set<String> allowedOriginsLowercased) {
        if (allowedOriginsLowercased.contains("*")) {
            return true;
        }
        String origin = corsFilterClient.getHeaderFirst("Origin").toLowerCase();
        return allowedOriginsLowercased.contains(origin);
    }

    protected void corsCore(CorsFilterClient corsFilterClient, Set<String> allowedOrigins, boolean allowCookies) {
        this.corsAddAllowOrigin(corsFilterClient);
        if (allowCookies) {
            this.corsAddAllowCookies(corsFilterClient);
        }
    }

    protected boolean isCorsRequestMethodHeaderValid(CorsFilterClient corsFilterClient, Set<HttpMethod> allowedMethods) {
        if (allowedMethods == null || allowedMethods.size() == 0) {
            return false;
        }
        String accessControlRequestMethodsStr = corsFilterClient.getHeaderFirst("Access-Control-Request-Method");
        if (accessControlRequestMethodsStr == null) {
            return false;
        }
        String[] accessControlRequestMethods = StringUtils.split(accessControlRequestMethodsStr, ",");
        if (accessControlRequestMethods == null || accessControlRequestMethods.length == 0) {
            return false;
        }
        for (String accessControlRequestMethod : accessControlRequestMethods) {
            HttpMethod method = HttpMethod.fromStringValue(accessControlRequestMethod);
            if (method == null) {
                return false;
            }
            if (allowedMethods.contains((Object)method)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCorsRequestedHeadersToBeSentValid(CorsFilterClient corsFilterClient, Set<String> extraHeadersAllowedToBeSentLowercased) {
        String requestedHeadersStr = corsFilterClient.getHeaderFirst("Access-Control-Request-Headers");
        if (requestedHeadersStr == null) {
            return true;
        }
        String[] requestedHeaders = StringUtils.split(requestedHeadersStr, ",");
        if (requestedHeaders == null || requestedHeaders.length == 0) {
            return true;
        }
        if (extraHeadersAllowedToBeSentLowercased.contains("*")) {
            return true;
        }
        if (extraHeadersAllowedToBeSentLowercased == null || extraHeadersAllowedToBeSentLowercased.size() == 0) {
            return false;
        }
        for (String requestedHeader : requestedHeaders) {
            if (extraHeadersAllowedToBeSentLowercased.contains(requestedHeader.toLowerCase().trim())) continue;
            return false;
        }
        return true;
    }

    protected boolean isPreflightRequest(CorsFilterClient corsFilterClient) {
        String accessControlRequestMethod;
        HttpMethod httpMethod = corsFilterClient.getHttpMethod();
        return httpMethod == HttpMethod.OPTIONS && (accessControlRequestMethod = corsFilterClient.getHeaderFirst("Access-Control-Request-Method")) != null;
    }

    protected void corsAddExtraHeadersAllowedToBeRead(CorsFilterClient corsFilterClient, Set<String> extraHeadersAllowedToBeRead) {
        String extraHeadersAllowedToBeReadStr = "";
        if (extraHeadersAllowedToBeRead != null && extraHeadersAllowedToBeRead.size() > 0) {
            extraHeadersAllowedToBeReadStr = StringUtils.join(extraHeadersAllowedToBeRead, ",");
        }
        corsFilterClient.addHeaderValue("Access-Control-Expose-Headers", extraHeadersAllowedToBeReadStr);
    }

    protected void corsAddExtraHeadersAllowedToBeSent(CorsFilterClient corsFilterClient, Set<String> extraHeadersAllowedToBeSent) {
        String extraHeadersAllowedToBeSentStr = "";
        if (extraHeadersAllowedToBeSent != null && extraHeadersAllowedToBeSent.size() > 0) {
            if (extraHeadersAllowedToBeSent.contains("*")) {
                String requestedHeadersStr = corsFilterClient.getHeaderFirst("Access-Control-Request-Headers");
                if (!StringUtils.isBlank(requestedHeadersStr)) {
                    extraHeadersAllowedToBeSentStr = requestedHeadersStr;
                }
            } else {
                extraHeadersAllowedToBeSentStr = StringUtils.join(extraHeadersAllowedToBeSent, ",");
            }
        } else {
            Set<String> defaultExtraHeadersAllowedToBeSent = this.getDefaultHeadersAllowedToBeSent();
            if (defaultExtraHeadersAllowedToBeSent != null && defaultExtraHeadersAllowedToBeSent.size() > 0) {
                extraHeadersAllowedToBeSentStr = StringUtils.join(defaultExtraHeadersAllowedToBeSent, ",");
            }
        }
        corsFilterClient.addHeaderValue("Access-Control-Allow-Headers", extraHeadersAllowedToBeSentStr);
    }

    protected Set<String> getDefaultHeadersAllowedToBeSent() {
        return null;
    }

    protected void corsAddMaxAge(CorsFilterClient corsFilterClient, int maxAgeInSeconds) {
        if (maxAgeInSeconds > 0) {
            corsFilterClient.addHeaderValue("Access-Control-Max-Age", String.valueOf(maxAgeInSeconds));
        }
    }

    protected void corsAddAllowMethods(CorsFilterClient corsFilterClient, Set<HttpMethod> allowedMethods) {
        if (allowedMethods == null || allowedMethods.size() == 0) {
            return;
        }
        String allowedMethodsStr = StringUtils.join(allowedMethods, ",");
        corsFilterClient.addHeaderValue("Access-Control-Allow-Methods", allowedMethodsStr);
    }

    protected void corsAddAllowCookies(CorsFilterClient corsFilterClient) {
        corsFilterClient.addHeaderValue("Access-Control-Allow-Credentials", "true");
    }

    protected void corsAddAllowOrigin(CorsFilterClient corsFilterClient) {
        String allowedOriginsStr = corsFilterClient.getHeaderFirst("Origin");
        corsFilterClient.addHeaderValue("Access-Control-Allow-Origin", allowedOriginsStr);
        corsFilterClient.addHeaderValue("Vary", "Origin");
    }
}

