/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.demos.sum;

import org.spincast.core.exceptions.PublicExceptionDefault;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.json.JsonObject;
import org.spincast.demos.sum.AppController;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppControllerDefault
implements AppController {
    @Override
    public void sumRoute(DefaultRequestContext context) {
        long sum;
        String error;
        block11: {
            int secondInt;
            int firstInt;
            String firstNbr = context.request().getFormBodyAsJsonObject().getString("first");
            if (StringUtils.isBlank(firstNbr)) {
                throw new PublicExceptionDefault("The 'first' post parameter is required.", 400);
            }
            String secondNbr = context.request().getFormBodyAsJsonObject().getString("second");
            if (StringUtils.isBlank(secondNbr)) {
                throw new PublicExceptionDefault("The 'second' post parameter is required.", 400);
            }
            error = null;
            sum = 0L;
            try {
                firstInt = Integer.parseInt(firstNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            try {
                secondInt = Integer.parseInt(secondNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            sum = (long)firstInt + (long)secondInt;
            if (sum > Integer.MAX_VALUE) {
                error = "The sum overflows the maximum integer value, 2147483647";
            } else if (sum < Integer.MIN_VALUE) {
                error = "The sum overflows the minimum integer value, -2147483648";
            }
        }
        JsonObject resultObj = context.json().create();
        if (error != null) {
            context.response().setStatusCode(400);
            resultObj.set("error", error);
        } else {
            resultObj.set("result", String.valueOf(sum));
        }
        context.response().sendJson(resultObj);
    }
}

