/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.attemptslimiter;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.spincast.plugins.attemptslimiter.Attempt;
import org.spincast.plugins.attemptslimiter.AttemptCriteria;
import org.spincast.plugins.attemptslimiter.SpincastAttemptsLimiterPluginRepository;

public class AttemptDefault
implements Attempt {
    private final boolean maxReached;
    private final String actionName;
    private final AttemptCriteria[] criterias;
    private final SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPlguinRepository;
    private boolean attemptsCountIncremented = false;

    @AssistedInject
    public AttemptDefault(SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPlguinRepository, @Assisted boolean maxReached, @Assisted String actionName, AttemptCriteria ... criterias) {
        this.spincastAttemptsLimiterPlguinRepository = spincastAttemptsLimiterPlguinRepository;
        this.maxReached = maxReached;
        this.actionName = actionName;
        this.criterias = criterias;
    }

    protected SpincastAttemptsLimiterPluginRepository getSpincastAttemptsLimiterPluginRepository() {
        return this.spincastAttemptsLimiterPlguinRepository;
    }

    public String getActionName() {
        return this.actionName;
    }

    public AttemptCriteria[] getCriterias() {
        return this.criterias;
    }

    @Override
    public boolean isMaxReached() {
        return this.maxReached;
    }

    @Override
    public void incrementAttemptsCount() {
        if (this.attemptsCountIncremented) {
            return;
        }
        this.attemptsCountIncremented = true;
        this.getSpincastAttemptsLimiterPluginRepository().saveNewAttempt(this.getActionName(), this.getCriterias());
    }

    @Override
    public void deleteAttempts() {
        this.getSpincastAttemptsLimiterPluginRepository().deleteAttempts(this.getActionName(), this.getCriterias());
    }

    public String toString() {
        return this.getActionName() + (this.isMaxReached() ? " - max reached!" : " - allowed");
    }
}

