/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.attemptslimiter;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.spincast.plugins.attemptslimiter.Attempt;
import org.spincast.plugins.attemptslimiter.AttemptCriteria;
import org.spincast.plugins.attemptslimiter.SpincastAttemptsLimiterPluginRepository;
import org.spincast.plugins.attemptslimiter.config.SpincastAttemptsLimiterPluginConfig;

public class AttemptDefault
implements Attempt {
    private final boolean maxReached;
    private final String actionName;
    private final AttemptCriteria[] criterias;
    private final SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPlguinRepository;
    private final SpincastAttemptsLimiterPluginConfig spincastAttemptsLimiterPluginConfig;
    private boolean attemptsCountIncremented = false;

    @AssistedInject
    public AttemptDefault(SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPlguinRepository, SpincastAttemptsLimiterPluginConfig spincastAttemptsLimiterPluginConfig, @Assisted boolean maxReached, @Assisted String actionName, AttemptCriteria ... criterias) {
        this.spincastAttemptsLimiterPlguinRepository = spincastAttemptsLimiterPlguinRepository;
        this.spincastAttemptsLimiterPluginConfig = spincastAttemptsLimiterPluginConfig;
        this.maxReached = maxReached;
        this.actionName = actionName;
        this.criterias = criterias;
    }

    protected SpincastAttemptsLimiterPluginRepository getSpincastAttemptsLimiterPluginRepository() {
        return this.spincastAttemptsLimiterPlguinRepository;
    }

    protected SpincastAttemptsLimiterPluginConfig getSpincastAttemptsLimiterPluginConfig() {
        return this.spincastAttemptsLimiterPluginConfig;
    }

    public String getActionName() {
        return this.actionName;
    }

    public AttemptCriteria[] getCriterias() {
        return this.criterias;
    }

    @Override
    public boolean isMaxReached() {
        return this.getSpincastAttemptsLimiterPluginConfig().isValidationEnabled() && this.maxReached;
    }

    @Override
    public void incrementAttemptsCount() {
        if (this.attemptsCountIncremented) {
            return;
        }
        this.attemptsCountIncremented = true;
        this.getSpincastAttemptsLimiterPluginRepository().saveNewAttempt(this.getActionName(), this.getCriterias());
    }

    @Override
    public void deleteAttempts() {
        this.getSpincastAttemptsLimiterPluginRepository().deleteAttempts(this.getActionName(), this.getCriterias());
    }

    public String toString() {
        return this.getActionName() + (this.isMaxReached() ? " - max reached!" : " - allowed");
    }
}

