/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.attemptslimiter;

import com.google.inject.Inject;
import java.time.Instant;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.spincast.plugins.attemptslimiter.AttemptRule;
import org.spincast.plugins.attemptslimiter.AttemptsManager;
import org.spincast.plugins.attemptslimiter.SpincastAttemptsLimiterPluginRepository;
import org.spincast.plugins.attemptslimiter.config.SpincastAttemptsLimiterPluginConfig;
import org.spincast.plugins.scheduledtasks.SpincastScheduledTaskBase;

public class DeleteOldAttemptsScheduledTask
extends SpincastScheduledTaskBase {
    private final SpincastAttemptsLimiterPluginConfig spincastAttemptsLimiterPluginConfig;
    private final SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPluginRepository;
    private final AttemptsManager attemptsManager;

    @Inject
    public DeleteOldAttemptsScheduledTask(SpincastAttemptsLimiterPluginConfig spincastAttemptsLimiterPluginConfig, SpincastAttemptsLimiterPluginRepository spincastAttemptsLimiterPluginRepository, AttemptsManager attemptsManager) {
        this.spincastAttemptsLimiterPluginConfig = spincastAttemptsLimiterPluginConfig;
        this.spincastAttemptsLimiterPluginRepository = spincastAttemptsLimiterPluginRepository;
        this.attemptsManager = attemptsManager;
    }

    protected SpincastAttemptsLimiterPluginConfig getSpincastAttemptsLimiterPluginConfig() {
        return this.spincastAttemptsLimiterPluginConfig;
    }

    protected SpincastAttemptsLimiterPluginRepository getSpincastAttemptsLimiterPluginRepository() {
        return this.spincastAttemptsLimiterPluginRepository;
    }

    protected AttemptsManager getAttemptsManager() {
        return this.attemptsManager;
    }

    public Trigger getTrigger() {
        return TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(this.getSpincastAttemptsLimiterPluginConfig().getDeleteOldAttemptsScheduledTaskIntervalMinutes()).repeatForever()).build();
    }

    protected void executeSafe(JobExecutionContext context) {
        for (Map.Entry<String, AttemptRule> entry : this.getAttemptsManager().getAttemptRulesByActionName().entrySet()) {
            Instant beforeDate = Instant.now().minus(entry.getValue().getDuration());
            this.getSpincastAttemptsLimiterPluginRepository().deleteAttemptsOlderThan(entry.getKey(), beforeDate);
        }
    }
}

